/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.icc.render.obj;

import com.adobe.icc.dbforms.obj.MimeType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Content
implements Serializable {
    private static final long serialVersionUID = -1007770388652182720L;
    private ModuleType moduleType;
    private byte[] data;
    private String toolTip;
    private int moduleIdent;
    private MimeType mimeType;
    private String moduleId;
    private boolean empty;
    private Object[][] lineage;
    private boolean originalNoPageBreak;
    private boolean originalKeepWithNext;
    private boolean noPageBreak;
    private boolean keepWithNext;
    private Set<String> parentKeepWithNext = new HashSet<String>();
    private List<Map<String, String>> listStartInfo = new ArrayList<Map<String, String>>();
    public static final String LIST_STYLE_KEY = "ListStyle";
    public static final String LIST_STYLE_TYPE_KEY = "ListStyleType";
    public static final String LIST_STYLE_COMPOUND_KEY = "ListStyleCompound";
    private List<String> listEndInfo = new ArrayList<String>();
    private double indentationLevel;
    private boolean skipListStyle = false;

    public Content(ModuleType moduleType, byte[] data, String toolTip, MimeType mimeType, String moduleId) {
        this.moduleType = moduleType;
        this.data = data;
        this.toolTip = toolTip;
        this.mimeType = mimeType;
        this.moduleId = moduleId;
        this.empty = false;
        this.lineage = null;
    }

    public Content(ModuleType moduleType, byte[] data, String toolTip, MimeType mimeType, String moduleId, boolean empty) {
        this.moduleType = moduleType;
        this.data = data;
        this.toolTip = toolTip;
        this.mimeType = mimeType;
        this.moduleId = moduleId;
        this.empty = empty;
        this.lineage = null;
    }

    public Content(ModuleType moduleType, byte[] data, String toolTip, MimeType mimeType, String moduleId, boolean empty, Vector<Object> ancestry) {
        this(moduleType, data, toolTip, mimeType, moduleId, empty, ancestry, 0);
    }

    public Content(ModuleType moduleType, byte[] data, String toolTip, MimeType mimeType, String moduleId, boolean empty, Vector<Object> ancestry, int moduleIdent) {
        this.moduleType = moduleType;
        this.data = data;
        this.toolTip = toolTip;
        this.mimeType = mimeType;
        this.moduleId = moduleId;
        this.empty = empty;
        this.lineage = null;
        this.moduleIdent = moduleIdent;
        this.applyAncestry(ancestry);
    }

    public ModuleType getModuleType() {
        return this.moduleType;
    }

    public void setModuleType(ModuleType moduleType) {
        this.moduleType = moduleType;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(String toolTip) {
        this.toolTip = toolTip;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(MimeType mimeType) {
        this.mimeType = mimeType;
    }

    public Byte[] getDataArray() {
        if (this.data == null) {
            return null;
        }
        Byte[] dataArray = new Byte[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            dataArray[i] = this.data[i];
        }
        return dataArray;
    }

    public void setDataArray(Byte[] dataArray) {
        if (dataArray == null) {
            this.data = null;
        } else {
            this.data = new byte[dataArray.length];
            for (int i = 0; i < dataArray.length; ++i) {
                this.data[i] = dataArray[i];
            }
        }
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public Object[][] getLineage() {
        return this.lineage;
    }

    public void setLineage(Object[][] lineage) {
        this.lineage = (Object[][])lineage.clone();
    }

    public int getModuleIdent() {
        return this.moduleIdent;
    }

    public void setModuleIdent(int moduleIdent) {
        this.moduleIdent = moduleIdent;
    }

    public void applyAncestry(Vector<Object> ancestry) {
        if (ancestry != null && ancestry.size() > 0) {
            this.lineage = new Object[ancestry.size()][2];
            for (int i = 0; i < ancestry.size(); ++i) {
                Vector props = (Vector)ancestry.get(i);
                if (props.size() != 2) continue;
                Vector clone = new Vector();
                clone.setSize(props.size());
                Collections.copy(clone, props);
                this.lineage[i] = clone.toArray();
            }
        } else {
            this.lineage = null;
        }
    }

    public boolean isOriginalNoPageBreak() {
        return this.originalNoPageBreak;
    }

    public void setOriginalNoPageBreak(boolean originalNoPageBreak) {
        this.originalNoPageBreak = originalNoPageBreak;
    }

    public boolean isOriginalKeepWithNext() {
        return this.originalKeepWithNext;
    }

    public void setOriginalKeepWithNext(boolean originalKeepWithNext) {
        this.originalKeepWithNext = originalKeepWithNext;
    }

    public boolean isNoPageBreak() {
        return this.noPageBreak;
    }

    public void setNoPageBreak(boolean noPageBreak) {
        this.noPageBreak = noPageBreak;
    }

    public boolean isKeepWithNext() {
        return this.keepWithNext;
    }

    public void setKeepWithNext(boolean keepWithNext) {
        this.keepWithNext = keepWithNext;
    }

    public Set<String> getParentKeepWithNext() {
        return this.parentKeepWithNext;
    }

    public void setParentKeepWithNext(Set<String> parentKeepWithNext) {
        this.parentKeepWithNext = parentKeepWithNext;
    }

    public List<Map<String, String>> getListStartInfo() {
        return this.listStartInfo;
    }

    public void setListStartInfo(List<Map<String, String>> listStartInfo) {
        this.listStartInfo = listStartInfo;
    }

    public List<String> getListEndInfo() {
        return this.listEndInfo;
    }

    public void setListEndInfo(List<String> listEndInfo) {
        this.listEndInfo = listEndInfo;
    }

    public double getIndentationLevel() {
        return this.indentationLevel;
    }

    public void setIndentationLevel(double indentationLevel) {
        this.indentationLevel = indentationLevel;
    }

    public boolean isSkipListStyle() {
        return this.skipListStyle;
    }

    public void setSkipListStyle(boolean skipListStyle) {
        this.skipListStyle = skipListStyle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ModuleType {
        TEXT("text"),
        IMAGE("image"),
        CONTENT("content");

        private String value;

        private ModuleType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

