/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.icc.dbforms.util;

import com.adobe.icc.dbforms.exceptions.ICCException;
import com.adobe.livecycle.content.sling.ResourceResolverHolder;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRSessionUtils {
    private static final Logger logger = LoggerFactory.getLogger(JCRSessionUtils.class);

    public static void saveSession() {
        Session currentSession = JCRSessionUtils.getCurrentSession();
        try {
            if (currentSession != null && currentSession.hasPendingChanges()) {
                currentSession.save();
            }
        }
        catch (Exception e) {
            throw new ICCException("ALC-ACM-002-013", 1, e);
        }
    }

    public static void rollbackCurrentSession() {
        Session currentSession = JCRSessionUtils.getCurrentSession();
        try {
            if (currentSession != null) {
                currentSession.refresh(false);
            }
        }
        catch (Exception e) {
            logger.error("Error during session refresh", (Throwable)e);
        }
    }

    public static void checkWritePermission(String resourceId) {
        try {
            AccessControlManager accessControlManager = JCRSessionUtils.getCurrentSession().getAccessControlManager();
            if (!accessControlManager.hasPrivileges(resourceId, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}write")})) {
                throw new ICCException("ALC-ACM-001-001", 1);
            }
        }
        catch (Exception e) {
            throw new ICCException("ALC-ACM-002-013", 1, e);
        }
    }

    public static Session getCurrentSession() {
        try {
            ResourceResolver currentResourceResolver = ResourceResolverHolder.getResourceResolver();
            if (currentResourceResolver != null) {
                Session session = (Session)currentResourceResolver.adaptTo(Session.class);
                return session;
            }
            return null;
        }
        catch (Exception e) {
            throw new ICCException("ALC-ACM-002-013", 1, e);
        }
    }
}

