/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.icc.dbforms.exceptions;

import com.adobe.icc.dbforms.exceptions.ExceptionMessages;

public class ICCException
extends RuntimeException {
    private static final long serialVersionUID = 7892215536673714890L;
    private String[] messageArgs;
    private String messageCode;

    public ICCException() {
    }

    public ICCException(String message) {
        super(message);
    }

    public ICCException(Throwable cause) {
        super(cause);
    }

    public ICCException(String message, Throwable cause) {
        super(message, cause);
    }

    public ICCException(String resourceID, int severity, boolean log, Throwable cause) {
        this(resourceID + ": " + ExceptionMessages.getString(resourceID), cause);
        this.messageCode = resourceID;
        if (log) {
            ExceptionMessages.logMessage(this.getClass(), severity, resourceID, null, cause);
        }
    }

    public ICCException(String resourceID, String[] args, int severity, boolean log, Throwable cause) {
        this(resourceID + ": " + ExceptionMessages.getString(resourceID, args), cause);
        this.messageArgs = args;
        this.messageCode = resourceID;
        if (log) {
            ExceptionMessages.logMessage(this.getClass(), severity, resourceID, args, cause);
        }
    }

    public ICCException(String resourceID, int severity, boolean log) {
        this(resourceID + ": " + ExceptionMessages.getString(resourceID));
        this.messageCode = resourceID;
        if (log) {
            ExceptionMessages.logMessage(this.getClass(), severity, resourceID);
        }
    }

    public ICCException(String resourceID, String[] args, int severity, boolean log) {
        this(resourceID + ": " + ExceptionMessages.getString(resourceID, args));
        this.messageArgs = args;
        this.messageCode = resourceID;
        if (log) {
            ExceptionMessages.logMessage(this.getClass(), severity, resourceID, args);
        }
    }

    public ICCException(String resourceID, int severity) {
        this(resourceID + ": " + ExceptionMessages.getString(resourceID));
        this.messageCode = resourceID;
        ExceptionMessages.logMessage(this.getClass(), severity, resourceID);
    }

    public ICCException(String resourceID, String[] args, int severity) {
        this(resourceID + ": " + ExceptionMessages.getString(resourceID, args));
        this.messageArgs = args;
        this.messageCode = resourceID;
        ExceptionMessages.logMessage(this.getClass(), severity, resourceID, args);
    }

    public ICCException(String resourceID, int severity, Throwable cause) {
        this(resourceID + ": " + ExceptionMessages.getString(resourceID), cause);
        this.messageCode = resourceID;
        ExceptionMessages.logMessage(this.getClass(), severity, resourceID, null, cause);
    }

    public ICCException(String resourceID, String[] args, int severity, Throwable cause) {
        this(resourceID + ": " + ExceptionMessages.getString(resourceID, args), cause);
        this.messageArgs = args;
        this.messageCode = resourceID;
        ExceptionMessages.logMessage(this.getClass(), severity, resourceID, args, cause);
    }

    public String[] getMessageArgs() {
        return this.messageArgs;
    }

    public void setMessageArgs(String[] messageArg) {
        this.messageArgs = messageArg;
    }

    public String getMessageCode() {
        return this.messageCode;
    }

    public void setMessageCode(String messageCode) {
        this.messageCode = messageCode;
    }
}

