/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.icc.dbforms.exceptions;

import com.adobe.icc.dbforms.exceptions.ICCException;
import com.adobe.livecycle.content.activate.exception.VersionRestoreException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;

public class ExceptionUtils {
    public static ICCException repositoryExceptionToICCException(com.adobe.livecycle.content.repository.exception.RepositoryException repositoryException) throws ICCException {
        Throwable nestedException;
        Throwable cause = repositoryException.getCause();
        for (int i = 0; cause != null && i < 5; cause = cause.getCause(), ++i) {
            if (!(cause instanceof ICCException)) continue;
            ICCException iccException = (ICCException)cause;
            throw iccException;
        }
        String errCode = repositoryException.getErrorCode();
        if (errCode.equals("LCC-REP-FCT-050") ? (nestedException = repositoryException.getCause()) != null && nestedException.getMessage() != null && nestedException.getMessage().startsWith("invalid identifier:") : errCode.equals("LCC-REP-FCT-004")) {
            throw new ICCException("ALC-ACM-002-036", 1, (Throwable)repositoryException);
        }
        throw new ICCException("ALC-ACM-002-013", 1, (Throwable)repositoryException);
    }

    public static ICCException exceptionToICCException(Exception exception) throws ICCException {
        Throwable cause = exception.getCause();
        for (int i = 0; cause != null && i < 5; cause = cause.getCause(), ++i) {
            if (!(cause instanceof ICCException)) continue;
            ICCException iccException = (ICCException)cause;
            throw iccException;
        }
        if (exception instanceof VersionRestoreException) {
            VersionRestoreException vreEx;
            Throwable vreCause = exception.getCause();
            if (vreCause != null) {
                if (vreCause instanceof RepositoryException && vreCause.getMessage() != null && vreCause.getMessage().startsWith("Absolute path expected.")) {
                    throw new ICCException("ALC-ACM-002-036", 1, exception);
                }
                if (vreCause instanceof PathNotFoundException) {
                    throw new ICCException("ALC-ACM-002-036", 1, exception);
                }
            }
            if ((vreEx = (VersionRestoreException)exception).getErrorCode() != null && vreEx.getErrorCode().equals("LCC-PUB-VER-015") && vreEx.getMessage() != null && vreEx.getMessage().contains("has not enough privileges")) {
                throw new ICCException("ALC-ACM-002-036", 1, exception);
            }
        }
        throw new ICCException("ALC-ACM-002-013", 1, exception);
    }
}

