/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.signatures.pki.client.spi;

import com.adobe.fd.signatures.pki.cert.CertificateProviderInterface;
import com.adobe.fd.signatures.pki.client.CertificateInfo;
import com.adobe.fd.signatures.pki.client.PKIFactoryInterface;
import com.adobe.fd.signatures.pki.client.PKIInterface;
import com.adobe.fd.signatures.pki.client.RevocationInfoList;
import com.adobe.fd.signatures.pki.client.types.CacheType;
import com.adobe.fd.signatures.pki.client.types.prefs.PKIPreferences;
import com.adobe.fd.signatures.pki.impl.ExternalProviders;
import com.adobe.fd.signatures.pki.impl.PKIOperations;
import com.adobe.fd.signatures.pki.revocation.crl.CRLEnumeratorInterface;
import java.util.Arrays;
import java.util.Properties;

public class PKIFactoryImpl
implements PKIFactoryInterface {
    private CertificateProviderInterface[] certProvs = new CertificateProviderInterface[0];
    private CRLEnumeratorInterface[] crlProvs = new CRLEnumeratorInterface[0];

    public static PKIFactoryInterface getPKIFactory(CertificateProviderInterface[] certProvs, CRLEnumeratorInterface[] crlProvs) {
        return new PKIFactoryImpl(certProvs, crlProvs);
    }

    private PKIFactoryImpl(CertificateProviderInterface[] certProvs, CRLEnumeratorInterface[] crlProvs) {
        if (certProvs != null) {
            this.certProvs = Arrays.copyOf(certProvs, certProvs.length);
        }
        if (crlProvs != null) {
            this.crlProvs = Arrays.copyOf(crlProvs, crlProvs.length);
        }
    }

    public void ResetCaches(CacheType type, Properties props) {
        PKIOperations.reset((CacheType)type);
    }

    public PKIInterface getPKIInterface(PKIPreferences prefs, CertificateInfo[] inCerts, RevocationInfoList inRevocationInfo, boolean isFIPSMode) {
        ExternalProviders providers = new ExternalProviders();
        providers.setCertProviders(this.certProvs);
        providers.setCrlProviders(this.crlProvs);
        return new PKIOperations(prefs, providers, inCerts, inRevocationInfo, isFIPSMode);
    }

    public PKIInterface getPKIInterface(PKIPreferences prefs, boolean isFIPSMode) {
        return this.getPKIInterface(prefs, null, null, isFIPSMode);
    }
}

