/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.signatures.pki.client.spi;

import com.adobe.fd.signatures.pki.client.CertificateInfo;
import com.adobe.fd.signatures.pki.client.PKIException;
import com.adobe.fd.signatures.pki.client.spi.PKISignExecutor;
import com.adobe.fd.signatures.pki.client.spi.PKISigner;
import java.security.PrivateKey;

public abstract class PKICredential {
    private CertificateInfo certInfo;
    private CertificateInfo[] certInfoChain;
    private PrivateKey prvKey;
    private String prvKeyUnderstander;
    private boolean isInitialized;

    protected void initialize(CertificateInfo certInfoInit, CertificateInfo[] certInfoChainInit, PrivateKey prvKeyInit, String prvKeyUnderstanderInit) {
        if (this.isInitialized) {
            return;
        }
        if (certInfoInit == null) {
            throw new IllegalArgumentException("Cert Info can not be null");
        }
        this.certInfo = certInfoInit;
        this.certInfoChain = certInfoChainInit == null ? new CertificateInfo[]{certInfoInit} : certInfoChainInit;
        if (this.isRemotePrivateKey(prvKeyInit) && prvKeyUnderstanderInit == null) {
            throw new IllegalArgumentException("Private Key is not provided neither is the private key understander");
        }
        this.prvKey = prvKeyInit;
        this.prvKeyUnderstander = prvKeyUnderstanderInit;
        this.isInitialized = true;
    }

    public final Object execute(PKISigner signer) throws PKIException {
        assert (this.isInitialized);
        return this.executeSign(signer);
    }

    protected Object executeSign(PKISigner signer) throws PKIException {
        assert (this.isInitialized);
        return signer.sign(this.prvKey, this.prvKeyUnderstander);
    }

    public CertificateInfo getCertInfo() {
        assert (this.isInitialized);
        return this.certInfo;
    }

    public CertificateInfo[] getCertInfoChain() {
        assert (this.isInitialized);
        return this.certInfoChain;
    }

    public PrivateKey getPrvKey() {
        return this.prvKey;
    }

    public PKISignExecutor getSignExecutor() {
        return null;
    }

    public boolean isRemotePrivateKey() {
        assert (this.isInitialized);
        return this.isRemotePrivateKey(this.prvKey);
    }

    private boolean isRemotePrivateKey(PrivateKey key) {
        return key == null || key.getEncoded() == null || key.getEncoded().length == 0;
    }

    public String getPrivateKeyUnderstander() {
        assert (this.isInitialized);
        return this.prvKeyUnderstander;
    }
}

