/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dct.transfer;

import com.adobe.dct.exception.DCTException;
import com.adobe.dct.exception.LogLevels;
import com.adobe.dct.exception.MessageLogger;
import com.adobe.dct.transfer.DataDictionary;
import com.adobe.dct.transfer.DataDictionaryElement;
import com.adobe.dct.transfer.DataDictionaryElementType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataDictionaryInstance
implements Serializable {
    private static final long serialVersionUID = -5735672860442274994L;
    private Object object;
    private String dataDictionaryId;
    private DataDictionary dataDictionary;
    private byte[] compressedDDBytes;

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public String getDataDictionaryId() {
        return this.dataDictionaryId;
    }

    public void setDataDictionaryId(String dataDictionaryId) {
        this.dataDictionaryId = dataDictionaryId;
    }

    public DataDictionary getDataDictionary() {
        return this.dataDictionary;
    }

    public void setDataDictionary(DataDictionary dataDictionary) {
        this.dataDictionary = dataDictionary;
    }

    @Deprecated
    public Object getValue(String path) {
        Object value = null;
        Object object = this.object;
        if (path != null && object != null) {
            while (path != null && object != null && path.indexOf(".") > 0) {
                String elementName = path.substring(0, path.indexOf(".")).trim();
                path = path.substring(path.indexOf(".") + 1);
                if (object instanceof Map) {
                    object = ((Map)object).get(elementName);
                    continue;
                }
                return value;
            }
            if (path != null && path.length() > 0 && !path.equals(".")) {
                path = path.trim();
                if (object instanceof Map) {
                    value = ((Map)object).get(path);
                } else {
                    return value;
                }
            }
        }
        return value;
    }

    public Object getValue2(String ddElementKey) {
        if (this.dataDictionary == null || this.dataDictionary.getReferenceNameToPathMap() == null) {
            MessageLogger.logMessage(DataDictionaryInstance.class, LogLevels.LOG_ERROR, "ALC-DCT-002-057");
            return null;
        }
        String path = this.dataDictionary.getReferenceNameToPathMap().get(ddElementKey);
        if (path == null) {
            path = ddElementKey;
        }
        return this.getValueFromObject(this.object, path);
    }

    private Object getValueFromObject(Object object, String path) {
        ArrayList<Object> value = null;
        if (path != null && object != null) {
            String[] elementNames = path.split("\\.");
            for (int index = 0; index < elementNames.length; ++index) {
                String elementName = elementNames[index].trim();
                if (elementName.equals("")) continue;
                if (path == null || object == null) break;
                if (object instanceof Map) {
                    if (index < elementNames.length - 1) {
                        path = path.substring(path.indexOf(".") + 1);
                        object = ((Map)object).get(elementName);
                        continue;
                    }
                    value = ((Map)object).get(elementName);
                    return value;
                }
                if (!(object instanceof List)) continue;
                value = new ArrayList();
                Object tempObject = null;
                for (int i = 0; i < ((List)object).size(); ++i) {
                    tempObject = ((List)object).get(i);
                    ((List)value).add(this.getValueFromObject(tempObject, path));
                }
                return value;
            }
        }
        return value;
    }

    @Deprecated
    public void setValue(String path, Object value) {
        HashMap object = this.object;
        if (object == null) {
            this.object = object = new HashMap();
        }
        while (path != null && path.indexOf(".") > 0) {
            String elementName = path.substring(0, path.indexOf(".")).trim();
            path = path.substring(path.indexOf(".") + 1);
            if (object instanceof Map) {
                if (!((Map)object).containsKey(elementName)) {
                    ((Map)object).put(elementName, new HashMap());
                }
                object = ((Map)object).get(elementName);
                continue;
            }
            return;
        }
        if (path != null && path.trim().length() > 0 && !path.trim().equals(".")) {
            path = path.trim();
            if (object instanceof Map) {
                ((Map)object).put(path, value);
            } else {
                return;
            }
        }
    }

    public void setValue2(String ddElementKey, Object value) throws DCTException {
        if (this.dataDictionary == null || this.dataDictionary.getReferenceNameToPathMap() == null) {
            MessageLogger.logMessage(DataDictionaryInstance.class, LogLevels.LOG_ERROR, "ALC-DCT-002-057");
            return;
        }
        String path = this.dataDictionary.getReferenceNameToPathMap().get(ddElementKey);
        if (path == null) {
            path = ddElementKey;
        }
        DataDictionaryElement currentDDE = null;
        if (this.dataDictionary == null) {
            MessageLogger.logMessage(this.getClass(), LogLevels.LOG_ERROR, "ALC-DCT-002-057");
            throw new DCTException("ALC-DCT-002-057");
        }
        currentDDE = this.dataDictionary.getDDElements().get(0);
        this.setValueInObject(this.object, path, value, currentDDE);
    }

    private void setValueInObject(Object object, String path, Object value, DataDictionaryElement currentDDE) {
        if (path != null && object != null) {
            String[] elementNames = path.split("\\.");
            for (int index = 0; index < elementNames.length; ++index) {
                Object childObject;
                String elementName = elementNames[index].trim();
                if (elementName.equals("")) continue;
                if (path == null || object == null) break;
                if (index > 0) {
                    currentDDE = this.getChildByName(elementNames[index], currentDDE);
                }
                if (object instanceof Map) {
                    if (index < elementNames.length - 1) {
                        path = path.substring(path.indexOf(".") + 1);
                        childObject = ((Map)object).get(elementName);
                        if (childObject == null) {
                            if (currentDDE.getElementType() == DataDictionaryElementType.COMPOSITE) {
                                ((Map)object).put(elementName, new HashMap());
                            } else if (currentDDE.getElementType() == DataDictionaryElementType.COLLECTION) {
                                ((Map)object).put(elementName, new ArrayList());
                            } else {
                                return;
                            }
                        }
                        object = ((Map)object).get(elementName);
                        continue;
                    }
                    ((Map)object).put(elementName, value);
                    continue;
                }
                if (!(object instanceof List)) continue;
                childObject = null;
                Object tempValue = null;
                for (int i = 0; i < ((List)value).size(); ++i) {
                    int sz = ((List)object).size();
                    if (i >= sz) {
                        ((List)object).add(new HashMap());
                    }
                    childObject = ((List)object).get(i);
                    tempValue = ((List)value).get(i);
                    this.setValueInObject(childObject, path, tempValue, currentDDE);
                }
            }
        }
    }

    private DataDictionaryElement getChildByName(String name, DataDictionaryElement dde) {
        DataDictionaryElement childDDE = null;
        block0 : switch (dde.getElementType()) {
            case COMPOSITE: {
                for (DataDictionaryElement child : dde.getChildElements()) {
                    if (!child.getName().equals(name)) continue;
                    childDDE = child;
                    break block0;
                }
                break;
            }
            case COLLECTION: {
                if (dde.getCollectionElement().getElementType() != DataDictionaryElementType.COMPOSITE) break;
                childDDE = this.getChildByName(name, dde.getCollectionElement());
                break;
            }
        }
        return childDDE;
    }

    public byte[] getCompressedDDBytes() {
        return this.compressedDDBytes;
    }

    public void setCompressedDDBytes(byte[] compressedDDBytes) {
        this.compressedDDBytes = compressedDDBytes;
    }
}

