/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.KeyValueDataMerger;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentDataMerger
extends KeyValueDataMerger {
    protected XPath xPath;
    protected Document mergeReferenceDocument;
    protected String bindProperty;
    protected Object currentRepeatNode;
    protected String currentRepeatPath;
    private long uidCounter = System.nanoTime();

    public DocumentDataMerger(JSONObject guideJson, Document mergeReferenceDocument, Map<String, Object> params) {
        super(guideJson, params);
        this.xPath = XPathFactory.newInstance().newXPath();
        this.setBindProperty();
        this.mergeReferenceDocument = mergeReferenceDocument;
        this.currentRepeatNode = this.mergeReferenceDocument.getDocumentElement();
        this.currentRepeatPath = "";
    }

    protected void setBindProperty() {
        this.bindProperty = "name";
    }

    protected String getComputedBindProperty(JSONObject jsonObject) throws JSONException {
        String bindProp = jsonObject.getString(this.bindProperty);
        if (this.currentRepeatPath.length() > 0) {
            return this.currentRepeatPath + "/" + bindProp;
        }
        return bindProp;
    }

    protected boolean isInCurrentContext(String bindPath) {
        return StringUtils.isNotEmpty((String)this.currentRepeatPath) && bindPath.startsWith(this.currentRepeatPath);
    }

    protected String getRelativePath(String bindPath) {
        bindPath = StringUtils.substringAfter((String)bindPath, (String)this.currentRepeatPath);
        bindPath = GuideUtils.removePrefix(bindPath, "/");
        return bindPath;
    }

    protected String matchPrimitive(String relativePath, boolean isRepeatChild) throws Exception {
        Object bindNode;
        Object object = bindNode = isRepeatChild ? this.currentRepeatNode : this.mergeReferenceDocument.getDocumentElement();
        if (StringUtils.isNotEmpty((String)relativePath)) {
            return this.xPath.evaluate(relativePath, bindNode);
        }
        return null;
    }

    @Override
    public void updateMergedJson(JSONObject jsonObject) throws Exception {
        String bindPath = null;
        boolean isRepeatChild = false;
        if (jsonObject.has(this.bindProperty) && this.isInCurrentContext(bindPath = this.getComputedBindProperty(jsonObject))) {
            isRepeatChild = true;
            bindPath = this.getRelativePath(bindPath);
        }
        try {
            String value = this.matchPrimitive(bindPath, isRepeatChild);
            if (value != null && value.length() > 0) {
                this.jsonWriter.key("_value").value(value);
            }
        }
        catch (Exception e) {
            this.logger.error(e.toString(), (Throwable)e);
            throw new GuideException(e);
        }
    }

    protected Object getCurrentContext() {
        return this.currentRepeatNode;
    }

    protected void setCurrentContext(Object ctx) {
        this.currentRepeatNode = ctx;
    }

    protected String getCurrentContextPath() {
        return this.currentRepeatPath;
    }

    protected void setCurrentContextPath(String path) {
        this.currentRepeatPath = path;
    }

    protected Object matchComposite(String relativePath, String fullPath) throws Exception {
        NodeList currentRepeatNodeList = null;
        if (relativePath.length() == 0) {
            Element node = this.mergeReferenceDocument.getDocumentElement();
            currentRepeatNodeList = (NodeList)this.xPath.evaluate(fullPath, node, XPathConstants.NODESET);
        } else {
            currentRepeatNodeList = (NodeList)this.xPath.evaluate(relativePath, this.currentRepeatNode, XPathConstants.NODESET);
        }
        return currentRepeatNodeList;
    }

    protected int getMatchCount(Object match) {
        NodeList nodeList = (NodeList)match;
        return nodeList.getLength();
    }

    protected Object getMatchItem(Object match, int ith) {
        NodeList nodeList = (NodeList)match;
        return nodeList.item(ith);
    }

    protected void resetContext() {
        this.currentRepeatNode = this.mergeReferenceDocument.getDocumentElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void mergeJSONObject(JSONObject jsonObject) throws Exception {
        boolean handleDefault = true;
        int minOccur = 1;
        int maxOccur = 1;
        if (jsonObject.has("minOccur")) {
            minOccur = jsonObject.getInt("minOccur");
        }
        if (jsonObject.has("maxOccur") && (maxOccur = jsonObject.getInt("maxOccur")) == -1) {
            maxOccur = Integer.MAX_VALUE;
        }
        if (minOccur != 1 || maxOccur != 1) {
            Object originalRepeatNode = this.getCurrentContext();
            String originalXPath = this.getCurrentContextPath();
            String bindPath = this.getComputedBindProperty(jsonObject);
            String relativePath = this.getRelativePath(bindPath);
            Object currentMatch = this.matchComposite(relativePath, bindPath);
            this.setCurrentContextPath(bindPath);
            try {
                handleDefault = false;
                int originalRepeatCount = this.getMatchCount(currentMatch);
                int repeatCount = Math.max(originalRepeatCount, minOccur);
                repeatCount = Math.min(repeatCount, maxOccur);
                for (int i = 0; i < repeatCount; ++i) {
                    if (originalRepeatCount <= i) {
                        this.resetContext();
                    } else {
                        this.setCurrentContext(this.getMatchItem(currentMatch, i));
                    }
                    if (i > 0) {
                        String repeatKey = this.getUniqueKey(jsonObject);
                        this.jsonWriter.key(repeatKey).object();
                    }
                    super.mergeJSONObject(jsonObject);
                    if (i == repeatCount - 1) continue;
                    this.jsonWriter.endObject();
                }
            }
            finally {
                this.setCurrentContext(originalRepeatNode);
                this.setCurrentContextPath(originalXPath);
            }
        }
        if (handleDefault) {
            super.mergeJSONObject(jsonObject);
        }
    }

    private String getUniqueKey(JSONObject jsonObject) throws JSONException {
        String name = "";
        if (jsonObject.has("name")) {
            name = jsonObject.getString("name");
        }
        name = name + this.uidCounter++;
        return name;
    }
}

