/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.servlet;

import com.adobe.aemds.guide.common.GuideContainer;
import com.adobe.aemds.guide.common.GuideItemsContainer;
import com.adobe.aemds.guide.common.GuideNode;
import com.adobe.aemds.guide.common.GuidePanel;
import com.adobe.aemds.guide.service.GuideException;
import java.io.IOException;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"fd/af/components/guideContainer", "fd/af/components/guideFragmentContainer"}), @Property(name="sling.servlet.methods", value={"POST"}), @Property(name="service.description", value={"Guide XDP Synchronization Service"}), @Property(name="sling.servlet.selectors", value={"af.sync"})})
public class GuideSyncXDPServlet
extends SlingAllMethodsServlet {
    protected Logger logger = LoggerFactory.getLogger(GuideNode.class);

    private void syncNode(GuideNode node) throws GuideException {
        if (node instanceof GuideItemsContainer) {
            List<GuideNode> items = ((GuideItemsContainer)node).getItems();
            for (int i = 0; i < items.size(); ++i) {
                this.syncNode(items.get(i));
            }
        }
        if (node.isValid()) {
            node.syncNode();
        }
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        GuideContainer container = new GuideContainer();
        container.setResource(request.getResource());
        container.setSlingRequest(request);
        if (container.isGuideSyncRequired()) {
            GuidePanel rootPanel = container.getRootPanel();
            if (rootPanel != null) {
                try {
                    this.syncNode(rootPanel);
                }
                catch (GuideException ge) {
                    this.logger.error("AEMAF XDP Sync Failed " + ge.getMessage(), (Throwable)ge);
                    throw ge;
                }
            }
            Resource guideContainer = request.getResource();
            String guideContainerPath = guideContainer.getPath();
            ModifiableValueMap guideContainerMap = (ModifiableValueMap)guideContainer.adaptTo(ModifiableValueMap.class);
            guideContainerMap.remove((Object)"formModelChanged");
            guideContainer.getResourceResolver().commit();
            if (StringUtils.startsWith((CharSequence)guideContainerPath, (CharSequence)"/content/forms/af/")) {
                String metaDataPath = StringUtils.replace((String)guideContainerPath, (String)"/content/forms/af/", (String)"/content/dam/formsanddocuments/", (int)1);
                metaDataPath = StringUtils.replace((String)metaDataPath, (String)"/jcr:content/guideContainer", (String)"/jcr:content/metadata");
                Resource metadata = request.getResourceResolver().getResource(metaDataPath);
                if (metadata != null) {
                    ModifiableValueMap metadataMap = (ModifiableValueMap)metadata.adaptTo(ModifiableValueMap.class);
                    metadataMap.remove((Object)"formModelChanged");
                    metadata.getResourceResolver().commit();
                }
            }
        }
    }
}

