/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.servlet;

import com.adobe.aemds.guide.common.GuideValidationResult;
import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.service.GuideModelTransformer;
import com.adobe.aemds.guide.service.GuidePDFSubmitHelper;
import com.adobe.aemds.guide.service.GuideStoreContentSubmission;
import com.adobe.aemds.guide.service.external.GuideSubmitPostProcessor;
import com.adobe.aemds.guide.submitutils.FileRequestParameter;
import com.adobe.aemds.guide.submitutils.FormFieldRequestParameter;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.forms.common.service.FileAttachmentWrapper;
import com.adobe.forms.common.submitutils.CustomParameterRequest;
import com.adobe.forms.common.submitutils.CustomResponse;
import com.adobe.forms.common.submitutils.ParameterMap;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.foundation.forms.FormsHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.jcr.Session;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.osgi.ServiceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false)
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"fd/af/components/guideContainer"}), @Property(name="sling.servlet.methods", value={"POST"}), @Property(name="service.description", value={"Adaptive Form Submit"}), @Property(name="sling.servlet.selectors", value={"af.submit"})})
public class GuideSubmitServlet
extends SlingAllMethodsServlet {
    public static final String REQ_ATTR_FORWARD_PATH = "forward.path";
    public static final String REQ_ATTR_FORWARD_OPTIONS = "forward.options";
    public static final String REQUEST_ATTR_WORKFLOW_PATH = "Forms.workflow.path";
    public static final String REQUEST_ATTR_WORKFLOW_PAYLOAD_PATH = "Forms.workflow.payloadPath";
    public static final String REQUEST_ATTR_REDIRECT_PARAMETER_MAP = "redirectParameters";
    public static final String REQUEST_ATTR_PDF_NAME = "pdfName";
    private Logger logger = LoggerFactory.getLogger(GuideSubmitServlet.class);
    @Reference
    private GuideModelTransformer guideModelTransformer;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private GuidePDFSubmitHelper guidePDFSubmitHelper;
    @Reference
    private GuideStoreContentSubmission guideStoreContentSubmission;
    @Reference(name="guideSubmitPostProcessors", referenceInterface=GuideSubmitPostProcessor.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private Map<Comparable<Object>, GuideSubmitPostProcessor> guideSubmitPostProcessors = new ConcurrentSkipListMap(Collections.reverseOrder());

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String dataXML;
        List<FileAttachmentWrapper> fileAttachments;
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        try {
            String actionType;
            String guideContainerPath = request.getParameter("guideContainerPath");
            SlingHttpServletRequest wrappedRequest = request;
            boolean asyncSubmit = "true".equals(request.getParameter("_asyncSubmit"));
            ParameterMap wrappedParameterMap = this.addToNewRequest(wrappedRequest, response, asyncSubmit);
            if (request.getParameter("_useSignedPdf") != null) {
                wrappedParameterMap = this.guidePDFSubmitHelper.getWrappedParameterMapForPdfSubmit(request, response, wrappedParameterMap);
            }
            wrappedRequest = new CustomParameterRequest(request, wrappedParameterMap, "POST");
            Resource formResource = request.getResourceResolver().getResource(guideContainerPath);
            ValueMap properties = ResourceUtil.getValueMap((Resource)formResource);
            optionsMap.put("draftID", request.getParameter("draftID"));
            optionsMap.put("enablePortalSubmit", (String)properties.get("enablePortalSubmit", (Object)"false"));
            optionsMap.put("guideContainerPath", guideContainerPath);
            fileAttachments = this.getFileAttachmentWrapperList(wrappedParameterMap);
            dataXML = request.getParameter("jcr:data");
            if (((Boolean)properties.get("enableServerValidation", (Object)false)).booleanValue()) {
                GuideValidationResult guideValidationResult;
                String locale = request.getParameter("runtimeLocale");
                if (locale == null || "".equals(locale)) {
                    locale = "en";
                }
                if ((guideValidationResult = this.guideModelTransformer.validateData(dataXML, formResource, this.getServerUrl(request), locale, request.getContextPath())).hasErrors()) {
                    CustomParameterRequest wrappedErrorRequest = new CustomParameterRequest(request, wrappedParameterMap, "GET");
                    wrappedErrorRequest.setAttribute("guideErrorList", (Object)guideValidationResult);
                    wrappedErrorRequest.setAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME, (Object)WCMMode.DISABLED);
                    wrappedErrorRequest.setAttribute("data", (Object)request.getParameter("jcr:data"));
                    RequestDispatcherOptions options = new RequestDispatcherOptions();
                    options.setReplaceSuffix(null);
                    options.setReplaceSelectors(null);
                    request.getRequestDispatcher(request.getParameter(":selfUrl") + ".html", options).forward((ServletRequest)wrappedErrorRequest, (ServletResponse)response);
                    return;
                }
            }
            String string = actionType = properties == null ? "" : (String)properties.get("actionType", (Object)"");
            if (StringUtils.isEmpty((String)actionType)) {
                this.logger.warn("Author has not associated any submit action with the form.");
            }
            FormsHelper.runAction((String)actionType, (String)"post", (Resource)formResource, (SlingHttpServletRequest)wrappedRequest, (SlingHttpServletResponse)response);
            String redirectUrl = GuideSubmitServlet.getRedirectUrl(wrappedRequest);
            if (asyncSubmit || redirectUrl == null || redirectUrl.length() == 0) {
                redirectUrl = request.getResource().getPath() + "." + "guideAsyncThankYouPage.html";
                redirectUrl = this.prepareRedirectUrl(wrappedRequest, redirectUrl);
            } else if (redirectUrl != null && redirectUrl.length() > 0) {
                redirectUrl = this.prepareRedirectUrl(wrappedRequest, redirectUrl);
            }
            FormFieldRequestParameter rpm = new FormFieldRequestParameter(redirectUrl);
            RequestParameter[] f = new RequestParameter[]{rpm};
            GuideUtils.addToRequestMap(wrappedParameterMap, ":redirect", f);
            this.removeUnusedParameters(wrappedParameterMap);
            wrappedRequest = new CustomParameterRequest(request, wrappedParameterMap, "POST");
            String forwardPath = this.getForwardPath(wrappedRequest);
            if (forwardPath != null && forwardPath.length() > 0) {
                Resource forwardResource = wrappedRequest.getResourceResolver().resolve(forwardPath);
                request.getRequestDispatcher(forwardResource, this.getForwardOptions((ServletRequest)wrappedRequest)).forward((ServletRequest)wrappedRequest, (ServletResponse)response);
                ModifiableValueMap forwardResourceProperties = (ModifiableValueMap)forwardResource.adaptTo(ModifiableValueMap.class);
                if (forwardResource != null && forwardResourceProperties != null && forwardResourceProperties.containsKey((Object)"afStoreContentTempPermission")) {
                    forwardResourceProperties.remove((Object)"afStoreContentTempPermission");
                    request.getResourceResolver().commit();
                    this.guideStoreContentSubmission.unsetPrivilegesForStoreContent(GuideUtils.getUserSessionFromRequest(request), forwardPath);
                }
            } else {
                redirectUrl = request.getContextPath() + redirectUrl;
                response.sendRedirect(redirectUrl);
            }
        }
        catch (Exception e) {
            this.logger.error("Could not complete Submit Action due to " + e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
        for (GuideSubmitPostProcessor guideSubmitPostProcessor : this.guideSubmitPostProcessors.values()) {
            try {
                guideSubmitPostProcessor.handlePostProcess(dataXML, fileAttachments, optionsMap);
            }
            catch (Exception e) {
                this.logger.error("The current guideSubmitPostProcessor could not give path", (Throwable)e);
            }
        }
    }

    protected void bindGuideSubmitPostProcessors(GuideSubmitPostProcessor guideSubmitPostProcessor, Map<String, Object> config) {
        this.guideSubmitPostProcessors.put(ServiceUtil.getComparableForServiceRanking(config), guideSubmitPostProcessor);
    }

    protected void unbindGuideSubmitPostProcessors(GuideSubmitPostProcessor guideSubmitPostProcessor, Map<String, Object> config) {
        this.guideSubmitPostProcessors.remove(ServiceUtil.getComparableForServiceRanking(config));
    }

    private RequestDispatcherOptions getForwardOptions(ServletRequest req) {
        return (RequestDispatcherOptions)req.getAttribute(REQ_ATTR_FORWARD_OPTIONS);
    }

    private String getServerUrl(SlingHttpServletRequest req) {
        String scheme = req.getScheme();
        String serverName = req.getServerName();
        int serverPort = req.getServerPort();
        StringBuffer url = new StringBuffer();
        url.append(scheme).append("://").append(serverName);
        if (serverPort != 80 && serverPort != 443) {
            url.append(":").append(serverPort);
        }
        return url.toString();
    }

    private String getForwardPath(SlingHttpServletRequest req) {
        return (String)req.getAttribute(REQ_ATTR_FORWARD_PATH);
    }

    public static void setForwardPath(SlingHttpServletRequest req, String path, String selector, String suffix) {
        req.setAttribute(REQ_ATTR_FORWARD_PATH, (Object)path);
        if (selector != null || suffix != null) {
            RequestDispatcherOptions options = new RequestDispatcherOptions();
            if (selector != null) {
                options.setReplaceSelectors(selector);
            }
            if (suffix != null) {
                options.setReplaceSuffix(suffix);
            }
            req.setAttribute(REQ_ATTR_FORWARD_OPTIONS, (Object)options);
        }
    }

    private static String getRedirectUrl(SlingHttpServletRequest request) {
        String redirectUrl = null;
        redirectUrl = (String)request.getAttribute(":redirect");
        if (redirectUrl == null) {
            redirectUrl = request.getParameter(":redirect");
        }
        return redirectUrl;
    }

    public static void setRedirectUrl(SlingHttpServletRequest req, String redirectUrl) {
        req.setAttribute(":redirect", (Object)redirectUrl);
    }

    public static Map<String, String> getRedirectParameters(SlingHttpServletRequest request) {
        HashMap<String, String> redirectParameters = (HashMap<String, String>)request.getAttribute(REQUEST_ATTR_REDIRECT_PARAMETER_MAP);
        if (redirectParameters == null) {
            redirectParameters = new HashMap<String, String>();
            redirectParameters.put("status", "Submitted");
            String userid = ((Session)request.getResourceResolver().adaptTo(Session.class)).getUserID();
            int index = userid.lastIndexOf(58);
            if (index > 0 && index + 1 < userid.length()) {
                userid = userid.substring(index + 1);
            }
            redirectParameters.put("owner", userid);
        }
        return redirectParameters;
    }

    public static void setRedirectParameters(SlingHttpServletRequest request, Map<String, String> value) {
        request.setAttribute(REQUEST_ATTR_REDIRECT_PARAMETER_MAP, value);
    }

    public static String getReqAttrPdfName(SlingHttpServletRequest request) {
        return (String)request.getAttribute(REQUEST_ATTR_PDF_NAME);
    }

    public static void setRequestAttrPdfName(SlingHttpServletRequest request, String value) {
        request.setAttribute(REQUEST_ATTR_PDF_NAME, (Object)value);
    }

    private ParameterMap addToNewRequest(SlingHttpServletRequest request, SlingHttpServletResponse response, boolean asyncSubmit) {
        ParameterMap wrappedParameterMap = new ParameterMap();
        RequestParameterMap originalParams = request.getRequestParameterMap();
        ArrayList attachments = new ArrayList();
        for (Map.Entry param : originalParams.entrySet()) {
            RequestParameter rp = ((RequestParameter[])param.getValue())[0];
            boolean isFile = false;
            boolean bl = isFile = ((String)param.getKey()).indexOf("_guideFileAttachment.") != -1 && "_guideFileAttachment.".equals(((String)param.getKey()).substring(0, 21));
            if (!rp.isFormField()) {
                RequestParameter[] fileRpm = new RequestParameter[]{new FileRequestParameter(rp.getFileName(), rp.get(), rp.getContentType())};
                GuideUtils.addToRequestMap(wrappedParameterMap, (String)param.getKey(), fileRpm);
                continue;
            }
            if (!isFile) {
                GuideUtils.addToRequestMap(wrappedParameterMap, (String)param.getKey(), (RequestParameter[])param.getValue());
                continue;
            }
            String paramName = ((String)param.getKey()).substring(21);
            String filename = paramName.substring(paramName.indexOf("/") + 1);
            RequestParameter rpm = ((RequestParameter[])param.getValue())[0];
            RequestParameter[] fileRpm = new RequestParameter[1];
            String fileUrl = rpm.toString();
            String normalizedFileUrl = "";
            normalizedFileUrl = ResourceUtil.normalize((String)fileUrl);
            if (normalizedFileUrl == null) {
                this.logger.error("[AEMAF] Invalid Path in File Attachement " + fileUrl);
                throw new GuideException("Invalid Path in File Attachement " + fileUrl);
            }
            if (normalizedFileUrl.startsWith("/tmp/fd/af/")) {
                Resource fileResource = request.getResourceResolver().getResource(normalizedFileUrl);
                if (fileResource != null) {
                    fileRpm[0] = new FileRequestParameter(filename, fileResource);
                }
            } else {
                try {
                    ParameterMap newMap = new ParameterMap();
                    CustomParameterRequest newRequest = new CustomParameterRequest(request, newMap, "GET");
                    CustomResponse newResponse = new CustomResponse(response);
                    newRequest.getRequestDispatcher(normalizedFileUrl, new RequestDispatcherOptions()).forward((ServletRequest)newRequest, (ServletResponse)newResponse);
                    byte[] fileBytes = newResponse.getCopy();
                    String contentType = newResponse.getContentType();
                    fileRpm[0] = new FileRequestParameter(filename, fileBytes, contentType);
                }
                catch (Exception e) {
                    this.logger.error("[AEMAF]Error while hitting REST URL", (Throwable)e);
                    throw new GuideException(e);
                }
            }
            GuideUtils.addToRequestMap(wrappedParameterMap, paramName, fileRpm);
        }
        return wrappedParameterMap;
    }

    private List<FileAttachmentWrapper> getFileAttachmentWrapperList(ParameterMap parameterMap) {
        ArrayList<FileAttachmentWrapper> fileAttachments = new ArrayList<FileAttachmentWrapper>();
        for (Map.Entry param : parameterMap.entrySet()) {
            RequestParameter[] rpm = (RequestParameter[])param.getValue();
            if (rpm == null || rpm.length <= 0 || rpm[0].isFormField()) continue;
            FileAttachmentWrapper fileAttachment = new FileAttachmentWrapper(rpm[0].getFileName(), rpm[0].getContentType(), rpm[0].get());
            fileAttachments.add(fileAttachment);
        }
        return fileAttachments;
    }

    private String prepareRedirectUrl(SlingHttpServletRequest request, String redirectUrl) throws UnsupportedEncodingException {
        redirectUrl = redirectUrl.indexOf("?") == -1 ? redirectUrl + "?" : redirectUrl + "&";
        Map<String, String> redirectParameters = GuideSubmitServlet.getRedirectParameters(request);
        if (redirectParameters != null && !redirectParameters.isEmpty()) {
            for (Map.Entry<String, String> param : redirectParameters.entrySet()) {
                redirectUrl = redirectUrl + URLEncoder.encode(param.getKey(), "UTF-8") + "=" + URLEncoder.encode(param.getValue(), "UTF-8") + "&";
            }
        }
        if (redirectUrl.charAt(redirectUrl.length() - 1) == '&' || redirectUrl.charAt(redirectUrl.length() - 1) == '?') {
            redirectUrl = redirectUrl.substring(0, redirectUrl.length() - 1);
        }
        return redirectUrl;
    }

    private void removeUnusedParameters(ParameterMap map) {
        map.remove((Object)"_useSignedPdf");
        map.remove((Object)"_asyncSubmit");
    }

    protected void bindGuideModelTransformer(GuideModelTransformer guideModelTransformer) {
        this.guideModelTransformer = guideModelTransformer;
    }

    protected void unbindGuideModelTransformer(GuideModelTransformer guideModelTransformer) {
        if (this.guideModelTransformer == guideModelTransformer) {
            this.guideModelTransformer = null;
        }
    }

    protected void bindGuidePDFSubmitHelper(GuidePDFSubmitHelper guidePDFSubmitHelper) {
        this.guidePDFSubmitHelper = guidePDFSubmitHelper;
    }

    protected void unbindGuidePDFSubmitHelper(GuidePDFSubmitHelper guidePDFSubmitHelper) {
        if (this.guidePDFSubmitHelper == guidePDFSubmitHelper) {
            this.guidePDFSubmitHelper = null;
        }
    }

    protected void bindGuideStoreContentSubmission(GuideStoreContentSubmission guideStoreContentSubmission) {
        this.guideStoreContentSubmission = guideStoreContentSubmission;
    }

    protected void unbindGuideStoreContentSubmission(GuideStoreContentSubmission guideStoreContentSubmission) {
        if (this.guideStoreContentSubmission == guideStoreContentSubmission) {
            this.guideStoreContentSubmission = null;
        }
    }
}

