/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.activation.DataSource;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.mail.internet.InternetAddress;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.commons.mail.ByteArrayDataSource;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GuideEmail {
    private String[] to;
    private String[] cc;
    private String[] bcc;
    private String from;
    private String subject;
    private String template;
    private String charSet;
    private List<String> attachments;
    private List<DataSource> fileAttachments;
    private static final String DEFAULT_CHARSET = "utf-8";
    private Logger logger = LoggerFactory.getLogger(GuideEmail.class);

    public GuideEmail(SlingHttpServletRequest request) throws IOException {
        Resource resource = request.getResource();
        Session userSession = (Session)request.getResourceResolver().adaptTo(Session.class);
        ValueMap properties = ResourceUtil.getValueMap((Resource)resource);
        String templatePath = null;
        this.charSet = DEFAULT_CHARSET;
        String string = templatePath = properties.containsKey((Object)"templatePath") ? (String)properties.get("templatePath", (Object)"") : null;
        if (templatePath != null) {
            this.charSet = this.getCharSet(userSession, templatePath);
            this.template = this.getTemplate(templatePath, this.charSet, userSession);
        }
        if (this.template == null) {
            String string2 = this.template = properties.containsKey((Object)"template") ? (String)properties.get("template", (Object)"") : null;
        }
        if (properties.containsKey((Object)"mailto")) {
            this.to = (String[])properties.get("mailto", (Object)new String[0]);
        }
        if (properties.containsKey((Object)"cc")) {
            this.cc = (String[])properties.get("cc", (Object)new String[0]);
        }
        if (properties.containsKey((Object)"bcc")) {
            this.bcc = (String[])properties.get("bcc", (Object)new String[0]);
        }
        if (properties.containsKey((Object)"from")) {
            this.from = (String)properties.get("from", (Object)"");
        }
        if (properties.containsKey((Object)"subject")) {
            this.subject = (String)properties.get("subject", (Object)"");
        }
        if (properties.containsKey((Object)"includeAttachments") && "true".equals(properties.get("includeAttachments", (Object)""))) {
            this.attachments = new ArrayList<String>();
            this.fileAttachments = new ArrayList<DataSource>();
            String attachmentNames = request.getParameter("_guideAttachments");
            if (attachmentNames != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(attachmentNames, ",");
                while (stringTokenizer.hasMoreElements()) {
                    String filename = (String)stringTokenizer.nextElement();
                    InputStream att = request.getRequestParameter(filename).getInputStream();
                    this.fileAttachments.add((DataSource)new ByteArrayDataSource(att, request.getRequestParameter(filename).getContentType()));
                    this.attachments.add(filename.substring(filename.indexOf("/") + 1));
                }
            }
        }
    }

    public Email createEmail(StrSubstitutor substitutor) throws Exception {
        String substitutedSubject;
        MultiPartEmail email = new MultiPartEmail();
        email.setCharset(this.charSet);
        InternetAddress af = null;
        if (this.to != null) {
            for (String toAddr : this.to) {
                toAddr = substitutor.replace(toAddr);
                af = new InternetAddress(toAddr);
                email.addTo(af.getAddress(), af.getPersonal());
            }
        } else {
            return null;
        }
        if (this.cc != null) {
            for (String ccAddr : this.cc) {
                ccAddr = substitutor.replace(ccAddr);
                af = new InternetAddress(ccAddr);
                email.addCc(af.getAddress(), af.getPersonal());
            }
        }
        if (this.bcc != null) {
            for (String bccAddr : this.bcc) {
                bccAddr = substitutor.replace(bccAddr);
                af = new InternetAddress(bccAddr);
                email.addBcc(af.getAddress(), af.getPersonal());
            }
        }
        if (this.from == null) {
            return null;
        }
        String fromAddr = substitutor.replace(this.from);
        af = new InternetAddress(fromAddr);
        email.setFrom(af.getAddress(), af.getPersonal());
        if (this.subject != null && (substitutedSubject = substitutor.replace(this.subject)).length() > 0) {
            email.setSubject(substitutedSubject);
        }
        if (this.template != null) {
            String substitutedTemplate = substitutor.replace(this.template);
            if (substitutedTemplate.length() == 0) {
                substitutedTemplate = " ";
            }
            email.setMsg(substitutedTemplate);
        }
        if (this.fileAttachments != null) {
            int i = 0;
            for (DataSource source : this.fileAttachments) {
                email.attach(source, this.attachments.get(i), this.attachments.get(i));
                ++i;
            }
        }
        return email;
    }

    private String getCharSet(Session session, String path) {
        String encoding = DEFAULT_CHARSET;
        try {
            Node content = session.getNode(path + "/" + "jcr:content");
            encoding = content.hasProperty("jcr:encoding") ? content.getProperty("jcr:encoding").getString() : DEFAULT_CHARSET;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return encoding;
    }

    public String getTemplate(String templatePath, String charSet, Session userSession) {
        StringWriter w = new StringWriter();
        try {
            Node content = userSession.getNode(templatePath + "/" + "jcr:content");
            InputStream is = content.getProperty("jcr:data").getBinary().getStream();
            InputStreamReader r = new InputStreamReader(is, charSet);
            IOUtils.copy((Reader)r, (Writer)w);
            return w.toString();
        }
        catch (Exception e) {
            this.logger.error(e.toString(), (Throwable)e);
            return null;
        }
    }

    public String getTemplate() {
        return this.template;
    }
}

