/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.formset.common;

import com.adobe.aemds.formset.common.FormsetResource;
import com.adobe.aemds.formset.exception.FormsetException;
import com.adobe.aemds.formset.service.FormsetService;
import com.adobe.aemds.formset.utils.DataSomExtractor;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.FunctionCall;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.StringLiteral;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EligibilityExpressionVisitor
implements NodeVisitor {
    private final Logger logger = LoggerFactory.getLogger(EligibilityExpressionVisitor.class);
    private final FormsetResource formsetResource;
    private final FormsetService formsetService;

    public EligibilityExpressionVisitor(FormsetResource formsetResource, FormsetService formsetService) {
        this.formsetResource = formsetResource;
        this.formsetService = formsetService;
    }

    public boolean visit(AstNode node) {
        block9: {
            FunctionCall fCallNode;
            AstNode funcTarget;
            if (node instanceof FunctionCall && 33 == (funcTarget = (fCallNode = (FunctionCall)node).getTarget()).getType() && "fs.valueOf".equals(funcTarget.toSource())) {
                List argsList = ((FunctionCall)node).getArguments();
                if (argsList.size() == 2 && argsList.get(0) instanceof StringLiteral && argsList.get(1) instanceof StringLiteral) {
                    String dataSOMValue = "";
                    try {
                        dataSOMValue = this.getDataSOMValue(((StringLiteral)argsList.get(0)).getValue(), ((StringLiteral)argsList.get(1)).getValue());
                    }
                    catch (FormsetException e) {
                        this.logger.error("[FormSet] Failed to get dataSOM while Compiling Eligibility Expression : " + node.toSource(), (Throwable)e);
                    }
                    try {
                        StringLiteral arg2 = (StringLiteral)argsList.get(1);
                        if (dataSOMValue != null && dataSOMValue.length() > 0) {
                            arg2.setValue(dataSOMValue);
                            break block9;
                        }
                        this.logger.error("[FormSet] Failed to match dataSOM while Compiling Eligibility Expression : " + node.toSource());
                        arg2.setValue("INVALID_DATA_SOM");
                    }
                    catch (IllegalArgumentException e) {
                        this.logger.error("[FormSet] Failed to set compiled dataSOM Arg : " + node.toSource(), (Throwable)e);
                    }
                } else if (argsList.size() != 1) {
                    this.logger.error("[FormSet] Call to fs.valueOf function in EligibilityExpression has invalid number/type of arguments : " + fCallNode.toSource());
                }
            }
        }
        return true;
    }

    private String getDataSOMValue(String formUid, String somExp) throws FormsetException {
        String formDom = this.formsetService.getTemplateJson(formUid, this.formsetResource);
        String dataSom = "";
        try {
            JSONObject formDomJson = new JSONObject(formDom);
            DataSomExtractor dataSomExtractor = new DataSomExtractor();
            dataSom = dataSomExtractor.searchFormDomJson(formDomJson, this.getNormalizedSom(somExp));
        }
        catch (JSONException e) {
            this.logger.error("[FormSet] JSON parse exception while traversing FormDom", (Throwable)e);
        }
        return dataSom;
    }

    private String getNormalizedSom(String somExp) {
        Pattern pattern = Pattern.compile("(?<!\\\\|\\])\\.");
        Matcher matcher = pattern.matcher(somExp);
        String normalizedSom = matcher.replaceAll("[0].");
        if (!StringUtils.startsWith((CharSequence)normalizedSom, (CharSequence)"xfa[0].form[0].")) {
            normalizedSom = "xfa[0].form[0]." + normalizedSom;
        }
        if (!StringUtils.endsWith((CharSequence)normalizedSom, (CharSequence)"]")) {
            normalizedSom = normalizedSom + "[0]";
        }
        return normalizedSom;
    }
}

