/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.processing;

import java.util.List;
import org.apache.felix.scr.annotations.sling.SlingFilter;
import org.apache.felix.scr.annotations.sling.SlingFilterScope;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.felix.scrplugin.SCRDescriptorException;
import org.apache.felix.scrplugin.SCRDescriptorFailureException;
import org.apache.felix.scrplugin.annotations.AnnotationProcessor;
import org.apache.felix.scrplugin.annotations.ClassAnnotation;
import org.apache.felix.scrplugin.annotations.ScannedClass;
import org.apache.felix.scrplugin.description.ClassDescription;
import org.apache.felix.scrplugin.description.ComponentConfigurationPolicy;
import org.apache.felix.scrplugin.description.ComponentDescription;
import org.apache.felix.scrplugin.description.PropertyDescription;
import org.apache.felix.scrplugin.description.PropertyType;
import org.apache.felix.scrplugin.description.ServiceDescription;

public class SlingAnnotationProcessor
implements AnnotationProcessor {
    public String getName() {
        return "Apache Sling Annotation Processor";
    }

    public void process(ScannedClass scannedClass, ClassDescription describedClass) throws SCRDescriptorFailureException, SCRDescriptorException {
        List<ClassAnnotation> servlets = scannedClass.getClassAnnotations(SlingServlet.class.getName());
        scannedClass.processed(servlets);
        for (ClassAnnotation cad : servlets) {
            this.processSlingServlet(cad, describedClass);
        }
        List<ClassAnnotation> filters = scannedClass.getClassAnnotations(SlingFilter.class.getName());
        scannedClass.processed(filters);
        for (ClassAnnotation cad : filters) {
            this.processSlingFilter(cad, describedClass);
        }
    }

    public int getRanking() {
        return 500;
    }

    private void processSlingServlet(ClassAnnotation cad, ClassDescription classDescription) {
        boolean generateService;
        boolean generateComponent = cad.getBooleanValue("generateComponent", true);
        boolean metatype = cad.getBooleanValue("metatype", !generateComponent);
        if (generateComponent) {
            ComponentDescription cd = new ComponentDescription(cad);
            cd.setName(cad.getStringValue("name", classDescription.getDescribedClass().getName()));
            cd.setConfigurationPolicy(ComponentConfigurationPolicy.OPTIONAL);
            cd.setLabel(cad.getStringValue("label", null));
            cd.setDescription(cad.getStringValue("description", null));
            cd.setCreateMetatype(metatype);
            classDescription.add(cd);
        }
        if (generateService = cad.getBooleanValue("generateService", true)) {
            ServiceDescription sd = new ServiceDescription(cad);
            sd.addInterface("javax.servlet.Servlet");
            classDescription.add(sd);
        }
        this.generateStringPropertyDescriptor(cad, classDescription, metatype, "paths", "sling.servlet.paths");
        this.generateStringPropertyDescriptor(cad, classDescription, metatype, "resourceTypes", "sling.servlet.resourceTypes");
        this.generateStringPropertyDescriptor(cad, classDescription, metatype, "selectors", "sling.servlet.selectors");
        this.generateStringPropertyDescriptor(cad, classDescription, metatype, "extensions", "sling.servlet.extensions");
        this.generateStringPropertyDescriptor(cad, classDescription, metatype, "methods", "sling.servlet.methods");
    }

    private void generateStringPropertyDescriptor(ClassAnnotation cad, ClassDescription classDescription, boolean metatype, String annotationName, String propertyDescriptorName) {
        String[] values = (String[])cad.getValue(annotationName);
        if (values == null) {
            return;
        }
        PropertyDescription pd = new PropertyDescription(cad);
        pd.setName(propertyDescriptorName);
        pd.setMultiValue(values);
        pd.setType(PropertyType.String);
        if (metatype) {
            pd.setPrivate(true);
        }
        classDescription.add(pd);
    }

    private void processSlingFilter(ClassAnnotation cad, ClassDescription classDescription) {
        String[] scopes;
        boolean generateService;
        boolean generateComponent = cad.getBooleanValue("generateComponent", true);
        boolean metatype = cad.getBooleanValue("metatype", !generateComponent);
        if (generateComponent) {
            ComponentDescription cd = new ComponentDescription(cad);
            cd.setName(cad.getStringValue("name", classDescription.getDescribedClass().getName()));
            cd.setConfigurationPolicy(ComponentConfigurationPolicy.OPTIONAL);
            cd.setLabel(cad.getStringValue("label", null));
            cd.setDescription(cad.getStringValue("description", null));
            cd.setCreateMetatype(metatype);
            classDescription.add(cd);
        }
        if (generateService = cad.getBooleanValue("generateService", true)) {
            ServiceDescription sd = new ServiceDescription(cad);
            sd.addInterface("javax.servlet.Filter");
            classDescription.add(sd);
        }
        int order = cad.getIntegerValue("order", 0);
        PropertyDescription pd = new PropertyDescription(cad);
        pd.setName("service.ranking");
        pd.setValue(String.valueOf(order));
        pd.setType(PropertyType.Integer);
        if (metatype) {
            pd.setPrivate(true);
        }
        classDescription.add(pd);
        Object val = cad.getValue("scope");
        if (val != null) {
            String[] arr;
            if (val instanceof String[]) {
                arr = (String[])val;
                scopes = new String[arr.length / 2];
                int i = 0;
                int index = 0;
                while (i < arr.length) {
                    scopes[index] = arr[i];
                    i += 2;
                    ++index;
                }
            } else if (val instanceof String[][]) {
                arr = (String[][])val;
                scopes = new String[arr.length];
                for (int index = 0; index < arr.length; ++index) {
                    scopes[index] = arr[index][1];
                }
            } else {
                scopes = new String[]{val.toString()};
            }
        } else {
            scopes = new String[]{SlingFilterScope.REQUEST.getScope()};
        }
        PropertyDescription pd2 = new PropertyDescription(cad);
        pd2.setName("sling.filter.scope");
        if (scopes.length == 1) {
            pd2.setValue(scopes[0]);
        } else {
            pd2.setMultiValue(scopes);
        }
        pd2.setType(PropertyType.String);
        if (metatype) {
            pd2.setPrivate(true);
        }
        classDescription.add(pd2);
    }
}

