/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.ant;

import org.apache.felix.scrplugin.Log;
import org.apache.tools.ant.Task;

public class AntLog
implements Log {
    private final Task task;

    AntLog(Task task) {
        this.task = task;
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public void debug(String content) {
        this.task.log(content, 4);
    }

    public void debug(String content, Throwable error) {
        this.task.log(content, error, 4);
    }

    public void debug(Throwable error) {
        this.task.log(error, 4);
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void info(String content) {
        this.task.log(content, 2);
    }

    public void info(String content, Throwable error) {
        this.task.log(content, error, 2);
    }

    public void info(Throwable error) {
        this.task.log(error, 2);
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String content) {
        this.task.log(content, 1);
    }

    public void warn(String content, String location, int lineNumber) {
        this.warn(String.format("%s [%s,%d]", content, location, lineNumber));
    }

    public void warn(String content, String location, int lineNumber, int columNumber) {
        this.warn(String.format("%s [%s,%d:%d]", content, location, lineNumber, columNumber));
    }

    public void warn(String content, Throwable error) {
        this.task.log(content, error, 1);
    }

    public void warn(Throwable error) {
        this.task.log(error, 1);
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(String content) {
        this.task.log(content, 0);
    }

    public void error(String content, String location, int lineNumber) {
        this.error(String.format("%s [%s,%d]", content, location, lineNumber));
    }

    public void error(String content, String location, int lineNumber, int columnNumber) {
        this.error(String.format("%s [%s,%d:%d]", content, location, lineNumber, columnNumber));
    }

    public void error(String content, Throwable error) {
        this.task.log(content, error, 0);
    }

    public void error(Throwable error) {
        this.task.log(error, 0);
    }
}

