/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import org.apache.felix.scrplugin.Log;
import org.apache.felix.scrplugin.Options;
import org.apache.felix.scrplugin.SCRDescriptorException;
import org.apache.felix.scrplugin.SCRDescriptorFailureException;
import org.apache.felix.scrplugin.SpecVersion;
import org.apache.felix.scrplugin.description.ClassDescription;
import org.apache.felix.scrplugin.description.ComponentConfigurationPolicy;
import org.apache.felix.scrplugin.description.ComponentDescription;
import org.apache.felix.scrplugin.description.PropertyDescription;
import org.apache.felix.scrplugin.description.PropertyType;
import org.apache.felix.scrplugin.description.PropertyUnbounded;
import org.apache.felix.scrplugin.description.ReferenceCardinality;
import org.apache.felix.scrplugin.description.ReferenceDescription;
import org.apache.felix.scrplugin.description.ReferencePolicy;
import org.apache.felix.scrplugin.description.ReferencePolicyOption;
import org.apache.felix.scrplugin.description.ReferenceStrategy;
import org.apache.felix.scrplugin.description.ServiceDescription;
import org.apache.felix.scrplugin.helper.ComponentContainer;
import org.apache.felix.scrplugin.helper.ComponentContainerUtil;
import org.apache.felix.scrplugin.helper.DescriptionContainer;
import org.apache.felix.scrplugin.helper.IssueLog;
import org.apache.felix.scrplugin.xml.IOUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentDescriptorIO {
    private static final String PROPERTY_ATTR_TYPE = "type";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_CARDINALITY = "cardinality";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_LABEL = "label";
    public static final String INNER_NAMESPACE_URI = "";
    private static final String PREFIX = "scr";
    private static final String COMPONENTS = "components";
    private static final String COMPONENT = "component";
    private static final String COMPONENT_QNAME = "scr:component";
    private static final String COMPONENT_ATTR_ENABLED = "enabled";
    private static final String COMPONENT_ATTR_POLICY = "configuration-policy";
    private static final String COMPONENT_ATTR_FACTORY = "factory";
    private static final String COMPONENT_ATTR_IMMEDIATE = "immediate";
    private static final String COMPONENT_ATTR_ACTIVATE = "activate";
    private static final String COMPONENT_ATTR_DEACTIVATE = "deactivate";
    private static final String COMPONENT_ATTR_MODIFIED = "modified";
    private static final String COMPONENT_ATTR_CONFIGURATION_PID = "configuration-pid";
    private static final String IMPLEMENTATION = "implementation";
    private static final String IMPLEMENTATION_QNAME = "implementation";
    private static final String IMPLEMENTATION_ATTR_CLASS = "class";
    private static final String SERVICE = "service";
    private static final String SERVICE_QNAME = "service";
    private static final String SERVICE_ATTR_FACTORY = "servicefactory";
    private static final String PROPERTY = "property";
    private static final String PROPERTY_QNAME = "property";
    private static final String PROPERTY_ATTR_VALUE = "value";
    private static final String PROPERTY_ATTR_PRIVATE = "private";
    private static final String REFERENCE = "reference";
    private static final String REFERENCE_QNAME = "reference";
    private static final String REFERENCE_ATTR_POLICY = "policy";
    private static final String REFERENCE_ATTR_POLICY_OPTION = "policy-option";
    private static final String REFERENCE_ATTR_UPDATED = "updated";
    private static final String REFERENCE_ATTR_UNBIND = "unbind";
    private static final String REFERENCE_ATTR_BIND = "bind";
    private static final String REFERENCE_ATTR_TARGET = "target";
    private static final String REFERENCE_ATTR_STRATEGY = "strategy";
    private static final String INTERFACE = "provide";
    private static final String INTERFACE_QNAME = "provide";
    private static final String INTERFACE_ATTR_NAME = "interface";
    private static final String PROPERTIES = "properties";
    private static final String PARENT_NAME = "OSGI-INF";

    public static List<ClassDescription> read(InputStream file, ClassLoader classLoader, IssueLog iLog, String location) throws SCRDescriptorException {
        try {
            XmlHandler xmlHandler = new XmlHandler(classLoader, iLog, location);
            IOUtils.parse(file, xmlHandler);
            return xmlHandler.components;
        }
        catch (TransformerException e) {
            throw new SCRDescriptorException("Unable to read xml", location, e);
        }
    }

    protected static void generateXML(DescriptionContainer module, List<ComponentContainer> components, File descriptorFile, Log logger) throws SAXException, IOException, TransformerException {
        logger.info("Writing " + components.size() + " Service Component Descriptors to " + descriptorFile);
        ContentHandler contentHandler = IOUtils.getSerializer(descriptorFile);
        String namespace = module.getOptions().getSpecVersion().getNamespaceUrl();
        contentHandler.startDocument();
        contentHandler.startPrefixMapping(PREFIX, namespace);
        contentHandler.startElement(INNER_NAMESPACE_URI, COMPONENTS, COMPONENTS, new AttributesImpl());
        IOUtils.newline(contentHandler);
        for (ComponentContainer component : components) {
            ComponentDescriptorIO.generateXML(namespace, module, component, contentHandler);
        }
        contentHandler.endElement(INNER_NAMESPACE_URI, COMPONENTS, COMPONENTS);
        IOUtils.newline(contentHandler);
        contentHandler.endPrefixMapping(PREFIX);
        contentHandler.endDocument();
    }

    protected static void generateXML(String namespace, DescriptionContainer module, ComponentContainer container, ContentHandler contentHandler) throws SAXException {
        ComponentDescription component = container.getComponentDescription();
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, COMPONENT_ATTR_ENABLED, component.getEnabled());
        IOUtils.addAttribute(ai, COMPONENT_ATTR_IMMEDIATE, component.getImmediate());
        IOUtils.addAttribute(ai, ATTR_NAME, component.getName());
        IOUtils.addAttribute(ai, COMPONENT_ATTR_FACTORY, component.getFactory());
        if (module.getOptions().getSpecVersion().ordinal() >= SpecVersion.VERSION_1_1.ordinal()) {
            if (component.getConfigurationPolicy() != null && component.getConfigurationPolicy() != ComponentConfigurationPolicy.OPTIONAL) {
                IOUtils.addAttribute(ai, COMPONENT_ATTR_POLICY, component.getConfigurationPolicy().name().toLowerCase());
            }
            IOUtils.addAttribute(ai, COMPONENT_ATTR_ACTIVATE, component.getActivate());
            IOUtils.addAttribute(ai, COMPONENT_ATTR_DEACTIVATE, component.getDeactivate());
            IOUtils.addAttribute(ai, COMPONENT_ATTR_MODIFIED, component.getModified());
        }
        if (module.getOptions().getSpecVersion().ordinal() >= SpecVersion.VERSION_1_2.ordinal() && component.getConfigurationPid() != null && !component.getConfigurationPid().equals(component.getName())) {
            IOUtils.addAttribute(ai, COMPONENT_ATTR_CONFIGURATION_PID, component.getConfigurationPid());
        }
        IOUtils.indent(contentHandler, 1);
        contentHandler.startElement(namespace, COMPONENT, COMPONENT_QNAME, ai);
        IOUtils.newline(contentHandler);
        ComponentDescriptorIO.generateImplementationXML(container, contentHandler);
        if (container.getServiceDescription() != null) {
            ComponentDescriptorIO.generateServiceXML(container.getServiceDescription(), contentHandler);
        }
        for (PropertyDescription property : container.getProperties().values()) {
            ComponentDescriptorIO.generatePropertyXML(property, contentHandler);
        }
        for (ReferenceDescription reference : container.getReferences().values()) {
            ComponentDescriptorIO.generateReferenceXML(component, module, reference, contentHandler);
        }
        IOUtils.indent(contentHandler, 1);
        contentHandler.endElement(namespace, COMPONENT, COMPONENT_QNAME);
        IOUtils.newline(contentHandler);
    }

    protected static void generateImplementationXML(ComponentContainer component, ContentHandler contentHandler) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, IMPLEMENTATION_ATTR_CLASS, component.getClassDescription().getDescribedClass().getName());
        IOUtils.indent(contentHandler, 2);
        contentHandler.startElement(INNER_NAMESPACE_URI, "implementation", "implementation", ai);
        contentHandler.endElement(INNER_NAMESPACE_URI, "implementation", "implementation");
        IOUtils.newline(contentHandler);
    }

    protected static void generateServiceXML(ServiceDescription service, ContentHandler contentHandler) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, SERVICE_ATTR_FACTORY, String.valueOf(service.isServiceFactory()));
        IOUtils.indent(contentHandler, 2);
        contentHandler.startElement(INNER_NAMESPACE_URI, "service", "service", ai);
        if (service.getInterfaces() != null && service.getInterfaces().size() > 0) {
            IOUtils.newline(contentHandler);
            for (String interf : service.getInterfaces()) {
                ComponentDescriptorIO.generateServiceXML(interf, contentHandler);
            }
            IOUtils.indent(contentHandler, 2);
        }
        contentHandler.endElement(INNER_NAMESPACE_URI, "service", "service");
        IOUtils.newline(contentHandler);
    }

    private static void generateServiceXML(String interfaceName, ContentHandler contentHandler) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, INTERFACE_ATTR_NAME, interfaceName);
        IOUtils.indent(contentHandler, 3);
        contentHandler.startElement(INNER_NAMESPACE_URI, "provide", "provide", ai);
        contentHandler.endElement(INNER_NAMESPACE_URI, "provide", "provide");
        IOUtils.newline(contentHandler);
    }

    protected static void generatePropertyXML(PropertyDescription property, ContentHandler contentHandler) throws SAXException {
        String value;
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, ATTR_NAME, property.getName());
        if (property.getType() != PropertyType.String && property.getType() != PropertyType.Password) {
            IOUtils.addAttribute(ai, PROPERTY_ATTR_TYPE, (Object)property.getType());
        }
        if ((value = property.getValue()) != null) {
            if (property.getType() == PropertyType.Character || property.getType() == PropertyType.Char) {
                value = String.valueOf((int)value.charAt(0));
            }
            IOUtils.addAttribute(ai, PROPERTY_ATTR_VALUE, value);
        }
        IOUtils.indent(contentHandler, 2);
        contentHandler.startElement(INNER_NAMESPACE_URI, "property", "property", ai);
        if (property.getMultiValue() != null && property.getMultiValue().length > 0) {
            IOUtils.text(contentHandler, "\n");
            for (int i = 0; i < property.getMultiValue().length; ++i) {
                IOUtils.indent(contentHandler, 3);
                value = property.getMultiValue()[i];
                if (property.getType() == PropertyType.Character || property.getType() == PropertyType.Char) {
                    value = String.valueOf((int)value.charAt(0));
                }
                IOUtils.text(contentHandler, value);
                IOUtils.newline(contentHandler);
            }
            IOUtils.indent(contentHandler, 2);
        }
        contentHandler.endElement(INNER_NAMESPACE_URI, "property", "property");
        IOUtils.newline(contentHandler);
    }

    protected static void generateReferenceXML(ComponentDescription component, DescriptionContainer module, ReferenceDescription reference, ContentHandler contentHandler) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, ATTR_NAME, reference.getName());
        IOUtils.addAttribute(ai, INTERFACE_ATTR_NAME, reference.getInterfaceName());
        IOUtils.addAttribute(ai, ATTR_CARDINALITY, reference.getCardinality().getCardinalityString());
        IOUtils.addAttribute(ai, REFERENCE_ATTR_POLICY, reference.getPolicy().name().toLowerCase());
        IOUtils.addAttribute(ai, REFERENCE_ATTR_TARGET, reference.getTarget());
        IOUtils.addAttribute(ai, REFERENCE_ATTR_BIND, reference.getBind());
        IOUtils.addAttribute(ai, REFERENCE_ATTR_UNBIND, reference.getUnbind());
        if (module.getOptions().getSpecVersion().ordinal() >= SpecVersion.VERSION_1_1_FELIX.ordinal()) {
            IOUtils.addAttribute(ai, REFERENCE_ATTR_UPDATED, reference.getUpdated());
        }
        if (module.getOptions().getSpecVersion().ordinal() >= SpecVersion.VERSION_1_2.ordinal() && reference.getPolicyOption() != ReferencePolicyOption.RELUCTANT) {
            IOUtils.addAttribute(ai, REFERENCE_ATTR_POLICY_OPTION, reference.getPolicyOption().name().toLowerCase());
        }
        IOUtils.indent(contentHandler, 2);
        contentHandler.startElement(INNER_NAMESPACE_URI, "reference", "reference", ai);
        contentHandler.endElement(INNER_NAMESPACE_URI, "reference", "reference");
        IOUtils.newline(contentHandler);
    }

    public static List<String> generateDescriptorFiles(DescriptionContainer module, Options options, Log logger) throws SCRDescriptorException, SCRDescriptorFailureException {
        ArrayList<ComponentContainer> components = new ArrayList<ComponentContainer>();
        for (ComponentContainer container : module.getComponents()) {
            if (!container.getComponentDescription().isCreateDs()) {
                logger.debug("Ignoring descriptor for DS : " + container);
                continue;
            }
            if (container.getComponentDescription().isAbstract()) continue;
            logger.debug("Adding descriptor for DS : " + container);
            components.add(container);
        }
        File descriptorDir = options.getComponentDescriptorDirectory();
        if (components.isEmpty()) {
            logger.debug("No Service Component Descriptors found in project.");
            if (descriptorDir.exists()) {
                for (File f : descriptorDir.listFiles()) {
                    if (!f.isFile()) continue;
                    logger.debug("Removing obsolete service descriptor " + f);
                    f.delete();
                }
            }
            return null;
        }
        descriptorDir.mkdirs();
        ArrayList<String> fileNames = new ArrayList<String>();
        List<ComponentContainerUtil.ComponentContainerContainer> containers = ComponentContainerUtil.split(components);
        for (ComponentContainerUtil.ComponentContainerContainer ccc : containers) {
            SpecVersion globalVersion = module.getOptions().getSpecVersion();
            Enum sv = null;
            for (ComponentContainer cc : ccc.components) {
                if (sv != null && sv.ordinal() >= cc.getComponentDescription().getSpecVersion().ordinal()) continue;
                sv = cc.getComponentDescription().getSpecVersion();
            }
            module.getOptions().setSpecVersion((SpecVersion)sv);
            File useFile = new File(descriptorDir, ccc.className + ".xml");
            try {
                ComponentDescriptorIO.generateXML(module, ccc.components, useFile, logger);
            }
            catch (IOException e) {
                throw new SCRDescriptorException("Unable to generate xml", useFile.toString(), e);
            }
            catch (TransformerException e) {
                throw new SCRDescriptorException("Unable to generate xml", useFile.toString(), e);
            }
            catch (SAXException e) {
                throw new SCRDescriptorException("Unable to generate xml", useFile.toString(), e);
            }
            fileNames.add("OSGI-INF/" + useFile.getName());
            module.getOptions().setSpecVersion(globalVersion);
        }
        return fileNames;
    }

    protected static final class XmlHandler
    extends DefaultHandler {
        private final List<ClassDescription> components = new ArrayList<ClassDescription>();
        private SpecVersion specVersion;
        private ClassDescription currentClass;
        private ComponentDescription currentComponent;
        private ServiceDescription currentService;
        private PropertyDescription pendingProperty;
        private boolean firstElement = true;
        private boolean isComponent = false;
        private String overrideNamespace;
        private final IssueLog iLog;
        private final String location;
        private final ClassLoader classLoader;

        public XmlHandler(ClassLoader classLoader, IssueLog iLog, String loc) {
            this.iLog = iLog;
            this.location = loc;
            this.classLoader = classLoader;
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (this.firstElement) {
                this.firstElement = false;
                if (localName.equals(ComponentDescriptorIO.COMPONENT) && ComponentDescriptorIO.INNER_NAMESPACE_URI.equals(uri)) {
                    this.overrideNamespace = SpecVersion.VERSION_1_0.getNamespaceUrl();
                }
            }
            if (this.overrideNamespace != null && ComponentDescriptorIO.INNER_NAMESPACE_URI.equals(uri)) {
                uri = this.overrideNamespace;
            }
            if (this.isComponent && ComponentDescriptorIO.INNER_NAMESPACE_URI.equals(uri)) {
                uri = SpecVersion.VERSION_1_0.getNamespaceUrl();
            }
            this.specVersion = SpecVersion.fromNamespaceUrl(uri);
            if (this.specVersion != null) {
                if (localName.equals(ComponentDescriptorIO.COMPONENT)) {
                    this.isComponent = true;
                    ComponentDescription desc = new ComponentDescription(null);
                    desc.setName(attributes.getValue(ComponentDescriptorIO.ATTR_NAME));
                    if (attributes.getValue(ComponentDescriptorIO.COMPONENT_ATTR_ENABLED) != null) {
                        desc.setEnabled(Boolean.valueOf(attributes.getValue(ComponentDescriptorIO.COMPONENT_ATTR_ENABLED)));
                    }
                    if (attributes.getValue(ComponentDescriptorIO.COMPONENT_ATTR_IMMEDIATE) != null) {
                        desc.setImmediate(Boolean.valueOf(attributes.getValue(ComponentDescriptorIO.COMPONENT_ATTR_IMMEDIATE)));
                    }
                    desc.setFactory(attributes.getValue(ComponentDescriptorIO.COMPONENT_ATTR_FACTORY));
                    desc.setConfigurationPolicy(ComponentConfigurationPolicy.OPTIONAL);
                    if (this.specVersion.ordinal() >= SpecVersion.VERSION_1_1.ordinal()) {
                        String policy = attributes.getValue(ComponentDescriptorIO.COMPONENT_ATTR_POLICY);
                        if (policy != null) {
                            try {
                                desc.setConfigurationPolicy(ComponentConfigurationPolicy.valueOf(policy.toUpperCase()));
                            }
                            catch (IllegalArgumentException iae) {
                                this.iLog.addWarning("Invalid value for attribute configuration-policy : " + policy, this.location);
                            }
                        }
                        if (attributes.getValue(ComponentDescriptorIO.COMPONENT_ATTR_ACTIVATE) != null) {
                            desc.setActivate(attributes.getValue(ComponentDescriptorIO.COMPONENT_ATTR_ACTIVATE));
                        }
                        if (attributes.getValue(ComponentDescriptorIO.COMPONENT_ATTR_DEACTIVATE) != null) {
                            desc.setDeactivate(attributes.getValue(ComponentDescriptorIO.COMPONENT_ATTR_DEACTIVATE));
                        }
                        if (attributes.getValue(ComponentDescriptorIO.COMPONENT_ATTR_MODIFIED) != null) {
                            desc.setModified(attributes.getValue(ComponentDescriptorIO.COMPONENT_ATTR_MODIFIED));
                        }
                    }
                    this.currentComponent = desc;
                } else if (localName.equals("implementation")) {
                    String className = attributes.getValue(ComponentDescriptorIO.IMPLEMENTATION_ATTR_CLASS);
                    Class<?> cl = null;
                    try {
                        cl = this.classLoader.loadClass(className);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    this.currentClass = new ClassDescription(cl, "classpath:" + className);
                    this.currentClass.add(this.currentComponent);
                    this.components.add(this.currentClass);
                } else if (localName.equals("property")) {
                    String propName = attributes.getValue(ComponentDescriptorIO.ATTR_NAME);
                    if (!"service.pid".equals(propName)) {
                        String pValue;
                        PropertyDescription prop = new PropertyDescription(null);
                        prop.setName(propName);
                        String type = attributes.getValue(ComponentDescriptorIO.PROPERTY_ATTR_TYPE);
                        if (type != null) {
                            try {
                                prop.setType(PropertyType.valueOf(type));
                            }
                            catch (IllegalArgumentException iae) {
                                this.iLog.addWarning("Invalid value for attribute type : " + type, this.location);
                            }
                        }
                        if (prop.getType() == null) {
                            prop.setType(PropertyType.String);
                        }
                        if (attributes.getValue(ComponentDescriptorIO.PROPERTY_ATTR_VALUE) != null) {
                            if (prop.getType() == PropertyType.Char || prop.getType() == PropertyType.Character) {
                                int val = Integer.valueOf(attributes.getValue(ComponentDescriptorIO.PROPERTY_ATTR_VALUE));
                                Character c = Character.valueOf((char)val);
                                prop.setValue(c.toString());
                            } else {
                                prop.setValue(attributes.getValue(ComponentDescriptorIO.PROPERTY_ATTR_VALUE));
                            }
                            this.currentClass.add(prop);
                        } else {
                            this.pendingProperty = prop;
                        }
                        prop.setLabel(attributes.getValue(ComponentDescriptorIO.ATTR_LABEL));
                        prop.setDescription(attributes.getValue(ComponentDescriptorIO.ATTR_DESCRIPTION));
                        String cardinality = attributes.getValue(ComponentDescriptorIO.ATTR_CARDINALITY);
                        prop.setUnbounded(PropertyUnbounded.DEFAULT);
                        if (cardinality != null) {
                            prop.setCardinality(Integer.valueOf(cardinality));
                            if (prop.getCardinality() == Integer.MAX_VALUE) {
                                prop.setCardinality(0);
                                prop.setUnbounded(PropertyUnbounded.ARRAY);
                            } else if (prop.getCardinality() == Integer.MIN_VALUE) {
                                prop.setCardinality(0);
                                prop.setUnbounded(PropertyUnbounded.VECTOR);
                            }
                        }
                        if ((pValue = attributes.getValue(ComponentDescriptorIO.PROPERTY_ATTR_PRIVATE)) != null) {
                            prop.setPrivate(Boolean.valueOf(pValue));
                        }
                    }
                } else if (!localName.equals(ComponentDescriptorIO.PROPERTIES)) {
                    if (localName.equals("service")) {
                        this.currentService = new ServiceDescription(null);
                        this.currentClass.add(this.currentService);
                        if (attributes.getValue(ComponentDescriptorIO.SERVICE_ATTR_FACTORY) != null) {
                            this.currentService.setServiceFactory(Boolean.valueOf(attributes.getValue(ComponentDescriptorIO.SERVICE_ATTR_FACTORY)));
                        }
                    } else if (localName.equals("provide")) {
                        this.currentService.addInterface(attributes.getValue(ComponentDescriptorIO.INTERFACE_ATTR_NAME));
                    } else if (localName.equals("reference")) {
                        String strategy;
                        ReferenceDescription ref = new ReferenceDescription(null);
                        ref.setName(attributes.getValue(ComponentDescriptorIO.ATTR_NAME));
                        ref.setInterfaceName(attributes.getValue(ComponentDescriptorIO.INTERFACE_ATTR_NAME));
                        String cardinality = attributes.getValue(ComponentDescriptorIO.ATTR_CARDINALITY);
                        if (cardinality != null) {
                            ref.setCardinality(ReferenceCardinality.fromValue(cardinality));
                            if (ref.getCardinality() == null) {
                                this.iLog.addWarning("Invalid value for attribute cardinality : " + cardinality, this.location);
                            }
                        }
                        ref.setPolicy(ReferencePolicy.STATIC);
                        String policy = attributes.getValue(ComponentDescriptorIO.REFERENCE_ATTR_POLICY);
                        if (policy != null) {
                            try {
                                ref.setPolicy(ReferencePolicy.valueOf(policy.toUpperCase()));
                            }
                            catch (IllegalArgumentException iae) {
                                this.iLog.addWarning("Invalid value for attribute policy : " + policy, this.location);
                            }
                        }
                        ref.setPolicyOption(ReferencePolicyOption.RELUCTANT);
                        String policyOption = attributes.getValue(ComponentDescriptorIO.REFERENCE_ATTR_POLICY_OPTION);
                        if (policyOption != null) {
                            try {
                                ref.setPolicyOption(ReferencePolicyOption.valueOf(policyOption.toUpperCase()));
                            }
                            catch (IllegalArgumentException iae) {
                                this.iLog.addWarning("Invalid value for attribute policy-option : " + policyOption, this.location);
                            }
                        }
                        ref.setTarget(attributes.getValue(ComponentDescriptorIO.REFERENCE_ATTR_TARGET));
                        if (attributes.getValue(ComponentDescriptorIO.REFERENCE_ATTR_BIND) != null) {
                            ref.setBind(attributes.getValue(ComponentDescriptorIO.REFERENCE_ATTR_BIND));
                        }
                        if (attributes.getValue(ComponentDescriptorIO.REFERENCE_ATTR_UNBIND) != null) {
                            ref.setUnbind(attributes.getValue(ComponentDescriptorIO.REFERENCE_ATTR_UNBIND));
                        }
                        if (attributes.getValue(ComponentDescriptorIO.REFERENCE_ATTR_UPDATED) != null) {
                            ref.setUnbind(attributes.getValue(ComponentDescriptorIO.REFERENCE_ATTR_UPDATED));
                        }
                        if ((strategy = attributes.getValue(ComponentDescriptorIO.REFERENCE_ATTR_STRATEGY)) != null) {
                            try {
                                ref.setStrategy(ReferenceStrategy.valueOf(strategy.toUpperCase()));
                            }
                            catch (IllegalArgumentException iae) {
                                throw new SAXException("Invalid value for attribute strategy : " + strategy);
                            }
                        }
                        this.currentClass.add(ref);
                    }
                }
            }
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            if (this.overrideNamespace != null && ComponentDescriptorIO.INNER_NAMESPACE_URI.equals(uri)) {
                uri = this.overrideNamespace;
            }
            if (this.isComponent && ComponentDescriptorIO.INNER_NAMESPACE_URI.equals(uri)) {
                uri = SpecVersion.VERSION_1_0.getNamespaceUrl();
            }
            if (SpecVersion.fromNamespaceUrl(uri) != null) {
                if (localName.equals(ComponentDescriptorIO.COMPONENT)) {
                    this.currentClass = null;
                    this.currentComponent = null;
                    this.isComponent = false;
                } else if (localName.equals("property") && this.pendingProperty != null) {
                    String text = this.pendingProperty.getValue();
                    if (text != null) {
                        StringTokenizer st = new StringTokenizer(text);
                        String[] values = new String[st.countTokens()];
                        int index = 0;
                        while (st.hasMoreTokens()) {
                            values[index] = st.nextToken();
                            if (this.pendingProperty.getType() == PropertyType.Char || this.pendingProperty.getType() == PropertyType.Character) {
                                int val = Integer.valueOf(values[index]);
                                Character c = Character.valueOf((char)val);
                                values[index] = c.toString();
                            }
                            ++index;
                        }
                        this.pendingProperty.setMultiValue(values);
                    }
                    this.currentClass.add(this.pendingProperty);
                    this.pendingProperty = null;
                }
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.pendingProperty != null) {
                String text = new String(ch, start, length);
                if (this.pendingProperty.getValue() == null) {
                    this.pendingProperty.setValue(text);
                } else {
                    this.pendingProperty.setValue(this.pendingProperty.getValue() + text);
                }
            }
        }
    }
}

