/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfg.logging;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFGLogger {
    private static final String GenericLogMessage = "Generic Log Message";
    private static Logger _logger;
    private static boolean useSystemOut;
    private static Properties logMsgs;
    private static PDFGLogger pdfgLogger;

    private PDFGLogger(Class loggingClass) {
        _logger = LoggerFactory.getLogger((Class)loggingClass);
    }

    public static PDFGLogger getPDFGLogger(Class loggingClass) {
        return new PDFGLogger(loggingClass);
    }

    public void severe(String msgCode, Object[] params) {
        this.log(Level.SEVERE, msgCode, params, null);
    }

    public void severe(String msgCode, String parameter) {
        this.log(Level.SEVERE, msgCode, new Object[]{parameter}, null);
    }

    public void warning(String msgCode, Object[] params) {
        this.log(Level.WARNING, msgCode, params, null);
    }

    public void warning(String msgCode, String parameter) {
        this.log(Level.WARNING, msgCode, new Object[]{parameter}, null);
    }

    public void warning(String msgCode) {
        this.log(Level.WARNING, msgCode, null, null);
    }

    public void info(String msgCode, Object[] params) {
        this.log(Level.INFO, msgCode, params, null);
    }

    public void info(String msgCode, String parameter) {
        this.log(Level.INFO, msgCode, new Object[]{parameter}, null);
    }

    public void info(String msgCode) {
        this.log(Level.INFO, msgCode, null, null);
    }

    public void debug(String msgCode, Object[] params) {
        this.log(Level.FINE, msgCode, params, null);
    }

    public void debug(String msgCode, Object[] params, Throwable exception) {
        this.log(Level.FINE, msgCode, params, exception);
    }

    public void debug(String msgCode, Throwable exception, String parameter) {
        this.log(Level.FINE, msgCode, new Object[]{parameter}, exception);
    }

    public void debug(String msgCode, String parameter) {
        this.log(Level.FINE, msgCode, new Object[]{parameter}, null);
    }

    public void debug(String msgCode) {
        this.log(Level.FINE, msgCode, null, null);
    }

    public void trace(String msgCode, Object[] params, Throwable exception) {
        this.log(Level.FINEST, msgCode, params, exception);
    }

    public void trace(String msgCode, Object[] params) {
        this.log(Level.FINEST, msgCode, params, null);
    }

    public void trace(String msgCode) {
        this.log(Level.FINEST, msgCode, null, null);
    }

    public void log(Level level, String msgCode, Object[] params, Throwable exception) {
        String logMessage = GenericLogMessage;
        if (msgCode != null) {
            logMessage = logMsgs.getProperty(msgCode);
        }
        if (logMessage == null) {
            logMessage = msgCode;
        }
        if (params != null && params.length > 0) {
            try {
                logMessage = MessageFormat.format(logMessage, params);
            }
            catch (Exception e) {
                _logger.trace(e.getMessage(), (Throwable)e);
                logMessage = msgCode;
            }
        }
        if (logMessage.equals(msgCode)) {
            msgCode = "001-000";
        }
        logMessage = "ALC-PDG-" + msgCode + "-" + logMessage;
        if (level == Level.SEVERE) {
            if (exception != null) {
                _logger.error(logMessage, exception);
            } else {
                _logger.error(logMessage);
            }
        } else if (level == Level.WARNING) {
            if (exception != null) {
                _logger.warn(logMessage, exception);
            } else {
                _logger.warn(logMessage);
            }
        } else if (level == Level.INFO || level == Level.CONFIG) {
            if (exception != null) {
                _logger.info(logMessage, exception);
            } else {
                _logger.info(logMessage);
            }
        } else if (level == Level.FINE || level == Level.FINER) {
            if (exception != null) {
                _logger.debug(logMessage, exception);
            } else {
                _logger.debug(logMessage);
            }
        } else if (level == Level.FINEST || level == Level.ALL) {
            if (exception != null) {
                _logger.trace(logMessage, exception);
            } else {
                _logger.trace(logMessage);
            }
        }
        if (useSystemOut) {
            System.out.println(logMessage);
        }
    }

    public String getProperty(String key) {
        return logMsgs.getProperty(key);
    }

    static {
        useSystemOut = false;
        pdfgLogger = PDFGLogger.getPDFGLogger(PDFGLogger.class);
        logMsgs = new Properties();
        try {
            InputStream is = PDFGLogger.class.getResourceAsStream("PDG.properties");
            logMsgs.load(is);
        }
        catch (Exception e) {
            pdfgLogger.debug(e.getMessage(), null, e);
        }
    }
}

