/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.icc.dbforms.util;

import com.adobe.icc.dbforms.exceptions.ICCException;
import com.adobe.icc.dbforms.util.DBUtils;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public final class XMLHelperUtil {
    private Document oXMLDOM = null;
    private Map oHashMapForNS = null;
    private static final Logger log = LoggerFactory.getLogger((String)XMLHelperUtil.class.getName());

    public XMLHelperUtil() {
        this.oHashMapForNS = new HashMap();
    }

    public XMLHelperUtil(Document oXMLDOC) {
        this.oXMLDOM = oXMLDOC;
        this.oHashMapForNS = new HashMap();
    }

    public XMLHelperUtil(boolean initXFANamespace) {
        this.oHashMapForNS = new HashMap();
        this.initXDPNameSpace();
    }

    public XMLHelperUtil(String xml) {
        this.oHashMapForNS = new HashMap();
        try {
            Document document = DocumentHelper.parseText((String)xml);
            this.oXMLDOM = document.getDocument();
        }
        catch (Exception e) {
            log.warn("Unable to create Node.");
            log.error("Error: ", (Throwable)e);
        }
    }

    public String getXMLEncoding() {
        String encoding = null;
        try {
            if (this.oXMLDOM.getClass().getMethod("getXMLEncoding", null) != null) {
                encoding = null;
            }
        }
        catch (SecurityException e) {
            log.debug("Got a Dom4J getXmlEncoding with a Document class without the method. Returning null.", (Throwable)e);
            encoding = null;
        }
        catch (NoSuchMethodException e) {
            log.debug("Got a Dom4J getXmlEncoding with a Document class without the method. Returning null", (Throwable)e);
            encoding = null;
        }
        return encoding;
    }

    protected void initXDPNameSpace() {
        this.addNS("xdp", "http://ns.adobe.com/xdp/");
        this.addNS("xfa", "http://www.xfa.org/schema/xfa-data/1.0/");
    }

    public boolean loadXML(byte[] inputXMLData) {
        boolean result = false;
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read((InputStream)new ByteArrayInputStream(inputXMLData));
            this.oXMLDOM = document.getDocument();
            result = true;
        }
        catch (Exception e) {
            log.debug("loadXml: Error loading XML from Byte[]=" + inputXMLData + " Exception=", (Throwable)e);
            result = false;
        }
        return result;
    }

    public boolean loadXML(String xmlFileRealPath) {
        boolean result = false;
        log.debug("XMLHelperUtil: loadXML: xmlFileRealPath=" + xmlFileRealPath);
        if (xmlFileRealPath == null) {
            log.error("XMLHelperUtil: loadXML: ERROR - xmlFileRealPath=null");
        } else {
            Document doc = null;
            try {
                SAXReader reader = new SAXReader();
                doc = reader.read(new InputSource(new FileInputStream(xmlFileRealPath)));
                log.debug("XMLHelperUtil: loadXML: doc.getXMLEncoding()=" + this.getXMLEncoding());
                this.oXMLDOM = doc.getDocument();
                log.debug("XMLHelperUtil: loaded XML from file " + xmlFileRealPath);
                result = true;
            }
            catch (Exception e) {
                log.error("XMLHelperUtil: loadXML(filename=\"" + xmlFileRealPath + "\"): Exception: ", (Throwable)e);
            }
        }
        return result;
    }

    public boolean loadXMLfromResource(String resourceName) {
        boolean result = true;
        log.debug("XMLHelperUtil: loadXMLfromResource: resourceName=" + resourceName);
        if (resourceName == null) {
            log.error("XMLHelperUtil: loadXMLfromResource: ERROR - xmlFileRealPath=null");
            result = false;
        } else {
            Document doc = null;
            try {
                SAXReader reader = new SAXReader();
                InputStream is = this.getClass().getClassLoader().getResourceAsStream(resourceName);
                doc = reader.read(new InputSource(is));
                log.debug("XMLHelperUtil: loadXML: doc.getXMLEncoding()=" + doc.getXMLEncoding());
                this.oXMLDOM = doc.getDocument();
                log.debug("XMLHelperUtil: loaded XML from resource " + resourceName);
                result = true;
            }
            catch (Exception e) {
                log.warn("XMLHelperUtil: Error loading XML from resource: ", (Throwable)e);
                result = false;
            }
        }
        return result;
    }

    public static Document loadDocFromResource(String resourceName) {
        Document doc = null;
        log.debug("loadDocFromResource: resourceName=" + resourceName);
        if (resourceName == null) {
            log.warn("XMLHelperUtil: loadXMLfromResource: ERROR - xmlFileRealPath=null");
        } else {
            try {
                SAXReader reader = new SAXReader();
                InputStream is = XMLHelperUtil.class.getClassLoader().getResourceAsStream(resourceName);
                doc = reader.read(new InputSource(is));
                log.debug("loadDocFromResource: loaded XML from resource " + resourceName);
            }
            catch (Exception e) {
                log.warn("loadDocFromResource: Error loading XML from resource: ", (Throwable)e);
            }
        }
        return doc;
    }

    public void write2File(String outFileName) {
        try {
            log.debug("XMLHelperUtil: write2file: write xml to file " + outFileName);
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            FileOutputStream fos = new FileOutputStream(outFileName);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            BufferedWriter bw = new BufferedWriter(osw);
            XMLWriter writer = new XMLWriter((Writer)bw, format);
            writer.write(this.oXMLDOM);
            writer.close();
        }
        catch (Exception e) {
            log.warn("XMLHelperUtil: WARNING: Problem in write2File: ", (Throwable)e);
        }
    }

    public String saveXMLasString() {
        String strResultXML = "";
        try {
            StringWriter strWriter = new StringWriter();
            OutputFormat oXMLformat = OutputFormat.createCompactFormat();
            if (this.getXMLEncoding() != null) {
                oXMLformat.setEncoding(this.getXMLEncoding());
            }
            oXMLformat.setTrimText(false);
            XMLWriter oXMLwriter = new XMLWriter((Writer)strWriter, oXMLformat);
            oXMLwriter.write(this.oXMLDOM);
            strResultXML = strWriter.toString();
            strWriter.close();
            log.debug("XMLHelperUtil: saved XML as String");
        }
        catch (Exception e) {
            log.warn("XMLHelperUtil: Error saving XML as String: ", (Throwable)e);
            strResultXML = "";
        }
        return strResultXML;
    }

    public byte[] getXML() {
        return this.getXML(this.getXMLEncoding());
    }

    public byte[] getXML(String encoding) {
        String enc = encoding;
        byte[] result = null;
        try {
            if (enc == null) {
                enc = "UTF-8";
            }
            String strXMLNEW = this.saveXMLasString();
            result = strXMLNEW.getBytes(enc);
        }
        catch (Exception e) {
            log.warn("XMLHelperUtil: Error in getXML->byteArray: ", (Throwable)e);
            result = null;
        }
        return result;
    }

    protected void addNS(String strNSprefix, String strNSURI) {
        this.oHashMapForNS.put(strNSprefix, strNSURI);
    }

    public String getNodeText(String nodeName) {
        String sText = "";
        XPath xpath = this.oXMLDOM.createXPath(nodeName);
        xpath.setNamespaceURIs(this.oHashMapForNS);
        Node oNode = xpath.selectSingleNode((Object)this.oXMLDOM.getDocument());
        if (oNode != null) {
            sText = oNode.getText();
        }
        return sText;
    }

    protected String test(String xpath) {
        log.debug("test: xpath=" + xpath);
        XPath xpathSelector = null;
        try {
            xpathSelector = DocumentHelper.createXPath((String)xpath);
        }
        catch (Exception e) {
            log.error("Sorry, an error occurred: ", (Throwable)e);
        }
        List results = xpathSelector.selectNodes((Object)this.oXMLDOM);
        log.debug("test: " + results.size() + " items found.");
        return "xxx";
    }

    public Node getNode(String sXPath) {
        XPath xpathSelector = null;
        Node n = null;
        try {
            xpathSelector = DocumentHelper.createXPath((String)sXPath);
            n = xpathSelector.selectSingleNode((Object)this.oXMLDOM);
        }
        catch (Exception e) {
            log.error("XMLHelperUtil: getNode: ERROR: ", (Throwable)e);
            n = null;
        }
        return n;
    }

    public List getList(String sXPath) {
        XPath xpathSelector = null;
        List results = null;
        try {
            xpathSelector = DocumentHelper.createXPath((String)sXPath);
            results = xpathSelector.selectNodes((Object)this.oXMLDOM);
        }
        catch (Exception e) {
            log.warn("XMLHelperUtil: Exception in getList: xPath= " + sXPath + "XMLHelperUtil: Exception=", (Throwable)e);
            results = null;
        }
        return results;
    }

    public void setNodeText(String nodeName, String strTextToSet) {
        XPath xpath = this.oXMLDOM.createXPath(nodeName);
        xpath.setNamespaceURIs(this.oHashMapForNS);
        Node oNode = xpath.selectSingleNode((Object)this.oXMLDOM.getDocument());
        if (oNode != null) {
            oNode.setText(strTextToSet);
        } else {
            log.warn("XMLHelperUtil: setNodeText: Node not found, " + nodeName + "=" + strTextToSet);
        }
    }

    public Node addNode(String parentPath, String nodeName, String defaultValue) {
        String xp = parentPath + "/" + nodeName;
        Node n = this.getNode(xp);
        if (n == null) {
            log.debug("XMLHelperUtil: addNode: <" + nodeName + "> is inserted and set to this value: " + defaultValue);
            Element parentEle = (Element)this.getNode(parentPath);
            if (parentEle == null) {
                log.warn("XMLHelperUtil: ASF-XML data is invalid. The path does not exist: xp=" + parentPath);
            } else {
                Element ele = parentEle.addElement(nodeName).addText(defaultValue);
                n = ele;
            }
        }
        return n;
    }

    public Node setOrAddNodeText(String parentPath, String nodeName, String nodeValue) {
        String xp = parentPath + "/" + nodeName;
        Node n = this.getNode(xp);
        if (n == null) {
            Element parentEle = (Element)this.getNode(parentPath);
            if (parentEle == null) {
                log.warn("XMLHelperUtil: Cannot add node <" + nodeName + ">. This path does not exist: xp=" + parentPath);
            } else {
                Element ele = parentEle.addElement(nodeName).addText(nodeValue);
                n = ele;
            }
        } else {
            this.setNodeText(xp, nodeValue);
        }
        return n;
    }

    public void dump() {
        log.debug("\n------ dump start -------");
        XMLHelperUtil.dumpNodeEle(this.oXMLDOM.getRootElement());
        log.debug("\n------ dump ende -------\n");
    }

    protected static void dumpNodeEle(Element nodeEle) {
        XMLHelperUtil.dumpNodeEle(nodeEle, 0);
    }

    private static void dumpNodeEle(Element nodeEle, int depth) {
        if (nodeEle == null) {
            return;
        }
        String outLine = "::" + nodeEle.getNamespacePrefix() + "::" + nodeEle.getPath() + "::";
        for (int i = 0; i < depth; ++i) {
            outLine = outLine + "\t";
        }
        outLine = outLine + "<" + nodeEle.getName();
        Iterator attrIter = nodeEle.attributeIterator();
        while (attrIter.hasNext()) {
            Attribute attrib = (Attribute)attrIter.next();
            outLine = outLine + " " + attrib.getName() + "=\"" + attrib.getValue() + "\"";
        }
        outLine = outLine + ">";
        List texts = nodeEle.selectNodes("text()");
        for (int i = 0; i < texts.size(); ++i) {
            outLine = outLine + ((Node)texts.get(i)).getText();
        }
        log.debug(outLine);
        Iterator eleIter = nodeEle.elementIterator();
        while (eleIter.hasNext()) {
            XMLHelperUtil.dumpNodeEle((Element)eleIter.next(), depth + 1);
        }
        outLine = "";
        for (int i = 0; i < depth; ++i) {
            outLine = outLine + "\t";
        }
        log.debug("</" + nodeEle.getName() + ">");
    }

    public Document getXmlDocument() {
        return this.oXMLDOM;
    }

    public static byte[] xslTransform(String sXml, String xslResourceFilename) {
        byte[] baResult = null;
        InputStream is = null;
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            is = XMLHelperUtil.class.getClassLoader().getResourceAsStream(xslResourceFilename);
            Templates template = factory.newTemplates(new StreamSource(is));
            Transformer xformer = template.newTransformer();
            StringReader reader = new StringReader(sXml);
            StreamSource source = new StreamSource(reader);
            StringWriter strWriter = new StringWriter();
            StreamResult result = new StreamResult(strWriter);
            xformer.transform(source, result);
            baResult = strWriter.toString().getBytes("UTF-8");
        }
        catch (TransformerConfigurationException e) {
            log.error("xsl: Incorrect XSL: ", (Throwable)e);
        }
        catch (TransformerException e) {
            log.error("xsl: Exception received during the XSLT transformation: ", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ICCException("ALC-ACM-002-013", 1, e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                log.debug("IO Exception Error in XML util. ", (Throwable)e);
            }
        }
        return baResult;
    }

    public static byte[] addFormbridge(byte[] baXdpData) {
        byte[] baCustomizedXdpData = baXdpData;
        XMLHelperUtil formbridge = new XMLHelperUtil();
        formbridge.loadXMLfromResource("com/adobe/ddg/scripts.xml");
        XMLHelperUtil xdp = new XMLHelperUtil();
        xdp.loadXML(baXdpData);
        Element myNode = (Element)xdp.getNode("/descendant::*[name()='template']/*[name()='subform']");
        Element myBridge = (Element)formbridge.getNode("/scripts/formbridge/subform");
        if (myNode == null || myBridge == null) {
            log.debug("addFormbridge: Cannot insert field/script.");
        }
        if (myBridge != null) {
            myBridge = myBridge.createCopy();
        }
        if (myNode != null) {
            myNode.add(myBridge);
        }
        log.debug("addFormbridge: Field/Script inserted.");
        baCustomizedXdpData = xdp.getXML();
        return baCustomizedXdpData;
    }

    public static byte[] markDuplicate(byte[] xmlData) {
        XMLHelperUtil data = new XMLHelperUtil();
        boolean valid = data.loadXML(xmlData);
        if (!valid) {
            throw new ICCException("ALC-ACM-003-005", new String[]{"Letter"}, 1);
        }
        Element iccRoot = DBUtils.getControlDataRoot(data);
        if (iccRoot == null) {
            log.error("No 'icc:icc' Control Data node found.");
            throw new ICCException("ALC-ACM-003-005", new String[]{"Letter"}, 1);
        }
        Element iccMetaDataNode = DBUtils.getChildNode(iccRoot, "icc:meta");
        Element duplicateNode = DBUtils.getChildNode(iccMetaDataNode, "duplicate");
        duplicateNode.setText("true");
        return data.getXML();
    }

    public String[] getNodeValues(String sXPath) {
        String[] retvalues = null;
        try {
            int j = 0;
            List nodes = this.getList(sXPath);
            String[] values = new String[nodes.size()];
            for (Node node : nodes) {
                values[j] = node.getText();
                ++j;
            }
            retvalues = values;
        }
        catch (Exception e) {
            log.warn("Unable to create Node.");
            log.error("Error: ", (Throwable)e);
        }
        return retvalues;
    }
}

