/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.icc.dbforms.util;

import com.adobe.aemds.settings.AemDsSettingsService;
import com.adobe.icc.dbforms.exceptions.ICCException;
import com.adobe.icc.dbforms.util.JCRSessionUtils;
import com.adobe.idp.common.util.Base64;
import com.googlecode.jsonrpc4j.JsonRpcHttpClient;
import com.googlecode.jsonrpc4j.ProxyUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;

public class JsonRPCUtils {
    private static AemDsSettingsService aemService;

    public static Object getServiceProxy(Class serviceClass, String serviceInvocationId) throws ICCException {
        String password;
        String remoteUrl;
        Object service = null;
        String string = remoteUrl = aemService.getProcessingServerUrl() == null ? null : aemService.getProcessingServerUrl().trim();
        if (remoteUrl == null || remoteUrl.isEmpty()) {
            throw new ICCException("Processing author configuration not set.");
        }
        if (remoteUrl.endsWith("/")) {
            remoteUrl = remoteUrl.substring(0, remoteUrl.length() - 1);
        }
        String userName = aemService.getProcessingServerUsername() == null ? null : aemService.getProcessingServerUsername();
        String string2 = password = aemService.getProcessingServerPassword() == null ? null : aemService.getProcessingServerPassword();
        if (userName == null || password == null || userName.isEmpty() || password.isEmpty()) {
            throw new ICCException("Processing author credentials not set.");
        }
        String auth = userName + ":" + password;
        String auth64 = Base64.encode((String)auth);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Basic " + auth64);
        headers.put("AEP-APP-ROOT", "/content/apps/cm");
        try {
            JsonRpcHttpClient jsonClient = new JsonRpcHttpClient(new URL(remoteUrl + "/libs/fd/cm/content/crud" + "." + serviceInvocationId + ".json"), headers);
            service = ProxyUtil.createClientProxy((ClassLoader)serviceClass.getClassLoader(), (Class)serviceClass, (JsonRpcHttpClient)jsonClient);
        }
        catch (MalformedURLException e) {
            JCRSessionUtils.rollbackCurrentSession();
            throw new ICCException("ALC-ACM-002-013", 1, e);
        }
        return service;
    }

    public static void setAemService(AemDsSettingsService aemSettingsService) {
        aemService = aemSettingsService;
    }
}

