/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.icc.dbforms.util;

import com.adobe.icc.dbforms.exceptions.ICCException;
import com.adobe.icc.dbforms.obj.Asset;
import com.adobe.icc.dbforms.obj.AssetType;
import com.adobe.icc.dbforms.obj.ContainerLayout;
import com.adobe.icc.dbforms.obj.ContainerLayoutAssignment;
import com.adobe.icc.dbforms.obj.ExternalAssetType;
import com.adobe.icc.dbforms.obj.Letter;
import com.adobe.icc.dbforms.obj.TableRow;
import com.adobe.icc.dbforms.obj.TargetAreaAssignment;
import com.adobe.icc.dbforms.util.JCRSessionUtils;
import com.adobe.icc.dbforms.util.TempFileManager;
import com.adobe.icc.dbforms.util.XMLHelperUtil;
import com.adobe.livecycle.content.appcontext.AppContext;
import com.adobe.livecycle.content.appcontext.AppContextManager;
import com.adobe.livecycle.content.sling.ResourceResolverHolder;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.settings.SlingSettingsService;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ACMUtil {
    private static final String CONTENT_APPS_FOLDER = "/content/apps";
    public static final String DEFAULT_APPS_CONTEXT = "/content/apps/cm";
    private static final String ACM_CONFIGURATION_FOLDER = "fd/cm/config";
    public static final String DEFAULT_APP_CONFIG_FOLDER = "/defaultApp";
    private static final String RUN_MODE_PUBLISH = "publish";
    public static final String DEFAULT_EXTERNAL_ASSETS_FOLDER = "/content/dam";
    private static final String XDP = ".xdp";
    private static final Logger logger = LoggerFactory.getLogger((String)ACMUtil.class.getName());
    private static Map<String, AssetType> assetFolderToTypeMap = new HashMap<String, AssetType>();
    private static Map<String, String> appNameToGroupNameMap = new HashMap<String, String>();

    public static String getConfigFolderForBB() {
        return ACM_CONFIGURATION_FOLDER;
    }

    public static String getAppName() {
        String path = "";
        String contentAppFolder = "/content/apps/";
        AppContext appContext = AppContextManager.getCurrentAppContext();
        if (appContext == null) {
            throw new ICCException("ALC-ACM-004-003", 1);
        }
        String currentAppContext = appContext.getAppRoot();
        if (currentAppContext.startsWith(contentAppFolder)) {
            path = currentAppContext.substring(contentAppFolder.length());
        }
        return path;
    }

    public static String getAppGroupName() {
        String appsConfigPath = TempFileManager.getResolvedResourcePath(null, "fd/cm/config/AppsConfig.xml");
        String appId = ACMUtil.getAppName();
        if (appNameToGroupNameMap.containsKey(appId) && appNameToGroupNameMap.get(appId) != null) {
            return appNameToGroupNameMap.get(appId);
        }
        try {
            byte[] appsConfigBytes = TempFileManager.retrieveContentFromJCRRepository(appsConfigPath);
            if (appsConfigBytes == null) {
                logger.info("ACM Application Configuration File not found.");
            }
            String appsConfig = new String(appsConfigBytes, "UTF-8");
            XMLHelperUtil appsXML = new XMLHelperUtil();
            appsXML.loadXML(appsConfig.getBytes());
            List nodes = appsXML.getList("appsConfig/applications/application");
            Element dataTypeNode = null;
            if (nodes != null) {
                for (int nodeIndex = 0; nodeIndex < nodes.size(); ++nodeIndex) {
                    dataTypeNode = (Element)nodes.get(nodeIndex);
                    appNameToGroupNameMap.put(dataTypeNode.attributeValue("id"), dataTypeNode.attributeValue("groupName"));
                }
            }
            return appNameToGroupNameMap.get(appId);
        }
        catch (Exception e) {
            logger.error("Error reading ACM Application Configuration File.", (Throwable)e);
            throw new ICCException("ALC-ACM-002-802", 1);
        }
    }

    public static String getSolutionSpecficConfigFolderForBB() throws ICCException {
        AppContext appContext = AppContextManager.getCurrentAppContext();
        if (appContext == null) {
            throw new ICCException("ALC-ACM-004-003", 1);
        }
        String currentAppContext = appContext.getAppRoot();
        if (DEFAULT_APPS_CONTEXT.equals(currentAppContext)) {
            return TempFileManager.getResolvedResourcePath(null, ACMUtil.getConfigFolderForBB() + DEFAULT_APP_CONFIG_FOLDER);
        }
        if (currentAppContext.startsWith(CONTENT_APPS_FOLDER)) {
            String path = TempFileManager.getResolvedResourcePath(null, ACMUtil.getConfigFolderForBB() + currentAppContext.substring(CONTENT_APPS_FOLDER.length()));
            try {
                if (path == null || path.isEmpty()) {
                    path = TempFileManager.getResolvedResourcePath(null, ACMUtil.getConfigFolderForBB() + DEFAULT_APP_CONFIG_FOLDER);
                    logger.info("Unable to find the Node in selected app context : " + path + " switching to default app context ");
                }
            }
            catch (ICCException ex) {
                logger.error("Error in checking nodeExists : ", (Throwable)ex);
                path = TempFileManager.getResolvedResourcePath(null, ACMUtil.getConfigFolderForBB() + DEFAULT_APP_CONFIG_FOLDER);
                logger.info("Unable to find the Node in selected app context : " + path + " switching to default app context ");
            }
            return path;
        }
        return TempFileManager.getResolvedResourcePath(null, ACMUtil.getConfigFolderForBB() + currentAppContext);
    }

    public static boolean loggedInUserHasRole(String roleName) throws ICCException {
        try {
            String appGroupName = ACMUtil.getAppGroupName();
            if (appGroupName != null && appGroupName != "") {
                roleName = appGroupName + " " + roleName;
            }
            Class<?> LiveCycleUtil = null;
            boolean isLCUser = false;
            try {
                LiveCycleUtil = Class.forName("com.adobe.icc.dbforms.util.LiveCycleUtil");
                isLCUser = (Boolean)LiveCycleUtil.getMethod("isLCUser", new Class[0]).invoke(LiveCycleUtil, new Object[0]);
            }
            catch (Exception e) {
                logger.debug("Exception error while getting method for Livecycle utility.", (Throwable)e);
            }
            if (!isLCUser) {
                return ACMUtil.isLoggedInUserMemberOf(roleName);
            }
            return (Boolean)LiveCycleUtil.getMethod("isLoggedInUserMemberOf", String.class).invoke(LiveCycleUtil, roleName);
        }
        catch (Exception e) {
            throw new ICCException("ALC-ACM-004-002", 1, e);
        }
    }

    private static boolean isLoggedInUserMemberOf(String groupName) throws ICCException {
        String userId = ResourceResolverHolder.getResourceResolver().getUserID();
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)JCRSessionUtils.getCurrentSession());
            User user = (User)userManager.getAuthorizable(userId);
            if (user != null) {
                if (user.isAdmin()) {
                    return true;
                }
                Iterator grpItr = user.memberOf();
                while (grpItr.hasNext()) {
                    Group group = (Group)grpItr.next();
                    if (!groupName.equals(group.getID())) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            throw new ICCException("ALC-ACM-004-002", 1, e);
        }
    }

    public static boolean isAuthorInstance(SlingSettingsService slingSettingsService) {
        Set runModes = slingSettingsService.getRunModes();
        return !runModes.contains(RUN_MODE_PUBLISH);
    }

    public static AssetType getAssetType(String assetId) {
        String[] pathElements = assetId.split("/");
        if (assetId.startsWith(DEFAULT_EXTERNAL_ASSETS_FOLDER)) {
            return AssetType.EXTERNAL;
        }
        if (pathElements != null && pathElements.length >= 6) {
            String pathElement = pathElements[4];
            String rootFolder = null;
            rootFolder = pathElement.equals("categories") || pathElement.equals("datadictionaries") || pathElement.equals("letterInstances") ? pathElement : pathElements[5];
            return assetFolderToTypeMap.get(rootFolder);
        }
        return null;
    }

    public static ExternalAssetType getExternalAssetTypeName(String assetId) {
        if (assetId.toLowerCase().endsWith(XDP)) {
            return ExternalAssetType.XDP;
        }
        return ExternalAssetType.IMAGE;
    }

    public static Object xmlEscapeObject(Object object) {
        block2: {
            block4: {
                block3: {
                    if (object == null) break block2;
                    if (!(object instanceof String)) break block3;
                    object = ACMUtil.xmlEscapeTextContent((String)object);
                    break block2;
                }
                if (!(object instanceof List)) break block4;
                List list = (List)object;
                for (int index = 0; index < list.size(); ++index) {
                    list.set(index, ACMUtil.xmlEscapeObject(list.get(index)));
                }
                break block2;
            }
            if (!(object instanceof Map)) break block2;
            Map map = (Map)object;
            for (Map.Entry entry : map.entrySet()) {
                entry.setValue(ACMUtil.xmlEscapeObject(entry.getValue()));
            }
        }
        return object;
    }

    public static String xmlEscapeTextContent(String content) {
        if (content == null) {
            return null;
        }
        if (content.length() == 0) {
            return "";
        }
        String escapedContent = new String(content);
        escapedContent = escapedContent.replaceAll("\\x26", "&amp;");
        escapedContent = escapedContent.replaceAll("\\x3C", "&lt;");
        escapedContent = escapedContent.replaceAll("\\x3E", "&gt;");
        return escapedContent;
    }

    public static <T extends Asset> void findAllChildAssets(Object obj, Class assetType, Map<String, T> allAssets) throws ICCException {
        try {
            PropertyDescriptor[] propDescriptors;
            for (PropertyDescriptor propDescriptor : propDescriptors = PropertyUtils.getPropertyDescriptors((Object)obj)) {
                Collection tempValue;
                List<Object> objValues = new ArrayList();
                Class<?> fieldClass = propDescriptor.getPropertyType();
                boolean isArray = fieldClass.isArray();
                boolean isCollection = false;
                if (!isArray && Collection.class.isAssignableFrom(fieldClass)) {
                    isCollection = true;
                }
                if (isArray) {
                    Class<?> arrayDataType = fieldClass.getComponentType();
                    if (Byte.class.isAssignableFrom(arrayDataType) || Byte.TYPE.isAssignableFrom(arrayDataType)) continue;
                    Object tempValue2 = PropertyUtils.getProperty((Object)obj, (String)propDescriptor.getName());
                    if (tempValue2 != null) {
                        objValues = Arrays.asList(tempValue2);
                    }
                } else if (isCollection && (tempValue = (Collection)PropertyUtils.getProperty((Object)obj, (String)propDescriptor.getName())) != null) {
                    objValues.addAll(tempValue);
                }
                if (isArray || isCollection) {
                    if (objValues == null || objValues.size() <= 0) continue;
                    for (Object collObj : objValues) {
                        if (assetType.isAssignableFrom(collObj.getClass()) && !(collObj instanceof TableRow)) {
                            if (allAssets.containsKey(((Asset)collObj).getId())) continue;
                            allAssets.put(((Asset)collObj).getId(), (Asset)collObj);
                        }
                        if (collObj.getClass().getPackage() == null || !collObj.getClass().getPackage().getName().equals("com.adobe.icc.dbforms.obj")) continue;
                        ACMUtil.findAllChildAssets(collObj, assetType, allAssets);
                    }
                    continue;
                }
                Object childObj = PropertyUtils.getProperty((Object)obj, (String)propDescriptor.getName());
                if (childObj == null) continue;
                if (assetType.isAssignableFrom(childObj.getClass()) && !(childObj instanceof TableRow)) {
                    if (allAssets.containsKey(((Asset)childObj).getId())) continue;
                    allAssets.put(((Asset)childObj).getId(), (Asset)childObj);
                }
                if (childObj.getClass() == null || !childObj.getClass().getPackage().getName().equals("com.adobe.icc.dbforms.obj")) continue;
                ACMUtil.findAllChildAssets(childObj, assetType, allAssets);
            }
        }
        catch (Exception ex) {
            throw new ICCException("ALC-ACM-002-013", 1, ex);
        }
    }

    public static boolean usesFragments(Letter letter) {
        if (letter.getTargetAreaAssignments() != null) {
            for (TargetAreaAssignment taa : letter.getTargetAreaAssignments()) {
                if (taa.getContainerLayoutAssignmentList() == null || taa.getContainerLayoutAssignmentList().size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean usesConditionalFragments(Set<TargetAreaAssignment> taaSet) {
        if (taaSet != null) {
            for (TargetAreaAssignment taa : taaSet) {
                if (taa.getContainerLayoutAssignmentList() == null) continue;
                for (ContainerLayoutAssignment cla : taa.getContainerLayoutAssignmentList()) {
                    if (cla.getExpression() != null && cla.getExpression().length() > 0) {
                        return true;
                    }
                    if (!ACMUtil.usesConditionalFragments(cla.getTargetAreaAssignments())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void populateAllFragments(Set<TargetAreaAssignment> taaSet, Map<String, Asset> assetMap) {
        if (taaSet != null) {
            for (TargetAreaAssignment taa : taaSet) {
                if (taa.getContainerLayoutAssignmentList() == null) continue;
                for (ContainerLayoutAssignment cla : taa.getContainerLayoutAssignmentList()) {
                    ContainerLayout cl = cla.getContainerLayout();
                    assetMap.put(cl.getId(), cl);
                    ACMUtil.populateAllFragments(cla.getTargetAreaAssignments(), assetMap);
                }
            }
        }
    }

    public static Map<String, Date> getLastModifyTimeForAssets(List<String> assetIds) {
        try {
            long time1 = System.currentTimeMillis();
            HashMap<String, Date> assetModifyTimeMap = new HashMap<String, Date>();
            Session jcrSession = JCRSessionUtils.getCurrentSession();
            for (String assetId : assetIds) {
                if (ACMUtil.isExternalAsset(assetId)) {
                    if (!TempFileManager.nodeExists(assetId)) {
                        throw new ICCException("External asset at " + assetId + "does not exists.");
                    }
                    assetModifyTimeMap.put(assetId, null);
                    continue;
                }
                Property jcrProperty = jcrSession.getProperty(assetId + "/lastUpdateDate");
                if (jcrProperty == null || jcrProperty.getValue() == null || jcrProperty.getValue().getDate() == null) continue;
                Date lastUpdateDate = jcrProperty.getValue().getDate().getTime();
                assetModifyTimeMap.put(assetId, lastUpdateDate);
            }
            long time2 = System.currentTimeMillis();
            logger.debug("CM PERF: time in reading modifyTime of all assets in the letter:" + (time2 - time1) + "ms");
            return assetModifyTimeMap;
        }
        catch (RepositoryException e) {
            throw new ICCException("ALC-ACM-002-013", e);
        }
    }

    public static boolean isExternalAsset(String assetId) {
        return ACMUtil.getAssetType(assetId) == AssetType.EXTERNAL;
    }

    public static String getNameFromId(String id) {
        if (id != null) {
            String[] paths = id.split("/");
            if (paths.length == 0) {
                logger.error("Id cannot be empty");
            } else {
                return paths[paths.length - 1];
            }
        }
        return "";
    }

    static {
        assetFolderToTypeMap.put("forms", AssetType.LAYOUT);
        assetFolderToTypeMap.put("fragmentlayouts", AssetType.FRAGMENT);
        assetFolderToTypeMap.put("texts", AssetType.TEXT);
        assetFolderToTypeMap.put("images", AssetType.IMAGE);
        assetFolderToTypeMap.put("lists", AssetType.LIST);
        assetFolderToTypeMap.put("conditions", AssetType.CONDITION);
        assetFolderToTypeMap.put("contents", AssetType.CONTENT);
        assetFolderToTypeMap.put("letters", AssetType.LETTER);
        assetFolderToTypeMap.put("letterInstances", AssetType.LETTERINSTANCE);
        assetFolderToTypeMap.put("portfoliodocuments", AssetType.PORTFOLIODOCUMENT);
        assetFolderToTypeMap.put("conditionaldocuments", AssetType.CONDITIONALDOCUMENT);
        assetFolderToTypeMap.put("portfolios", AssetType.PORTFOLIO);
        assetFolderToTypeMap.put("categories", AssetType.CATEGORY);
        assetFolderToTypeMap.put("datadictionaries", AssetType.DATADICTIONARY);
    }
}

