/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.signatures.client.types;

import java.io.Serializable;
import java.util.Arrays;

public class PDFSignature
implements Serializable {
    private static final long serialVersionUID = -3920827908241085518L;
    byte[] contents;
    String filter;
    String subFilter;
    byte[][] certs;
    byte[][] crls;
    byte[][] ocspResponses;
    byte[] timestamp;

    public byte[][] getCRLs() {
        return this.crls;
    }

    public void setCRLs(byte[][] crls) {
        if (crls != null) {
            this.crls = this.copy2DByteArray(crls);
        }
    }

    public byte[][] getOCSPResponses() {
        return this.ocspResponses;
    }

    public void setOCSPResponses(byte[][] ocspResponses) {
        if (ocspResponses != null) {
            this.ocspResponses = this.copy2DByteArray(ocspResponses);
        }
    }

    public byte[] getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(byte[] timestamp) {
        if (timestamp != null) {
            this.timestamp = Arrays.copyOf(timestamp, timestamp.length);
        }
    }

    public byte[][] getCertificates() {
        return this.certs;
    }

    public void setCertificates(byte[][] certs) {
        if (certs != null) {
            this.certs = this.copy2DByteArray(certs);
        }
    }

    public byte[] getContents() {
        return this.contents;
    }

    public void setContents(byte[] contents) {
        if (contents != null) {
            this.contents = Arrays.copyOf(contents, contents.length);
        }
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getSubFilter() {
        return this.subFilter;
    }

    public void setSubFilter(String subFilter) {
        this.subFilter = subFilter;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("filter=").append(this.filter).append(",");
        sb.append("subfilter=").append(this.subFilter);
        return sb.toString();
    }

    private byte[][] copy2DByteArray(byte[][] input) {
        if (input.length < 1) {
            return input;
        }
        byte[][] newKeyId = new byte[input.length][];
        for (int i = 0; i < input.length; ++i) {
            if (input[i] == null) continue;
            newKeyId[i] = Arrays.copyOf(input[i], input[i].length);
        }
        return newKeyId;
    }
}

