/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.common.GuideNode;
import com.adobe.aemds.guide.common.GuidePanel;
import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.service.GuideLocalizationService;
import com.adobe.aemds.guide.service.GuideModuleImporter;
import com.adobe.aemds.guide.submitutils.FileRequestParameter;
import com.adobe.aemds.guide.taglibs.GuideELUtils;
import com.adobe.aemds.guide.utils.DataLookUp;
import com.adobe.aemds.guide.utils.GuideConstants;
import com.adobe.forms.common.service.FileAttachmentWrapper;
import com.adobe.forms.common.service.StaleAssetIndicatorService;
import com.adobe.forms.common.submitutils.CustomParameterRequest;
import com.adobe.forms.common.submitutils.CustomResponse;
import com.adobe.forms.common.submitutils.ParameterMap;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import com.day.cq.i18n.I18n;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuideUtils {
    private static Logger logger = LoggerFactory.getLogger(GuideUtils.class);

    public static String humanize(String name) {
        if (name == null) {
            return null;
        }
        String humanizedName = name.replaceAll("_", " ");
        humanizedName = humanizedName.replaceAll("([A-Z][a-z]+)", " $1").replaceAll("([A-Z][A-Z]+)", " $1").replaceAll("([^A-Za-z ]+)", " $1").trim();
        humanizedName = WordUtils.capitalize((String)humanizedName);
        return humanizedName;
    }

    public static Map<String, String> convertStringToMap(String params) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (params != null) {
            String[] strategyParams;
            for (String param : strategyParams = params.split(",")) {
                String[] keyValue = param.split("=");
                if (keyValue.length == 2) {
                    paramMap.put(keyValue[0], keyValue[1]);
                    continue;
                }
                paramMap.put(param, param);
            }
        }
        return paramMap;
    }

    public static String guideRefToGuidePath(String guideRefPath) {
        if (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)guideRefPath, (CharSequence)"/content/dam/formsanddocuments/")) {
            return "/content/forms/af/" + org.apache.commons.lang3.StringUtils.substringAfter((String)guideRefPath, (String)"/content/dam/formsanddocuments/") + "/jcr:content/guideContainer";
        }
        return guideRefPath;
    }

    public static String manipulateBindRefForFragments(String bindRefPrefixForFragment, String bindRef, String fragmentRoot) {
        String manipulatedBindRef = bindRef;
        if (bindRefPrefixForFragment != null && bindRefPrefixForFragment.length() > 0 && fragmentRoot != null && fragmentRoot.length() > 0) {
            if (fragmentRoot.equals(bindRef)) {
                return null;
            }
            if (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)bindRef, (CharSequence)"xfa[0].")) {
                manipulatedBindRef = bindRefPrefixForFragment + org.apache.commons.lang3.StringUtils.substringAfter((String)bindRef, (String)fragmentRoot);
            } else if (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)bindRef, (CharSequence)"/")) {
                manipulatedBindRef = bindRefPrefixForFragment + org.apache.commons.lang3.StringUtils.substringAfter((String)bindRef, (String)fragmentRoot);
            }
        }
        return manipulatedBindRef;
    }

    public static String getNamespacedKeys(String key) {
        return "fd_" + key;
    }

    public static String translateOrReturnOriginal(String original, I18n i18n) {
        String localizedkey;
        String nameSpacedkey;
        if (i18n != null && !(nameSpacedkey = GuideUtils.getNamespacedKeys(original)).equals(localizedkey = i18n.getVar(nameSpacedkey))) {
            return localizedkey;
        }
        return original;
    }

    public static String escapeXml(String unescaped) {
        return StringEscapeUtils.escapeXml((String)unescaped);
    }

    public static boolean isGuideFileUploadModel(String guideNodeClass) {
        return "guideFileUpload".equals(guideNodeClass);
    }

    public static boolean isGuideButtonModel(String guideNodeClass) {
        return "guideButton".equals(guideNodeClass);
    }

    public static boolean isGuideFieldModel(String guideNodeClass) {
        return GuideConstants.GUIDE_FIELDS_CLASS_NAMES.indexOf(guideNodeClass) >= 0;
    }

    public static ValueMap getGuideContainer(SlingHttpServletRequest request, Resource elementResource) throws RepositoryException {
        if (elementResource == null) {
            return null;
        }
        Iterator iter = elementResource.listChildren();
        Resource guideContainer = null;
        while (iter.hasNext() && guideContainer == null) {
            Resource current = (Resource)iter.next();
            if (!GuideConstants.CONTAINER_RESOURCES.contains(current.getResourceType())) continue;
            guideContainer = current;
        }
        if (guideContainer != null) {
            return ResourceUtil.getValueMap(guideContainer);
        }
        logger.error("No guideContainer found");
        throw new GuideException("No guideContainer found");
    }

    public static Boolean isValidGuide(SlingHttpServletRequest request, Resource resource) throws RepositoryException {
        ValueMap properties = null;
        properties = GuideConstants.CONTAINER_RESOURCES.contains(resource.getResourceType()) ? ResourceUtil.getValueMap((Resource)resource) : GuideUtils.getGuideContainer(request, resource);
        String guideRef = (String)properties.get("guideRef", null);
        if (guideRef != null && guideRef.length() != 0) {
            String guideContainerPath = GuideUtils.guideRefToGuidePath(guideRef);
            Resource guideContainer = request.getResourceResolver().getResource(guideContainerPath);
            if (guideContainer == null) {
                logger.error("No guide found in guide reference present in guide container");
                return false;
            }
        }
        return true;
    }

    public static String getNormalizedNodeType(String resourceType, String resourceSuperType) {
        String normalizedType = null;
        if (resourceType == null && resourceSuperType == null) {
            return null;
        }
        if (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)resourceType, (CharSequence)"fd/")) {
            normalizedType = resourceType;
        } else if (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)resourceType, (CharSequence)"/libs/fd/") || org.apache.commons.lang3.StringUtils.startsWith((CharSequence)resourceType, (CharSequence)"/apps/fd/")) {
            normalizedType = resourceType.substring(6);
        } else if (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)resourceSuperType, (CharSequence)"fd/")) {
            normalizedType = resourceSuperType;
        } else if (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)resourceSuperType, (CharSequence)"/libs/fd/") || org.apache.commons.lang3.StringUtils.startsWith((CharSequence)resourceSuperType, (CharSequence)"/apps/fd/")) {
            normalizedType = resourceSuperType.substring(6);
        }
        return normalizedType;
    }

    public static void walkThroughContent(List<String> list, Resource elementResource, String resourceToBeFound) {
        if (elementResource == null) {
            return;
        }
        Iterator iter = elementResource.listChildren();
        while (iter.hasNext()) {
            Resource current = (Resource)iter.next();
            String normalizedNodeType = GuideUtils.getNormalizedNodeType(current.getResourceType(), current.getResourceSuperType());
            if (resourceToBeFound.equals(normalizedNodeType)) {
                list.add(current.getPath());
            }
            GuideUtils.walkThroughContent(list, current, resourceToBeFound);
        }
    }

    public static boolean isLayoutablePanel(GuideNode node) {
        String nodeType = GuideUtils.getNormalizedNodeType(node.getResourceType(), node.getResourceSuperType());
        return "fd/af/components/rootPanel".equals(nodeType) || "fd/af/components/panel".equals(nodeType);
    }

    public static String convertFMAssetPathToContainerPath(String fragRef) {
        fragRef = StringUtils.replace((String)fragRef, (String)"/content/dam/formsanddocuments/", (String)"/content/forms/af/", (int)1);
        fragRef = fragRef + "/jcr:content" + "/" + "guideContainer";
        return fragRef;
    }

    public static ResourceResolver getResolverFromResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        if (resourceResolverHelper != null) {
            return resourceResolverHelper.getResourceResolver();
        }
        return null;
    }

    public static StrSubstitutor getStringSubstitutor(JSONObject valueMap) {
        return new StrSubstitutor((StrLookup)new DataLookUp(valueMap));
    }

    public static GuidePanel getRootPanel(Resource resource, SlingHttpServletRequest slingRequest) {
        Iterator iter = resource.listChildren();
        GuidePanel rootPanel = null;
        ResourceResolver resourceResolver = resource.getResourceResolver();
        while (iter.hasNext() && rootPanel == null) {
            Resource current = (Resource)iter.next();
            String name = current.getName();
            if (!"rootPanel".equals(name)) continue;
            rootPanel = new GuidePanel();
            rootPanel.setResource(current);
            rootPanel.setSlingRequest(slingRequest);
        }
        return rootPanel;
    }

    public static GuideModuleImporter getGuideModuleImporter(SlingHttpServletRequest slingRequest) {
        SlingBindings bindings = null;
        GuideModuleImporter guideModuleImporter = null;
        if (slingRequest != null && (bindings = (SlingBindings)slingRequest.getAttribute(SlingBindings.class.getName())) != null) {
            guideModuleImporter = (GuideModuleImporter)bindings.getSling().getService(GuideModuleImporter.class);
        }
        return guideModuleImporter;
    }

    public static Resource getRootPanel(Resource resource) {
        try {
            for (Resource item : resource.getChildren()) {
                String valueOfResourceType;
                ValueMap valueMap = (ValueMap)item.adaptTo(ValueMap.class);
                if (valueMap.get((Object)"sling:resourceType") == null || !"fd/af/components/rootPanel".equals(valueOfResourceType = (String)valueMap.get((Object)"sling:resourceType"))) continue;
                return item;
            }
        }
        catch (Exception e) {
            logger.error("error in getting root panel via guide json", (Throwable)e);
        }
        return null;
    }

    protected static String removePrefix(String str, String prefix) {
        if (str == null || prefix == null) {
            return str;
        }
        if (str.startsWith(prefix)) {
            return str.substring(prefix.length());
        }
        return str;
    }

    public static boolean isXDPValid(Resource guideContainer) {
        if (guideContainer == null) {
            return false;
        }
        ResourceResolver resolver = guideContainer.getResourceResolver();
        ValueMap guideContainerProps = (ValueMap)guideContainer.adaptTo(ValueMap.class);
        String xdpRef = (String)guideContainerProps.get("xdpRef", null);
        if (xdpRef == null || xdpRef.length() == 0) {
            return false;
        }
        return resolver.getResource(xdpRef) != null;
    }

    public static boolean isGuideContainerResource(Resource resource) {
        return GuideConstants.CONTAINER_RESOURCES.contains(resource.getResourceType());
    }

    public static boolean isTargetEnabled(Resource guideContainerResource) {
        ValueMap props = (ValueMap)guideContainerResource.getParent().adaptTo(ValueMap.class);
        return (Boolean)props.get("targetEnabled", (Object)false);
    }

    public static String getAlternateContainerPathFromCurrentContainer(RequestPathInfo requestPathInfo) {
        String currentContainerPath = requestPathInfo.getResourcePath();
        String extension = null;
        if (currentContainerPath == null) {
            return null;
        }
        extension = requestPathInfo.getExtension();
        if (extension == null) {
            return currentContainerPath.substring(0, currentContainerPath.lastIndexOf("/")) + "/" + "guideContainer2";
        }
        return currentContainerPath.substring(0, currentContainerPath.lastIndexOf("/")) + "/" + "guideContainer2" + "." + extension;
    }

    public static boolean isDorTemplateRefValid(Resource guideContainer) {
        if (guideContainer == null) {
            return false;
        }
        ResourceResolver resolver = guideContainer.getResourceResolver();
        ValueMap guideContainerProps = (ValueMap)guideContainer.adaptTo(ValueMap.class);
        String xsdRef = (String)guideContainerProps.get("xsdRef", null);
        String dorTemplateRef = null;
        if (xsdRef == null || xsdRef.length() == 0) {
            return false;
        }
        dorTemplateRef = (String)guideContainerProps.get("dorTemplateRef", null);
        if (dorTemplateRef != null) {
            boolean isValid = true;
            try {
                isValid = resolver.getResource(dorTemplateRef) != null;
            }
            catch (SlingException ex) {
                isValid = false;
                logger.error("DOR Template present in XDP is either set to null or is relative" + ex.getMessage(), (Throwable)ex);
            }
            return isValid;
        }
        return false;
    }

    public static String getGuideRuntimeLocale(SlingHttpServletRequest slingRequest, Resource resource) {
        int index = 0;
        if (resource != null || slingRequest != null) {
            Locale authoringLocale;
            String locale = GuideELUtils.getLocale((SlingHttpServletRequest)slingRequest, (Resource)resource);
            index = Arrays.asList(GuideConstants.GUIDES_SUPPORTED_CLIENTLIBS).indexOf(locale);
            if (index == -1 && (authoringLocale = slingRequest.getLocale()) != null) {
                index = Arrays.asList(GuideConstants.GUIDES_SUPPORTED_CLIENTLIBS).indexOf(authoringLocale.toString());
            }
            if (index == -1) {
                index = 0;
            }
        }
        return GuideConstants.AEM_SUPPORTED_LOCALES[index];
    }

    public static Calendar getCurrentLMT(Resource containerResource, StaleAssetIndicatorService staleAssetIndicatorService) {
        Calendar calendar = Calendar.getInstance();
        if (staleAssetIndicatorService != null) {
            long currentLMT = staleAssetIndicatorService.getAssetTreeLMT(containerResource);
            calendar.setTimeInMillis(currentLMT);
        } else {
            logger.info("staleAssetIndicatorService not available : Guide Json cache miss");
            calendar.setTimeInMillis(Long.MAX_VALUE);
        }
        return calendar;
    }

    public static String getAcceptLang(SlingHttpServletRequest request) {
        if (request == null) {
            return "en";
        }
        String language = null;
        SlingBindings bindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
        String afLang = request.getParameter("afAcceptLang");
        if (afLang != null && !afLang.trim().equals("")) {
            language = GuideUtils.getAcceptLang(afLang, bindings);
        }
        if (language == null) {
            String acceptLang = request.getHeader("Accept-Language");
            if (acceptLang == null || "".equals(acceptLang.trim())) {
                return "en";
            }
            language = GuideUtils.getAcceptLang(acceptLang, bindings);
        }
        if (language != null) {
            return language;
        }
        return "en";
    }

    private static String getAcceptLang(String locale, SlingBindings bindings) {
        String acceptLang = locale;
        if (bindings != null) {
            GuideLocalizationService guideLocalizationService = (GuideLocalizationService)bindings.getSling().getService(GuideLocalizationService.class);
            String[] supportedLocales = guideLocalizationService.getSupportedLocales();
            String[] supportedLocalesSanitized = GuideUtils.sanitizeLocaleList(supportedLocales);
            String[] locales = org.apache.commons.lang3.StringUtils.split((String)acceptLang, (String)",");
            for (int i = 0; i < locales.length; ++i) {
                int index;
                String localeCode = org.apache.commons.lang3.StringUtils.substringBefore((String)locales[i], (String)";");
                String[] splitLocale = org.apache.commons.lang3.StringUtils.split((String)localeCode, (String)"-");
                localeCode = splitLocale[0].toLowerCase();
                if (splitLocale.length > 1) {
                    localeCode = localeCode + splitLocale[1].toUpperCase();
                }
                if ((index = Arrays.asList(supportedLocalesSanitized).indexOf(localeCode)) != -1) {
                    acceptLang = supportedLocales[index];
                    return acceptLang;
                }
                if (splitLocale.length <= 1 || (index = Arrays.asList(supportedLocalesSanitized).indexOf(splitLocale[0].toLowerCase())) == -1) continue;
                acceptLang = supportedLocales[index];
                return acceptLang;
            }
            return null;
        }
        return locale;
    }

    public static void visitToCollectProperties(JSONObject guideTypeJsonObject, String toCheck, String keyToPut, String valueToPut, JSONArray collection) {
        try {
            if (guideTypeJsonObject.has(toCheck)) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put((String)guideTypeJsonObject.get(keyToPut), (Object)((String)guideTypeJsonObject.get(valueToPut)));
                collection.put((Object)jsonObject);
            }
            if (guideTypeJsonObject.has("items")) {
                JSONObject items = (JSONObject)guideTypeJsonObject.get("items");
                Iterator childKeys = items.keys();
                while (childKeys.hasNext()) {
                    GuideUtils.visitToCollectProperties((JSONObject)items.get((String)childKeys.next()), toCheck, keyToPut, valueToPut, collection);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error in visting XML Schema", (Throwable)e);
        }
    }

    public static I18n getI18nForDesiredLocale(SlingHttpServletRequest request, Resource guideContainerResource, Locale desiredLocale) {
        ResourceBundle resourceBundle;
        String baseName = null;
        if (desiredLocale == null) {
            desiredLocale = request.getLocale();
        }
        if (guideContainerResource != null && request != null && (baseName = GuideELUtils.getGuideContainerPath((SlingHttpServletRequest)request, (Resource)guideContainerResource) + "/assets/dictionary") != null && (resourceBundle = request.getResourceBundle(baseName, desiredLocale)) != null) {
            return new I18n(resourceBundle);
        }
        return null;
    }

    public static int getLocaleIndexFromLocale(String locale) {
        int index = Arrays.asList(GuideConstants.GUIDES_SUPPORTED_CLIENTLIBS).indexOf(locale);
        if (index == -1) {
            index = 0;
        }
        return index;
    }

    public static String[] sanitizeLocaleList(String[] locales) {
        String[] sanitizedLocales = new String[locales.length];
        for (int i = 0; i < locales.length; ++i) {
            String localeCode = locales[i];
            String[] splitLocale = org.apache.commons.lang3.StringUtils.split((String)localeCode, (String)"-");
            localeCode = splitLocale[0].toLowerCase();
            if (splitLocale.length > 1) {
                localeCode = localeCode + splitLocale[1].toUpperCase();
            }
            sanitizedLocales[i] = localeCode;
        }
        return sanitizedLocales;
    }

    public static Session getUserSessionFromRequest(SlingHttpServletRequest slingHttpServletRequest) {
        return (Session)slingHttpServletRequest.getResourceResolver().adaptTo(Session.class);
    }

    public static SlingHttpServletResponse processInternalPostOnRestEndPoint(SlingHttpServletRequest request, SlingHttpServletResponse response, String postUrl) {
        CustomParameterRequest wrappedRequest = null;
        CustomResponse wrappedResponse = null;
        try {
            ParameterMap wrappedParameterMap = GuideUtils.prepareWrappedRequestWithDataXMLAndAttachments(request);
            wrappedRequest = new CustomParameterRequest(request, wrappedParameterMap, "POST");
            wrappedResponse = new CustomResponse(response);
            request.getRequestDispatcher(postUrl).forward((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
        }
        catch (Exception e) {
            logger.error("Some Problem While Posting to rest End Point", (Throwable)e);
        }
        return wrappedResponse;
    }

    public static void addToRequestMap(ParameterMap requestParameterMap, String key, RequestParameter[] requestParameter) {
        requestParameterMap.put((Object)key, (Object)requestParameter);
    }

    public static ParameterMap prepareWrappedRequestWithDataXMLAndAttachments(SlingHttpServletRequest request) {
        ParameterMap wrappedParameterMap = new ParameterMap();
        RequestParameterMap originalParams = request.getRequestParameterMap();
        ArrayList<FileAttachmentWrapper> fileAttachments = new ArrayList<FileAttachmentWrapper>();
        try {
            for (Map.Entry param : originalParams.entrySet()) {
                RequestParameter[] rpm = (RequestParameter[])param.getValue();
                if (rpm == null || rpm.length <= 0 || rpm[0].isFormField()) continue;
                FileAttachmentWrapper fileAttachment = new FileAttachmentWrapper(rpm[0].getFileName(), rpm[0].getContentType(), rpm[0].get());
                fileAttachments.add(fileAttachment);
            }
            if (fileAttachments.size() > 0) {
                RequestParameter[] attachments = new RequestParameter[fileAttachments.size()];
                int index = 0;
                for (FileAttachmentWrapper fileAttachment : fileAttachments) {
                    attachments[index] = new FileRequestParameter(fileAttachment.getFileName(), IOUtils.toByteArray((InputStream)fileAttachment.getInputStream()), fileAttachment.getContentType());
                }
                GuideUtils.addToRequestMap(wrappedParameterMap, "attachments", attachments);
                GuideUtils.addToRequestMap(wrappedParameterMap, "dataXml", originalParams.getValues("jcr:data"));
            }
        }
        catch (Exception e) {
            logger.error("Not Able to make internal post req parameter", (Throwable)e);
        }
        return wrappedParameterMap;
    }

    public static String getFieldLayout(Resource guideContainerResource, String propertyName, String defaultValue) {
        ValueMap properties = (ValueMap)guideContainerResource.adaptTo(ValueMap.class);
        return (String)properties.get(propertyName, (Object)defaultValue);
    }

    public static void putQueryParamsToRedirectRequest(String responseString, Map<String, String> redirectParameters) {
        try {
            String[] pairs = responseString.split("&");
            for (int i = 0; i < pairs.length; ++i) {
                String[] fields = pairs[i].split("=");
                if (fields.length != 2) continue;
                String name = URLDecoder.decode(fields[0].trim(), "UTF-8");
                String value = URLDecoder.decode(fields[1].trim(), "UTF-8");
                redirectParameters.put(name, value);
            }
        }
        catch (Exception e) {
            logger.error("Error while putting params to redirect Request", (Throwable)e);
        }
    }

    public static double parseSize(String size) {
        if (size.indexOf("in") >= 0 || size.indexOf("mm") >= 0 || size.indexOf("cm") >= 0 || size.indexOf("pt") >= 0 || size.indexOf("px") >= 0) {
            return Double.parseDouble(size.substring(0, size.length() - 2));
        }
        return 1.0;
    }

    public static double convertToPx(String size) {
        Double pxSize = Double.parseDouble(size.substring(0, size.length() - 2));
        if (size.indexOf("in") >= 0) {
            pxSize = GuideUtils.mm2px(pxSize * 25.4);
        } else if (size.indexOf("mm") >= 0) {
            pxSize = GuideUtils.mm2px(pxSize);
        } else if (size.indexOf("cm") >= 0) {
            pxSize = GuideUtils.mm2px(pxSize * 10.0);
        } else if (size.indexOf("pt") >= 0) {
            pxSize = pxSize * 2.0;
        }
        return pxSize;
    }

    public static double mm2px(double mmSize) {
        double mm2in = 0.03937007874015748;
        double pxSize = mmSize * mm2in * 144.0;
        return pxSize;
    }
}

