/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.icc.dbforms.util;

import com.adobe.icc.dbforms.exceptions.ICCException;
import com.adobe.icc.dbforms.obj.ContainerLayoutAssignment;
import com.adobe.icc.dbforms.obj.Field;
import com.adobe.icc.dbforms.obj.FieldAssignment;
import com.adobe.icc.dbforms.obj.Form;
import com.adobe.icc.dbforms.obj.FragmentLayout;
import com.adobe.icc.dbforms.obj.ModuleAssignment;
import com.adobe.icc.dbforms.obj.Table;
import com.adobe.icc.dbforms.obj.TableColumnDetails;
import com.adobe.icc.dbforms.obj.TableRow;
import com.adobe.icc.dbforms.obj.TargetArea;
import com.adobe.icc.dbforms.obj.TargetAreaAssignment;
import com.adobe.icc.dbforms.obj.Variable;
import com.adobe.icc.dbforms.obj.VariableAssignment;
import com.adobe.icc.dbforms.util.ModuleUtil;
import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.Int;
import com.adobe.xfa.ModelFactory;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.Obj;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.XFA;
import com.adobe.xfa.configuration.ConfigurationModelFactory;
import com.adobe.xfa.connectionset.ConnectionSetModelFactory;
import com.adobe.xfa.data.DataModelFactory;
import com.adobe.xfa.localeset.LocaleSetModelFactory;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.template.TemplateModelFactory;
import com.adobe.xfa.template.containers.Draw;
import com.adobe.xfa.template.containers.Subform;
import com.adobe.xfa.template.formatting.Occur;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutUtil
implements Serializable {
    private static final String INTERNAL_TARGET_IDENTIFIER = "_int";
    private static final String ADDITIONAL_ROW_NAME_PREFIX = "ExtRow";
    private static final String ADDITIONAL_COL_NAME_PREFIX = "Col";
    private static final long serialVersionUID = -1L;
    private static int taCount = 0;
    private static int fieldCount = 0;
    private static int tableCount = 0;
    private static int cellCountInTableRow = 0;
    private static final Logger logger = LoggerFactory.getLogger(LayoutUtil.class);

    public static synchronized void setTargetAreasAndFieldsForLayout(Form form) {
        TreeSet<TargetArea> targetAreas = new TreeSet<TargetArea>();
        TreeSet<Field> fields = new TreeSet<Field>();
        TreeSet<Table> tables = new TreeSet<Table>();
        if (form.getFilexdp() != null) {
            com.adobe.xfa.Document xdpDoc = LayoutUtil.loadXFADocument(form.getFilexdp());
            AppModel app = xdpDoc.getAppModel();
            TemplateModel model = TemplateModel.getTemplateModel((AppModel)app, (boolean)true);
            taCount = 0;
            fieldCount = 0;
            LayoutUtil.identifyTargetAreaAndFields(LayoutType.TEMPLATE, targetAreas, fields, tables, null, TableLayout.NONE, model.getNodes(), false);
        }
        form.setTargetAreas(targetAreas);
        form.setFields(fields);
        form.setTables(tables);
    }

    public static synchronized void setTargetAreasAndFieldsForFragmentLayout(FragmentLayout fragmentLayout, boolean retainOldConfig, boolean parsingOriginalLayout) {
        TreeSet<TargetArea> targetAreas = new TreeSet<TargetArea>();
        TreeSet<Field> fields = new TreeSet<Field>();
        TreeSet<Table> tables = new TreeSet<Table>();
        if (fragmentLayout.getFilexdp() != null) {
            byte[] xdpBytes = fragmentLayout.getConfiguredFilexdp();
            if (xdpBytes == null || parsingOriginalLayout) {
                xdpBytes = fragmentLayout.getFilexdp();
            }
            com.adobe.xfa.Document xdpDoc = LayoutUtil.loadXFADocument(xdpBytes);
            AppModel app = xdpDoc.getAppModel();
            TemplateModel model = TemplateModel.getTemplateModel((AppModel)app, (boolean)true);
            taCount = 0;
            fieldCount = 0;
            tableCount = 0;
            Set<Table> oldTables = fragmentLayout.getTables();
            LayoutUtil.identifyTargetAreaAndFields(LayoutType.FRAGMENT, targetAreas, fields, tables, null, TableLayout.NONE, model.getNodes(), false);
            if (retainOldConfig && oldTables != null && oldTables.size() > 0) {
                LayoutUtil.copyTableConfiguration(oldTables, tables);
            }
            if (tables.size() > 0) {
                fragmentLayout.setFlowedLayout(true);
            }
            for (Table table : tables) {
                com.adobe.xfa.Node tableNode = model.resolveNode(table.getTableSOMExpression());
                boolean parentFlowed = LayoutUtil.isParentFlowed((com.adobe.xfa.Node)tableNode.getXFAParent());
                if (!parentFlowed) {
                    fragmentLayout.setFlowedLayout(false);
                }
                if (parsingOriginalLayout) {
                    table.setCustomizable(true);
                    if (table.getOriginalColumnCount() == 1 && table.getOriginalBodyRowCount() == 1 && table.getBodyRows().get(0).getLastDrawPosition() == 0) {
                        table.setPlaceHolderTable(true);
                    } else {
                        table.setPlaceHolderTable(false);
                        if (table.getHeaderRow() != null && table.getHeaderRow().getFields().size() == 0 && table.getHeaderRow().getLastDrawPosition() < 0) {
                            table.setCustomizable(false);
                        }
                        if (table.getFooterRow() != null && table.getFooterRow().getFields().size() == 0 && table.getFooterRow().getLastDrawPosition() < 0) {
                            table.setCustomizable(false);
                        }
                        for (TableRow tableRow : table.getBodyRows()) {
                            if (LayoutUtil.getLastElementSOM(tableRow) != null) continue;
                            table.setCustomizable(false);
                        }
                    }
                }
                if (retainOldConfig) continue;
                table.setAdditionalTableColumns(new ArrayList<TableColumnDetails>());
                for (int i = 0; i < table.getOriginalColumnCount(); ++i) {
                    table.getAdditionalTableColumns().add(new TableColumnDetails());
                }
                if (table.getHeaderRow() != null) {
                    String headerSOM = table.getHeaderRow().getRowSOMExpression();
                    LayoutUtil.setExistingHeaderFooterText(model, table, headerSOM, true);
                }
                if (table.getFooterRow() == null) continue;
                String footerSOM = table.getFooterRow().getRowSOMExpression();
                LayoutUtil.setExistingHeaderFooterText(model, table, footerSOM, false);
            }
        }
        fragmentLayout.setTargetAreas(targetAreas);
        fragmentLayout.setFields(fields);
        fragmentLayout.setTables(tables);
    }

    private static void setExistingHeaderFooterText(TemplateModel model, Table table, String somExpr, boolean isHeader) {
        com.adobe.xfa.Node node = model.resolveNode(somExpr);
        NodeList nodes = node.getNodes();
        int colIndex = 0;
        for (int i = 0; i < nodes.length(); ++i) {
            com.adobe.xfa.Node childNode = (com.adobe.xfa.Node)nodes.item(i);
            if (XFA.SUBFORMTAG == childNode.getClassTag() || XFA.FIELDTAG == childNode.getClassTag()) {
                ++colIndex;
                continue;
            }
            if (XFA.DRAWTAG != childNode.getClassTag() || table.getAdditionalTableColumns().size() <= colIndex) continue;
            Draw drawNode = (Draw)childNode;
            String nodeText = drawNode.getRawValue();
            if (isHeader) {
                table.getAdditionalTableColumns().get(colIndex).setHeaderName(nodeText);
            } else {
                table.getAdditionalTableColumns().get(colIndex).setFooterName(nodeText);
            }
            ++colIndex;
        }
    }

    public static String getLayoutTAAndFields(byte[] layoutXDP) {
        StringBuilder mergedElementList = new StringBuilder();
        if (layoutXDP != null) {
            com.adobe.xfa.Document xdpDoc = LayoutUtil.loadXFADocument(layoutXDP);
            AppModel app = xdpDoc.getAppModel();
            TemplateModel model = TemplateModel.getTemplateModel((AppModel)app, (boolean)true);
            LayoutUtil.retriveChildTAAndFields(mergedElementList, model.getNodes(), false);
        }
        return mergedElementList.toString();
    }

    private static void retriveChildTAAndFields(StringBuilder mergedElementList, NodeList nodes, boolean processingPageSetNode) {
        for (int i = 0; i < nodes.length(); ++i) {
            com.adobe.xfa.Node node = (com.adobe.xfa.Node)nodes.item(i);
            if (XFA.PAGESETTAG == node.getClassTag()) {
                processingPageSetNode = true;
            }
            boolean taFieldFound = false;
            if (!processingPageSetNode && XFA.SUBFORMTAG == node.getClassTag() && !node.getName().endsWith(INTERNAL_TARGET_IDENTIFIER) && node.getName().equals("ModuleContainer")) {
                NodeList childNodes = node.getNodes();
                if (childNodes.length() == 2) {
                    for (int cnIdx = 0; cnIdx < childNodes.length(); ++cnIdx) {
                        NodeList grandChildNodes;
                        com.adobe.xfa.Node childNode = (com.adobe.xfa.Node)childNodes.item(cnIdx);
                        if (XFA.SUBFORMTAG != childNode.getClassTag() || !childNode.getName().equals("") || (grandChildNodes = childNode.getNodes()).length() != 3) continue;
                        for (int gcnIdx = 0; gcnIdx < grandChildNodes.length(); ++gcnIdx) {
                            com.adobe.xfa.Node grandChildNode = (com.adobe.xfa.Node)grandChildNodes.item(gcnIdx);
                            if (XFA.SUBFORMSETTAG != grandChildNode.getClassTag() || !grandChildNode.getName().equals("iccModuleObject")) continue;
                            taFieldFound = true;
                            mergedElementList.append("T:" + node.getSOMExpression() + "\n");
                        }
                    }
                }
            } else if (LayoutUtil.isQualifyingField(node) && LayoutUtil.isValidField(node) && !node.getName().endsWith(INTERNAL_TARGET_IDENTIFIER) && LayoutUtil.fieldHasBinding(node)) {
                taFieldFound = true;
                mergedElementList.append("F:" + node.getSOMExpression() + "\n");
            }
            if (!taFieldFound) {
                LayoutUtil.retriveChildTAAndFields(mergedElementList, node.getNodes(), processingPageSetNode);
            }
            if (XFA.PAGESETTAG != node.getClassTag()) continue;
            processingPageSetNode = false;
        }
    }

    private static boolean isParentFlowed(com.adobe.xfa.Node node) {
        EnumValue ev;
        if (XFA.SUBFORMTAG == node.getClassTag() && ((ev = (EnumValue)node.getProperty("layout", 0)) == null || ev.getAttr().getInt() != 0x1B0000 && ev.getAttr().getInt() != 1769474)) {
            return false;
        }
        Element parentNode = node.getXFAParent();
        if (parentNode == null) {
            return true;
        }
        return LayoutUtil.isParentFlowed((com.adobe.xfa.Node)parentNode);
    }

    private static void identifyTargetAreaAndFields(LayoutType layoutType, Set<TargetArea> targetAreas, Set<Field> fields, Set<Table> tables, Table table, TableLayout parentTableLayout, NodeList nodes, boolean processingPageSetNode) {
        for (int i = 0; i < nodes.length(); ++i) {
            com.adobe.xfa.Node node = (com.adobe.xfa.Node)nodes.item(i);
            TableLayout currentTableLayout = parentTableLayout;
            if (XFA.PAGESETTAG == node.getClassTag()) {
                processingPageSetNode = true;
            }
            if (layoutType != LayoutType.TEMPLATE && XFA.SUBFORMTAG == node.getClassTag()) {
                currentTableLayout = LayoutUtil.getTableLayout(node);
                if (currentTableLayout == TableLayout.NONE && parentTableLayout != TableLayout.NONE) {
                    currentTableLayout = parentTableLayout;
                } else if (currentTableLayout != TableLayout.NONE && parentTableLayout != TableLayout.ROW) {
                    String rowName;
                    if (currentTableLayout == TableLayout.TABLE) {
                        table = new Table();
                        table.setPosition(tableCount++);
                        table.setContainerFieldPosition(fieldCount);
                        table.setContainerTargetAreaPosition(taCount);
                        String tableName = node.getName();
                        if (tableName == null || tableName.trim().length() == 0) {
                            tableName = "Table";
                        }
                        table.setTableName(tableName);
                        table.setTableSOMExpression(node.getSOMExpression());
                        tables.add(table);
                    } else if (currentTableLayout == TableLayout.ROW) {
                        if (table.isDynamicTable()) {
                            throw new ICCException("ALC-ACM-002-354", null, 1);
                        }
                        cellCountInTableRow = 0;
                        List<TableRow> bodyRows = table.getBodyRows();
                        TableRow bodyRow = new TableRow();
                        String rowName2 = node.getName();
                        if (rowName2 == null || rowName2.trim().length() == 0) {
                            rowName2 = "BodyRow";
                        }
                        bodyRow.setName(rowName2);
                        bodyRow.setRowSOMExpression(node.getSOMExpression());
                        bodyRows.add(bodyRow);
                        table.setOriginalBodyRowCount(bodyRows.size());
                        table.setConfiguredBodyRowCount(bodyRows.size());
                        boolean isDynamicTable = LayoutUtil.isRepeatableRow(node);
                        if (isDynamicTable && table.getBodyRows().size() > 1) {
                            throw new ICCException();
                        }
                        table.setDynamicTable(isDynamicTable);
                    } else if (currentTableLayout == TableLayout.HEADER) {
                        cellCountInTableRow = 0;
                        TableRow headerRow = new TableRow();
                        rowName = node.getName();
                        if (rowName == null || rowName.trim().length() == 0) {
                            rowName = "HeaderRow";
                        }
                        headerRow.setName(rowName);
                        headerRow.setRowSOMExpression(node.getSOMExpression());
                        table.setHeaderRow(headerRow);
                    } else if (currentTableLayout == TableLayout.FOOTER) {
                        cellCountInTableRow = 0;
                        TableRow footerRow = new TableRow();
                        rowName = node.getName();
                        if (rowName == null || rowName.trim().length() == 0) {
                            rowName = "FooterRow";
                        }
                        footerRow.setName(rowName);
                        footerRow.setRowSOMExpression(node.getSOMExpression());
                        table.setFooterRow(footerRow);
                    }
                }
            }
            if (!processingPageSetNode && XFA.SUBFORMTAG == node.getClassTag() && !node.getName().endsWith(INTERNAL_TARGET_IDENTIFIER) && LayoutUtil.isEmptySubform(node) && LayoutUtil.subformHasNoBinding(node)) {
                TargetArea ta = new TargetArea();
                ta.setPath(node.getSOMExpression());
                ta.setDisplayName(node.getName());
                if (layoutType == LayoutType.TEMPLATE || !LayoutUtil.populateTableInfo(table, currentTableLayout, ta, null)) {
                    ta.setPosition(taCount++);
                    targetAreas.add(ta);
                }
            } else if (LayoutUtil.isQualifyingField(node) && LayoutUtil.isValidField(node) && !node.getName().endsWith(INTERNAL_TARGET_IDENTIFIER) && LayoutUtil.fieldHasBinding(node)) {
                Field field = new Field();
                field.setPath(node.getSOMExpression());
                field.setDisplayName(node.getName());
                field.setType(LayoutUtil.getFieldType(node));
                field.setCaption(LayoutUtil.getFieldCaption(node));
                field.setXfaFieldType(LayoutUtil.getXfaFieldType(node));
                LayoutUtil.setFieldValuesAndLabels(node, field);
                if (layoutType == LayoutType.TEMPLATE || !LayoutUtil.populateTableInfo(table, currentTableLayout, null, field)) {
                    field.setPosition(fieldCount++);
                    fields.add(field);
                }
            } else if (currentTableLayout == TableLayout.HEADER && node.isSameClass(XFA.DRAWTAG)) {
                table.getHeaderRow().setLastDrawPosition(cellCountInTableRow++);
                table.getHeaderRow().setLastDrawSOMExpression(node.getSOMExpression());
            } else if (currentTableLayout == TableLayout.FOOTER && node.isSameClass(XFA.DRAWTAG)) {
                table.getFooterRow().setLastDrawPosition(cellCountInTableRow++);
                table.getFooterRow().setLastDrawSOMExpression(node.getSOMExpression());
            } else if (currentTableLayout == TableLayout.ROW && node.isSameClass(XFA.DRAWTAG)) {
                TableRow currentRow = table.getBodyRows().get(table.getBodyRows().size() - 1);
                currentRow.setLastDrawPosition(cellCountInTableRow++);
                currentRow.setLastDrawSOMExpression(node.getSOMExpression());
                LayoutUtil.setTableColumnCount(table);
            } else {
                LayoutUtil.identifyTargetAreaAndFields(layoutType, targetAreas, fields, tables, table, currentTableLayout, node.getNodes(), processingPageSetNode);
            }
            if (XFA.PAGESETTAG != node.getClassTag()) continue;
            processingPageSetNode = false;
        }
    }

    private static String getXfaFieldType(com.adobe.xfa.Node node) {
        if (node.isSameClass(XFA.EXCLGROUPTAG)) {
            return node.getClassName();
        }
        if (node.isSameClass(XFA.FIELDTAG)) {
            Element uiTag = LayoutUtil.getXFASubElement(node, XFA.UITAG, true);
            com.adobe.xfa.Node uiChildTag = uiTag.getFirstXFAChild();
            if (uiChildTag != null) {
                return uiChildTag.getClassName();
            }
            return null;
        }
        return null;
    }

    private static void setFieldValuesAndLabels(com.adobe.xfa.Node node, Field field) {
        try {
            if (node.isSameClass(XFA.EXCLGROUPTAG)) {
                NodeList nodeList = node.getNodes();
                if (nodeList != null) {
                    ArrayList<String> values = new ArrayList<String>();
                    ArrayList<String> labels = new ArrayList<String>();
                    for (int i = 0; i < nodeList.length(); ++i) {
                        com.adobe.xfa.Node childField = (com.adobe.xfa.Node)nodeList.item(i);
                        if (!childField.isSameClass(XFA.FIELDTAG)) continue;
                        labels.add(LayoutUtil.getFieldCaption(childField));
                        Element itemsNode = LayoutUtil.getXFASubElement(childField, XFA.ITEMSTAG, true);
                        List<String> itemValues = LayoutUtil.getItemValues((com.adobe.xfa.Node)itemsNode);
                        if (itemValues == null || itemValues.size() <= 0) continue;
                        values.add(itemValues.get(0));
                    }
                    field.setValues(values);
                    field.setLabels(labels);
                }
            } else {
                Element uiTag = LayoutUtil.getXFASubElement(node, XFA.UITAG, true);
                com.adobe.xfa.Node uiChildTag = uiTag.getFirstXFAChild();
                NodeList nodeList = node.getNodes();
                if (nodeList != null && nodeList.length() > 0) {
                    for (int i = 0; i < nodeList.length(); ++i) {
                        com.adobe.xfa.Node childNode = (com.adobe.xfa.Node)nodeList.item(i);
                        if (!childNode.isSameClass(XFA.ITEMSTAG)) continue;
                        List<String> itemValues = LayoutUtil.getItemValues(childNode);
                        if (uiChildTag.isSameClass(XFA.CHOICELISTTAG)) {
                            if (childNode.isPropertySpecified(XFA.SAVETAG, true, 1)) {
                                if (itemValues == null) continue;
                                field.setValues(itemValues);
                                continue;
                            }
                            field.setLabels(itemValues);
                            continue;
                        }
                        field.setValues(itemValues);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception in setFieldValuesAndLabels: " + field.getDisplayName(), (Throwable)e);
        }
    }

    private static List<String> getItemValues(com.adobe.xfa.Node itemNode) {
        ArrayList<String> values = new ArrayList<String>();
        NodeList childNodes = itemNode.getNodes();
        if (childNodes != null && childNodes.length() > 0) {
            for (int i = 0; i < childNodes.length(); ++i) {
                com.adobe.xfa.Node childNode = (com.adobe.xfa.Node)childNodes.item(i);
                if (childNode == null || childNode.isSameClass(XFA.ATTRIBUTESTAG)) continue;
                com.adobe.xfa.Node textNode = childNode.getFirstXFAChild();
                values.add(textNode.getData());
            }
        }
        return values;
    }

    private static String getFieldCaption(com.adobe.xfa.Node node) {
        com.adobe.xfa.Node value;
        Element captionNode = LayoutUtil.getXFASubElement(node, XFA.CAPTIONTAG, true);
        Element valueNode = LayoutUtil.getXFASubElement((com.adobe.xfa.Node)captionNode, XFA.VALUETAG, true);
        com.adobe.xfa.Node valueChildNode = valueNode.getFirstXFAChild();
        if (valueChildNode != null && (value = valueChildNode.getFirstXFAChild()) != null) {
            return value.getData();
        }
        return null;
    }

    private static void setTableColumnCount(Table table) {
        if (table.getOriginalColumnCount() < cellCountInTableRow) {
            table.setOriginalColumnCount(cellCountInTableRow);
            table.setConfiguredColumnCount(cellCountInTableRow);
        }
    }

    public static String getContainerWidth(Element containerNode) {
        Element lastContainerParent = containerNode;
        Attribute parentWidth = null;
        for (Element containerParent = containerNode.getXFAParent(); (parentWidth == null || "".equals(parentWidth.getAttrValue())) && containerParent != null; containerParent = containerParent.getXFAParent()) {
            TableLayout tableLayout;
            parentWidth = containerParent.getAttributeByName("w", true);
            if ((parentWidth == null || "".equals(parentWidth.getAttrValue())) && (tableLayout = LayoutUtil.getTableLayout((com.adobe.xfa.Node)containerParent)) == TableLayout.ROW) {
                String columnWidthValue;
                String[] columnWidthArray;
                Attribute columnWidth;
                int position = 0;
                Element rowChild = lastContainerParent;
                while (rowChild != null && rowChild.getPreviousXMLSibling() != null) {
                    if ((rowChild = rowChild.getPreviousXMLSibling()).getClassTag() != XFA.SUBFORMTAG && rowChild.getClassTag() != XFA.FIELDTAG) continue;
                    ++position;
                }
                Element tableElement = containerParent.getXFAParent();
                tableLayout = LayoutUtil.getTableLayout((com.adobe.xfa.Node)tableElement);
                if (tableLayout == TableLayout.TABLE && (columnWidth = tableElement.getAttributeByName("columnWidths", true)) != null && columnWidth.getAttrValue() != null && columnWidth.getAttrValue().trim().length() > 0 && (columnWidthArray = (columnWidthValue = columnWidth.getAttrValue()).split(" ")).length >= position + 1) {
                    String containerWidth = columnWidthArray[position];
                    return containerWidth;
                }
            }
            lastContainerParent = containerParent;
        }
        if (parentWidth != null) {
            return parentWidth.getAttrValue();
        }
        return null;
    }

    private static TableLayout getTableLayout(com.adobe.xfa.Node node) {
        EnumValue ev = (EnumValue)node.getProperty("layout", 0);
        if (ev == null) {
            return TableLayout.NONE;
        }
        if (ev.getAttr().getInt() == 1769476) {
            return TableLayout.TABLE;
        }
        if (ev.getAttr().getInt() == 1769477) {
            NodeList nodes = node.getNodes();
            for (int i = 0; i < nodes.length(); ++i) {
                com.adobe.xfa.Node childNode = (com.adobe.xfa.Node)nodes.item(i);
                if (childNode.getClassTag() != XFA.ASSISTTAG) continue;
                StringAttr role = (StringAttr)childNode.getProperty("role", 0);
                if (role.getAttrValue().equals("TH")) {
                    return TableLayout.HEADER;
                }
                if (role.getAttrValue().equals("TR")) {
                    return TableLayout.ROW;
                }
                if (role.getAttrValue().equals("TF")) {
                    return TableLayout.FOOTER;
                }
                return TableLayout.NONE;
            }
            return TableLayout.NONE;
        }
        return TableLayout.NONE;
    }

    private static boolean isRepeatableRow(com.adobe.xfa.Node node) {
        NodeList nodes = node.getNodes();
        if (nodes == null) {
            return false;
        }
        for (int i = 0; i < nodes.length(); ++i) {
            com.adobe.xfa.Node childNode = (com.adobe.xfa.Node)nodes.item(i);
            if (childNode.getClassTag() != XFA.OCCURTAG) continue;
            Int maxAttr = (Int)childNode.getProperty("max", 0);
            if (maxAttr == null) {
                return false;
            }
            int maxInt = maxAttr.getValue();
            return maxInt == -1 || maxInt > 1;
        }
        return false;
    }

    private static boolean populateTableInfo(Table table, TableLayout tableLayout, TargetArea targetArea, Field field) {
        if (table == null || tableLayout == TableLayout.NONE || tableLayout == TableLayout.TABLE) {
            return false;
        }
        Set<Field> fields = null;
        Set<TargetArea> targetAreas = null;
        if (tableLayout == TableLayout.HEADER) {
            fields = table.getHeaderRow().getFields();
            targetAreas = table.getHeaderRow().getTargetAreas();
        } else if (tableLayout == TableLayout.ROW) {
            if (table.isDynamicTable() && targetArea != null) {
                throw new ICCException("ALC-ACM-002-357", null, 1);
            }
            int rowCount = table.getBodyRows().size();
            TableRow currentTableRow = table.getBodyRows().get(rowCount - 1);
            fields = currentTableRow.getFields();
            targetAreas = currentTableRow.getTargetAreas();
        } else if (tableLayout == TableLayout.FOOTER) {
            fields = table.getFooterRow().getFields();
            targetAreas = table.getFooterRow().getTargetAreas();
        }
        if (targetArea != null) {
            targetArea.setPosition(cellCountInTableRow++);
            targetAreas.add(targetArea);
        } else if (field != null) {
            field.setPosition(cellCountInTableRow++);
            fields.add(field);
        }
        LayoutUtil.setTableColumnCount(table);
        return true;
    }

    private static boolean fieldHasBinding(com.adobe.xfa.Node node) {
        Element bindElement = LayoutUtil.getXFASubElement(node, XFA.BINDTAG, false);
        return bindElement == null || bindElement != null && ((EnumValue)bindElement.getAttribute(XFA.MATCHTAG)).getInt() != 0x1F0000;
    }

    private static NodeList getChildFields(com.adobe.xfa.Node node) {
        NodeList childNodes = node.getNodes();
        int len = childNodes.length();
        for (int i = len - 1; i >= 0; --i) {
            com.adobe.xfa.Node childNode = (com.adobe.xfa.Node)childNodes.item(i);
            if (childNode.isSameClass(XFA.FIELDTAG)) continue;
            childNodes.remove((Obj)childNode);
        }
        return childNodes;
    }

    private static boolean isQualifyingField(com.adobe.xfa.Node node) {
        Element xfaParent;
        if (node.isSameClass(XFA.FIELDTAG) && ((xfaParent = node.getXFAParent()) == null || !xfaParent.isSameClass(XFA.EXCLGROUPTAG))) {
            return true;
        }
        if (node.isSameClass(XFA.EXCLGROUPTAG)) {
            return LayoutUtil.getChildFields(node).length() > 0;
        }
        return false;
    }

    private static boolean isValidField(com.adobe.xfa.Node node) {
        if (node.isSameClass(XFA.EXCLGROUPTAG)) {
            NodeList childFields = LayoutUtil.getChildFields(node);
            Field.FieldType exgrpType = null;
            for (int i = 0; i < childFields.length(); ++i) {
                com.adobe.xfa.Node childField = (com.adobe.xfa.Node)childFields.item(i);
                if (!LayoutUtil.isValidField(childField)) {
                    return false;
                }
                if (exgrpType == null) {
                    exgrpType = LayoutUtil.getFieldType(childField);
                    continue;
                }
                if (LayoutUtil.getFieldType(childField) == exgrpType) continue;
                return false;
            }
            return true;
        }
        Element uiNode = LayoutUtil.getXFASubElement(node, XFA.UITAG, true);
        Element uiChildNode = (Element)uiNode.getOneOfChild(true, true);
        if (uiChildNode.isSameClass(XFA.BUTTONTAG) || uiChildNode.isSameClass(XFA.SIGNATURETAG) || uiChildNode.isSameClass(XFA.DEFAULTUITAG)) {
            return false;
        }
        Element valueNode = LayoutUtil.getXFASubElement(node, XFA.VALUETAG, true);
        Element valueChildNode = (Element)valueNode.getOneOfChild(true, true);
        return !(uiChildNode.isSameClass(XFA.DATETIMEEDITTAG) && !valueChildNode.isSameClass(XFA.DATETAG) && !valueChildNode.isSameClass(XFA.TIMETAG) && !valueChildNode.isSameClass(XFA.DATETIMETAG) || uiChildNode.isSameClass(XFA.NUMERICEDITTAG) && !valueChildNode.isSameClass(XFA.INTEGERTAG) && !valueChildNode.isSameClass(XFA.DECIMALTAG) && !valueChildNode.isSameClass(XFA.FLOATTAG) || valueChildNode.isSameClass(XFA.IMAGETAG) && !uiChildNode.isSameClass(XFA.IMAGEEDITTAG) && !uiChildNode.isSameClass(XFA.EXOBJECTTAG) || valueChildNode.isSameClass("exData") && !uiChildNode.isSameClass(XFA.TEXTEDITTAG) || valueChildNode.isSameClass(XFA.ARCTAG) || valueChildNode.isSameClass(XFA.LINETAG)) && !valueChildNode.isSameClass(XFA.RECTANGLETAG);
    }

    private static boolean isEmptySubform(com.adobe.xfa.Node node) {
        return LayoutUtil.getXFASubElement(node, XFA.AREATAG, false) == null && LayoutUtil.getXFASubElement(node, XFA.DRAWTAG, false) == null && LayoutUtil.getXFASubElement(node, XFA.EXCLGROUPTAG, false) == null && LayoutUtil.getXFASubElement(node, XFA.EXOBJECTTAG, false) == null && LayoutUtil.getXFASubElement(node, XFA.FIELDTAG, false) == null && LayoutUtil.getXFASubElement(node, XFA.SUBFORMTAG, false) == null && LayoutUtil.getXFASubElement(node, XFA.SUBFORMSETTAG, false) == null;
    }

    private static boolean subformHasNoBinding(com.adobe.xfa.Node node) {
        Element bindElement = LayoutUtil.getXFASubElement(node, XFA.BINDTAG, false);
        return bindElement != null && ((EnumValue)bindElement.getAttribute(XFA.MATCHTAG)).getInt() == 0x1F0000;
    }

    private static Field.FieldType getFieldType(com.adobe.xfa.Node node) {
        Field.FieldType type = null;
        if (node.isSameClass(XFA.EXCLGROUPTAG)) {
            NodeList childFields = LayoutUtil.getChildFields(node);
            com.adobe.xfa.Node childField = (com.adobe.xfa.Node)childFields.item(0);
            return LayoutUtil.getFieldType(childField);
        }
        Element valueNode = LayoutUtil.getXFASubElement(node, XFA.VALUETAG, true);
        Element contentNode = (Element)valueNode.getOneOfChild(true, true);
        if (contentNode.isSameClass(XFA.DATETAG)) {
            type = Field.FieldType.DATE;
        } else if (contentNode.isSameClass(XFA.TIMETAG)) {
            type = Field.FieldType.TIME;
        } else if (contentNode.isSameClass(XFA.DATETIMETAG)) {
            type = Field.FieldType.DATETIME;
        } else if (contentNode.isSameClass(XFA.INTEGERTAG)) {
            Element uiNode = LayoutUtil.getXFASubElement(node, XFA.UITAG, true);
            Element uiChild = (Element)uiNode.getOneOfChild(true, true);
            type = uiChild != null && uiChild.isSameClass(XFA.CHECKBUTTONTAG) ? (node.getXFAParent().isSameClass(XFA.EXCLGROUPTAG) ? Field.FieldType.RADIOBUTTON : Field.FieldType.CHECKBOX) : Field.FieldType.INTEGER;
        } else if (contentNode.isSameClass(XFA.FLOATTAG) || contentNode.isSameClass(XFA.DECIMALTAG)) {
            type = Field.FieldType.FLOAT;
        } else if (contentNode.isSameClass(XFA.EXDATATAG)) {
            type = Field.FieldType.RICHTEXT;
        } else if (contentNode.isSameClass(XFA.TEXTTAG)) {
            type = Field.FieldType.PLAINTEXT;
        } else if (contentNode.isSameClass(XFA.IMAGETAG)) {
            type = Field.FieldType.IMAGE;
        }
        if (type == null) {
            type = Field.FieldType.PLAINTEXT;
        }
        return type;
    }

    private static com.adobe.xfa.Document loadXFADocument(byte[] xdp) {
        AppModel appModel = new AppModel(null);
        com.adobe.xfa.Document document = new com.adobe.xfa.Document(appModel);
        appModel.addFactory((ModelFactory)new TemplateModelFactory());
        appModel.addFactory((ModelFactory)new DataModelFactory());
        appModel.addFactory((ModelFactory)new ConfigurationModelFactory());
        appModel.addFactory((ModelFactory)new LocaleSetModelFactory());
        appModel.addFactory((ModelFactory)new ConnectionSetModelFactory());
        try {
            document.load((InputStream)new ByteArrayInputStream(xdp), null, false);
        }
        catch (Exception e) {
            throw new ICCException("ALC-ACM-002-302", 1, e);
        }
        if (TemplateModel.getTemplateModel((AppModel)appModel, (boolean)false) == null) {
            throw new ICCException("ALC-ACM-002-302", 1);
        }
        return document;
    }

    private static Element getXFASubElement(com.adobe.xfa.Node node, int classTag, boolean createDefault) {
        Element el = ((Element)node).getElement(classTag, true, 0, createDefault, false);
        return el;
    }

    public static boolean customizeFragmentLayout(FragmentLayout fragmentLayout) throws UnsupportedEncodingException {
        if (fragmentLayout.isCustomizedLayout()) {
            if (fragmentLayout.getTables() == null || fragmentLayout.getTables().size() == 0) {
                throw new ICCException("This fragment layout is not parsed before customization.");
            }
            com.adobe.xfa.Document fragmentDoc = LayoutUtil.loadXFADocument(fragmentLayout.getFilexdp());
            AppModel fragmentAppModel = fragmentDoc.getAppModel();
            TemplateModel fragmentTemplateModel = TemplateModel.getTemplateModel((AppModel)fragmentAppModel, (boolean)true);
            LayoutUtil.extendTableXFAObj(fragmentTemplateModel, fragmentLayout.getTables());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            fragmentAppModel.saveXML((OutputStream)bos, null);
            fragmentLayout.setConfiguredFilexdp(bos.toByteArray());
            LayoutUtil.setTargetAreasAndFieldsForFragmentLayout(fragmentLayout, true, false);
            return true;
        }
        return false;
    }

    private static void copyTableConfiguration(Set<Table> oldTables, Set<Table> newTables) {
        Iterator<Table> newTableIterator = newTables.iterator();
        for (Table oldTable : oldTables) {
            List<TableColumnDetails> tableColumnDetails = oldTable.getAdditionalTableColumns();
            if (!newTableIterator.hasNext()) continue;
            Table newTable = newTableIterator.next();
            newTable.setAdditionalTableColumns(tableColumnDetails);
            newTable.setDynamicTable(oldTable.isDynamicTable());
            newTable.setConfiguredBodyRowCount(oldTable.getConfiguredBodyRowCount());
            newTable.setConfiguredColumnCount(oldTable.getConfiguredColumnCount());
            newTable.setOriginalBodyRowCount(oldTable.getOriginalBodyRowCount());
            newTable.setOriginalColumnCount(oldTable.getOriginalColumnCount());
            newTable.setShowFooterRow(oldTable.isShowFooterRow());
            newTable.setShowHeaderRow(oldTable.isShowHeaderRow());
            newTable.setPlaceHolderTable(oldTable.isPlaceHolderTable());
            newTable.setCustomizable(oldTable.isCustomizable());
        }
    }

    private static void extendTableXFAObj(TemplateModel fragmentTemplateModel, Set<Table> tables) throws UnsupportedEncodingException {
        for (Table table : tables) {
            if (!table.isCustomizable()) continue;
            if (table.getOriginalBodyRowCount() > table.getConfiguredBodyRowCount() || table.getOriginalColumnCount() > table.getConfiguredColumnCount()) {
                throw new ICCException("ALC-ACM-002-352", null, 1);
            }
            if (table.getOriginalBodyRowCount() == 0) continue;
            if (table.isPlaceHolderTable()) {
                LayoutUtil.createTableXFA(fragmentTemplateModel, table);
                continue;
            }
            if (table.getConfiguredColumnCount() > table.getAdditionalTableColumns().size()) {
                throw new ICCException("ALC-ACM-002-351", null, 1);
            }
            TableRow tableRow = null;
            String lastColumnSOM = null;
            com.adobe.xfa.Node lastColumn = null;
            Element parentNode = null;
            for (int i = 0; i < table.getOriginalBodyRowCount(); ++i) {
                tableRow = table.getBodyRows().get(i);
                String rowName = tableRow.getName();
                lastColumnSOM = LayoutUtil.getLastElementSOM(tableRow);
                lastColumn = fragmentTemplateModel.resolveNode(lastColumnSOM);
                parentNode = lastColumn.getXFAParent();
                for (int j = table.getOriginalColumnCount(); j < table.getConfiguredColumnCount(); ++j) {
                    Element newColumn = (Element)lastColumn.clone(parentNode);
                    String newColumnName = table.getTableName() + "_" + rowName + "_" + ADDITIONAL_COL_NAME_PREFIX + j;
                    newColumn.setAttribute("", "name", "name", newColumnName);
                    parentNode.appendChild((com.adobe.xfa.Node)newColumn);
                }
            }
            tableRow = table.getBodyRows().get(table.getOriginalBodyRowCount() - 1);
            String lastRowSOM = tableRow.getRowSOMExpression();
            com.adobe.xfa.Node lastTableRow = fragmentTemplateModel.resolveNode(lastRowSOM);
            parentNode = lastTableRow.getXFAParent();
            for (int i = table.getOriginalBodyRowCount(); i < table.getConfiguredBodyRowCount(); ++i) {
                Element newRow = (Element)lastTableRow.clone(parentNode);
                NodeList rowElements = newRow.getNodes();
                int columnCount = 0;
                for (int j = 0; j < rowElements.length(); ++j) {
                    com.adobe.xfa.Node node = (com.adobe.xfa.Node)rowElements.item(j);
                    if (!(node instanceof Element) || XFA.SUBFORMTAG != node.getClassTag() && XFA.FIELDTAG != node.getClassTag()) continue;
                    String newColumnName = table.getTableName() + "_" + ADDITIONAL_ROW_NAME_PREFIX + i + "_" + ADDITIONAL_COL_NAME_PREFIX + columnCount++;
                    ((Element)node).setAttribute("", "name", "name", newColumnName);
                }
                String newRowName = ADDITIONAL_ROW_NAME_PREFIX + i;
                newRow.setAttribute("", "name", "name", newRowName);
                parentNode.appendChild((com.adobe.xfa.Node)newRow);
            }
            if (!table.isShowHeaderRow()) {
                if (table.getHeaderRow() != null) {
                    com.adobe.xfa.Node headerNode = fragmentTemplateModel.resolveNode(table.getHeaderRow().getRowSOMExpression());
                    headerNode.remove();
                }
            } else {
                LayoutUtil.extendHeaderFooter(table, table.getHeaderRow(), fragmentTemplateModel, true);
            }
            if (!table.isShowFooterRow()) {
                if (table.getFooterRow() != null) {
                    com.adobe.xfa.Node footerNode = fragmentTemplateModel.resolveNode(table.getFooterRow().getRowSOMExpression());
                    footerNode.remove();
                }
            } else {
                LayoutUtil.extendHeaderFooter(table, table.getFooterRow(), fragmentTemplateModel, false);
            }
            if (!table.isShowFooterRow() || table.getOriginalBodyRowCount() >= table.getConfiguredBodyRowCount() || table.getFooterRow() == null) continue;
            String footerSOM = table.getFooterRow().getRowSOMExpression();
            com.adobe.xfa.Node footerNode = fragmentTemplateModel.resolveNode(footerSOM);
            parentNode = footerNode.getXFAParent();
            footerNode.remove();
            parentNode.appendChild(footerNode);
        }
    }

    private static void extendHeaderFooter(Table table, TableRow tableRow, TemplateModel fragmentTemplateModel, boolean isHeader) {
        if (tableRow == null) {
            return;
        }
        Field lastField = null;
        if (tableRow.getFields().size() > 0) {
            lastField = (Field)tableRow.getFields().toArray()[tableRow.getFields().size() - 1];
        }
        String lastColumnSOM = null;
        lastColumnSOM = lastField != null && lastField.getPosition() > tableRow.getLastDrawPosition() ? lastField.getPath() : tableRow.getLastDrawSOMExpression();
        if (lastColumnSOM == null || lastColumnSOM.trim().equals("")) {
            return;
        }
        com.adobe.xfa.Node lastColumn = fragmentTemplateModel.resolveNode(lastColumnSOM);
        Element parentNode = lastColumn.getXFAParent();
        for (int i = table.getOriginalColumnCount(); i < table.getConfiguredColumnCount(); ++i) {
            Element newColumn = (Element)lastColumn.clone(parentNode);
            String newColumnName = null;
            newColumnName = isHeader ? table.getTableName() + "_" + table.getHeaderRow().getName() + "_" + ADDITIONAL_COL_NAME_PREFIX + i : table.getTableName() + "_" + table.getFooterRow().getName() + "_" + ADDITIONAL_COL_NAME_PREFIX + i;
            newColumn.setAttribute("", "name", "name", newColumnName);
            if (newColumn.isSameClass(XFA.DRAWTAG)) {
                Draw drawNode = (Draw)newColumn;
                String nodeText = null;
                TableColumnDetails additionalColumn = table.getAdditionalTableColumns().get(i);
                nodeText = isHeader ? additionalColumn.getHeaderName() : additionalColumn.getFooterName();
                if (nodeText == null) {
                    nodeText = "";
                }
                drawNode.setRawValue(nodeText);
            }
            parentNode.appendChild((com.adobe.xfa.Node)newColumn);
        }
    }

    private static String getLastElementSOM(TableRow tableRow) {
        TargetArea lastTA;
        String lastColumnSOM = null;
        int lastColumnPosition = -1;
        if (tableRow.getFields().size() > 0) {
            Field lastField = (Field)tableRow.getFields().toArray()[tableRow.getFields().size() - 1];
            lastColumnPosition = lastField.getPosition();
            lastColumnSOM = lastField.getPath();
        }
        if (tableRow.getTargetAreas().size() > 0 && (lastTA = (TargetArea)tableRow.getTargetAreas().toArray()[tableRow.getTargetAreas().size() - 1]).getPosition() > lastColumnPosition) {
            lastColumnSOM = lastTA.getPath();
        }
        return lastColumnSOM;
    }

    private static boolean createTableXFA(TemplateModel fragmentTemplateModel, Table table) throws UnsupportedEncodingException {
        if (table.getConfiguredColumnCount() != table.getAdditionalTableColumns().size()) {
            throw new ICCException("ALC-ACM-002-353", null, 1);
        }
        if (table.isDynamicTable() && table.getConfiguredBodyRowCount() > 1) {
            throw new ICCException("ALC-ACM-002-354", null, 1);
        }
        Document tableObjTemplate = LayoutUtil.loadDocumentFromResource("com/adobe/icc/table.xml");
        org.dom4j.Element targetAreaNodeTemplate = (org.dom4j.Element)LayoutUtil.getNode("//subform[@name='TargetArea']", tableObjTemplate);
        org.dom4j.Element fieldNodeTemplate = (org.dom4j.Element)LayoutUtil.getNode("//field[@name='Field']", tableObjTemplate);
        List<TableColumnDetails> tableColumns = table.getAdditionalTableColumns();
        if (table.getHeaderRow() != null) {
            if (table.isShowHeaderRow()) {
                LayoutUtil.createHeaderFooter(fragmentTemplateModel, tableColumns, table.getHeaderRow(), true);
            } else {
                com.adobe.xfa.Node headerNode = fragmentTemplateModel.resolveNode(table.getHeaderRow().getRowSOMExpression());
                headerNode.remove();
            }
        }
        if (table.getFooterRow() != null) {
            if (table.isShowFooterRow()) {
                LayoutUtil.createHeaderFooter(fragmentTemplateModel, tableColumns, table.getFooterRow(), false);
            } else {
                com.adobe.xfa.Node footerNode = fragmentTemplateModel.resolveNode(table.getFooterRow().getRowSOMExpression());
                footerNode.remove();
            }
        }
        int j = 0;
        if (table.getBodyRows() != null && table.getBodyRows().size() > 0) {
            TableRow bodyRow = table.getBodyRows().get(0);
            Element bodyRowNode = (Element)fragmentTemplateModel.resolveNode(bodyRow.getRowSOMExpression());
            String bodyRowHeight = "";
            if (bodyRow.getLastDrawSOMExpression() == null) {
                throw new ICCException("ALC-ACM-002-355", null, 1);
            }
            Element bodyDrawNode = (Element)fragmentTemplateModel.resolveNode(bodyRow.getLastDrawSOMExpression());
            bodyDrawNode.remove();
            bodyRowHeight = bodyDrawNode.getAttributeByName("h", false).getAttrValue();
            if (table.isDynamicTable()) {
                Occur occur = (Occur)fragmentTemplateModel.createElement("occur");
                occur.setAttribute("", "max", "max", "-1");
                bodyRowNode.appendChild((com.adobe.xfa.Node)occur);
            }
            String rowName = "ExtRow0";
            bodyRowNode.setAttribute("", "name", "name", rowName);
            for (TableColumnDetails tableColumn : tableColumns) {
                String newColumnName = table.getTableName() + "_" + ADDITIONAL_ROW_NAME_PREFIX + "0_" + ADDITIONAL_COL_NAME_PREFIX + j++;
                if (tableColumn.getColumnType() == TableColumnDetails.TableColumnType.TARGET_AREA) {
                    if (table.isDynamicTable()) {
                        throw new ICCException("ALC-ACM-002-357", null, 1);
                    }
                    org.dom4j.Element targetAreaNode = targetAreaNodeTemplate.createCopy();
                    Subform subformElement = (Subform)fragmentTemplateModel.createElement("subform");
                    subformElement.loadXML((InputStream)new ByteArrayInputStream(targetAreaNode.asXML().getBytes("UTF-8")), true, true);
                    subformElement.setAttribute("", "layout", "layout", "tb");
                    subformElement.setAttribute("", "name", "name", newColumnName);
                    subformElement.setAttribute("", "minH", "minH", bodyRowHeight);
                    bodyRowNode.appendChild((com.adobe.xfa.Node)subformElement);
                    continue;
                }
                org.dom4j.Element fieldNode = fieldNodeTemplate.createCopy();
                com.adobe.xfa.template.containers.Field field = (com.adobe.xfa.template.containers.Field)fragmentTemplateModel.createElement("field");
                field.loadXML((InputStream)new ByteArrayInputStream(fieldNode.asXML().getBytes("UTF-8")), true, true);
                field.setAttribute("", "name", "name", newColumnName);
                field.setAttribute("", "minH", "minH", bodyRowHeight);
                bodyRowNode.appendChild((com.adobe.xfa.Node)field);
            }
            for (int i = 1; i < table.getConfiguredBodyRowCount(); ++i) {
                com.adobe.xfa.Node newBodyRowNode = bodyRowNode.clone(bodyRowNode.getXFAParent());
                String newRowName = ADDITIONAL_ROW_NAME_PREFIX + i;
                if (newBodyRowNode instanceof Element) {
                    ((Element)newBodyRowNode).setAttribute("", "name", "name", newRowName);
                }
                NodeList rowElements = newBodyRowNode.getNodes();
                int elementIndex = 0;
                for (int k = 0; k < rowElements.length(); ++k) {
                    com.adobe.xfa.Node node = (com.adobe.xfa.Node)rowElements.item(k);
                    if (!(node instanceof Element) || XFA.SUBFORMTAG != node.getClassTag() && XFA.FIELDTAG != node.getClassTag()) continue;
                    String newColumnName = table.getTableName() + "_" + ADDITIONAL_ROW_NAME_PREFIX + i + "_" + ADDITIONAL_COL_NAME_PREFIX + elementIndex++;
                    ((Element)node).setAttribute("", "name", "name", newColumnName);
                }
                bodyRowNode.getXFAParent().appendChild(newBodyRowNode);
            }
        }
        if (table.getFooterRow() != null && table.isShowFooterRow()) {
            Element footerRowNode = (Element)fragmentTemplateModel.resolveNode(table.getFooterRow().getRowSOMExpression());
            Element footerParent = footerRowNode.getXFAParent();
            footerRowNode.remove();
            footerParent.appendChild((com.adobe.xfa.Node)footerRowNode);
        }
        return true;
    }

    private static void createHeaderFooter(TemplateModel fragmentTemplateModel, List<TableColumnDetails> tableColumns, TableRow tableRow, boolean isHeader) {
        if (tableRow.getLastDrawSOMExpression() == null) {
            throw new ICCException("ALC-ACM-002-355", null, 1);
        }
        Element rowNode = (Element)fragmentTemplateModel.resolveNode(tableRow.getRowSOMExpression());
        Element drawNode = (Element)fragmentTemplateModel.resolveNode(tableRow.getLastDrawSOMExpression());
        drawNode.remove();
        for (TableColumnDetails tableColumn : tableColumns) {
            Draw drawElement = (Draw)drawNode.clone(rowNode);
            if (isHeader) {
                drawElement.setRawValue(tableColumn.getHeaderName());
            } else {
                drawElement.setRawValue(tableColumn.getFooterName());
            }
            rowNode.appendChild((com.adobe.xfa.Node)drawElement);
        }
    }

    private static Node getNode(String sXPath, Document doc) {
        XPath xpathSelector = DocumentHelper.createXPath((String)sXPath);
        return xpathSelector.selectSingleNode((Object)doc.getDocument());
    }

    private static Document loadDocumentFromResource(String resourceName) {
        if (resourceName == null) {
            return null;
        }
        Document doc = null;
        try {
            SAXReader reader = new SAXReader();
            InputStream is = LayoutUtil.class.getClassLoader().getResourceAsStream(resourceName);
            doc = reader.read(new InputSource(is));
            return doc;
        }
        catch (Exception e) {
            throw new ICCException("ALC-ACM-002-013", null, 1, (Throwable)e);
        }
    }

    public static void updateVariableAssignments(Set<VariableAssignment> varAssgnmnts, Map<String, Field> existingFieldIdToNewFieldMap, Set<FieldAssignment> fieldAssgments, Map<String, Field> removedFieldIdToField) {
        HashMap<String, Field> removedFieldPathToField = new HashMap<String, Field>();
        if (removedFieldIdToField != null) {
            for (Field removedField : removedFieldIdToField.values()) {
                removedFieldPathToField.put(removedField.getPath(), removedField);
            }
        }
        HashMap<String, FieldAssignment> removedFieldIdToFAS = new HashMap<String, FieldAssignment>();
        for (FieldAssignment fas : fieldAssgments) {
            if (fas.getFieldPath() == null || !removedFieldPathToField.containsKey(fas.getFieldPath())) continue;
            Field field = (Field)removedFieldPathToField.get(fas.getFieldPath());
            removedFieldIdToFAS.put(field.getId(), fas);
        }
        for (VariableAssignment varAssignment : varAssgnmnts) {
            if (!VariableAssignment.Source.FIELD.equals((Object)varAssignment.getSource())) continue;
            if (existingFieldIdToNewFieldMap.containsKey(varAssignment.getSourceReference())) {
                Field fieldRef = existingFieldIdToNewFieldMap.get(varAssignment.getSourceReference());
                if (fieldRef == null) continue;
                varAssignment.setSourceReference(fieldRef.getId());
                continue;
            }
            if (!removedFieldIdToFAS.containsKey(varAssignment.getSourceReference())) continue;
            FieldAssignment refrredFAS = (FieldAssignment)removedFieldIdToFAS.get(varAssignment.getSourceReference());
            LayoutUtil.updateVASPropertiesFromFieldAssgnment(varAssignment, refrredFAS);
        }
    }

    private static void updateVASPropertiesFromFieldAssgnment(VariableAssignment varAssignment, FieldAssignment refrredFAS) {
        logger.debug("Field object to be assigned to [" + varAssignment.getVariable() != null ? varAssignment.getVariable().getId() : varAssignment.getId() + "] is being removed.");
        varAssignment.setSource(VariableAssignment.Source.USER);
        varAssignment.setSourceReference("");
        if (refrredFAS != null) {
            varAssignment.setOptional(refrredFAS.isOptional());
            varAssignment.setEditable(refrredFAS.isEditable());
            varAssignment.setMultiLine(refrredFAS.isMultiLine());
            if (FieldAssignment.Bind.USER.equals((Object)refrredFAS.getBinding()) || FieldAssignment.Bind.CONST.equals((Object)refrredFAS.getBinding())) {
                varAssignment.setSourceReference(refrredFAS.getBindingReference());
            }
        }
    }

    public static boolean updateVariableForTARemoval(Set<TargetAreaAssignment> taAssignments, Set<VariableAssignment> variableAssignments, Map<String, TargetArea> taTobeRemoved, String layoutBeingUpdatedId, String formId) {
        boolean letterUpdated = false;
        Set<Object> variableIdTobeRemove = new HashSet();
        Set<Object> variableIdToRetain = new HashSet();
        HashMap<String, Variable> varIDToVariableMap = new HashMap<String, Variable>();
        LinkedHashSet<TargetAreaAssignment> relatedRetainedTaAssignments = new LinkedHashSet<TargetAreaAssignment>();
        LinkedHashSet<TargetAreaAssignment> relatedRemovedTaAssignments = new LinkedHashSet<TargetAreaAssignment>();
        HashSet<String> taToRemovePath = new HashSet<String>();
        for (TargetArea ta : taTobeRemoved.values()) {
            taToRemovePath.add(ta.getPath());
        }
        LayoutUtil.populateNestedTAAs(taAssignments, taToRemovePath, relatedRetainedTaAssignments, relatedRemovedTaAssignments, false, layoutBeingUpdatedId, formId);
        Map<String, Variable> tempVarIDToVariableMap = LayoutUtil.getUsedVariables(relatedRetainedTaAssignments);
        varIDToVariableMap.putAll(tempVarIDToVariableMap);
        variableIdToRetain = tempVarIDToVariableMap.keySet();
        tempVarIDToVariableMap = LayoutUtil.getUsedVariables(relatedRemovedTaAssignments);
        varIDToVariableMap.putAll(tempVarIDToVariableMap);
        variableIdTobeRemove = tempVarIDToVariableMap.keySet();
        Set<String> varIDMustRemove = LayoutUtil.difference(variableIdTobeRemove, variableIdToRetain);
        logger.debug(" found variable_ids to be removed for target area " + varIDMustRemove);
        if (varIDMustRemove.size() > 0) {
            letterUpdated = true;
        }
        HashSet<ModuleUtil.UniqueVariable> variablesToRemove = new HashSet<ModuleUtil.UniqueVariable>();
        for (String varIdRemove : varIDMustRemove) {
            Variable var = (Variable)varIDToVariableMap.get(varIdRemove);
            ModuleUtil.UniqueVariable uniqVar = new ModuleUtil.UniqueVariable(var);
            variablesToRemove.add(uniqVar);
        }
        ModuleUtil.updateRefsForVariableRemoval(variablesToRemove, variableAssignments);
        ModuleUtil.updateVariableAssignmentForVariableRemoval(varIDMustRemove, variableAssignments);
        return letterUpdated;
    }

    private static Map<String, Variable> getUsedVariables(Set<TargetAreaAssignment> taAssignments) {
        HashMap<String, Variable> varIDToVariableMap = new HashMap<String, Variable>();
        for (TargetAreaAssignment tas : taAssignments) {
            List<ModuleAssignment> masList = tas.getModuleAssignmentList();
            if (masList == null) continue;
            for (ModuleAssignment mas : masList) {
                Set<Variable> variables;
                if (mas.getDataModule() == null || (variables = ModuleUtil.getAllVariables(mas.getDataModule())) == null) continue;
                for (Variable var : variables) {
                    varIDToVariableMap.put(var.getId(), var);
                }
            }
        }
        return varIDToVariableMap;
    }

    public static void populateNestedTAAs(Set<TargetAreaAssignment> taaList, Set<String> taToRemovePath, Set<TargetAreaAssignment> taAssignmentToRatain, Set<TargetAreaAssignment> taAssignmentToRemove, boolean removeAllTA, String layoutBeingUpdatedId, String currentLayoutId) {
        if (taaList == null) {
            return;
        }
        for (TargetAreaAssignment tas : taaList) {
            if (removeAllTA || layoutBeingUpdatedId.equals(currentLayoutId) && taToRemovePath.contains(tas.getTargetAreaPath())) {
                taAssignmentToRemove.add(tas);
                if (tas.getContainerLayoutAssignmentList() == null) continue;
                for (ContainerLayoutAssignment cla : tas.getContainerLayoutAssignmentList()) {
                    if (cla.getTargetAreaAssignments() == null) continue;
                    LayoutUtil.populateNestedTAAs(cla.getTargetAreaAssignments(), taToRemovePath, taAssignmentToRatain, taAssignmentToRemove, true, layoutBeingUpdatedId, cla.getContainerLayout().getId());
                }
                continue;
            }
            taAssignmentToRatain.add(tas);
            if (tas.getContainerLayoutAssignmentList() == null) continue;
            for (ContainerLayoutAssignment cla : tas.getContainerLayoutAssignmentList()) {
                if (cla.getTargetAreaAssignments() == null) continue;
                LayoutUtil.populateNestedTAAs(cla.getTargetAreaAssignments(), taToRemovePath, taAssignmentToRatain, taAssignmentToRemove, false, layoutBeingUpdatedId, cla.getContainerLayout().getId());
            }
        }
    }

    public static void updateTAAssignment(Map<String, TargetArea> taTobeRemoved, Set<TargetAreaAssignment> TargetAreaAssignments, Map<String, TargetArea> exisitingTAPathToNewTAs) {
        Iterator<TargetAreaAssignment> taAssIter = TargetAreaAssignments.iterator();
        while (taAssIter.hasNext()) {
            TargetAreaAssignment taAsgmt = taAssIter.next();
            logger.debug(" processing Targe Area assignment " + taAsgmt.toString());
            if (taAsgmt.getTargetArea() != null) {
                String taID = taAsgmt.getTargetArea().getId();
                if (taTobeRemoved.containsKey(taID)) {
                    logger.debug("removing Target Area assignment " + taAsgmt.toString());
                    taAssIter.remove();
                    continue;
                }
                if (!exisitingTAPathToNewTAs.containsKey(taAsgmt.getTargetAreaPath())) continue;
                taAsgmt.setTargetArea(exisitingTAPathToNewTAs.get(taAsgmt.getTargetAreaPath()));
                logger.info("Correcting the target area assignment mapping in the letter. Setting the target area " + taAsgmt.getId() + " in " + taAsgmt.getTargetArea().getId());
                continue;
            }
            if (taAsgmt.getTargetAreaPath() != null) {
                if (exisitingTAPathToNewTAs.containsKey(taAsgmt.getTargetAreaPath())) {
                    taAsgmt.setTargetArea(exisitingTAPathToNewTAs.get(taAsgmt.getTargetAreaPath()));
                    logger.info("Correcting the target area assignment mapping in the letter. Setting the target area " + taAsgmt.getId() + " in " + taAsgmt.getTargetArea().getId());
                    continue;
                }
                taAssIter.remove();
                continue;
            }
            logger.warn("TargetArea Assignment " + taAsgmt.getId() + " contains a null or invalid TargetArea Id.");
        }
    }

    public static void updateFieldAssignment(Map<String, Field> fieldsTobeRemoved, Set<FieldAssignment> fieldAssignments, Map<String, Field> existingFieldPathToFields) {
        Iterator<FieldAssignment> fAssIter = fieldAssignments.iterator();
        while (fAssIter.hasNext()) {
            FieldAssignment fAsgmt = fAssIter.next();
            logger.debug("processing field assignment " + fAsgmt.toString());
            if (fAsgmt.getField() != null) {
                String fieldID = fAsgmt.getField().getId();
                if (fieldsTobeRemoved.containsKey(fieldID)) {
                    logger.debug("removing field assignment " + fAsgmt.toString());
                    fAssIter.remove();
                    continue;
                }
                if (!existingFieldPathToFields.containsKey(fAsgmt.getFieldPath())) continue;
                fAsgmt.setField(existingFieldPathToFields.get(fAsgmt.getFieldPath()));
                logger.info("Correcting the field assignment mapping in the letter. Setting the field " + fAsgmt.getId() + " in " + fAsgmt.getField().getId());
                continue;
            }
            if (fAsgmt.getFieldPath() != null) {
                if (existingFieldPathToFields.containsKey(fAsgmt.getFieldPath())) {
                    fAsgmt.setField(existingFieldPathToFields.get(fAsgmt.getFieldPath()));
                    logger.info("Correcting the field assignment mapping in the letter. Setting the field " + fAsgmt.getId() + " in " + fAsgmt.getField().getId());
                    continue;
                }
                fAssIter.remove();
                continue;
            }
            logger.warn("Field Assignment " + fAsgmt.getId() + " contains a null or invalid Field Id.");
        }
    }

    public static void populateFragmentFieldAndTAs(FragmentLayout fragmentLayout, Set<Field> fields, Set<TargetArea> targetAreas) {
        LayoutUtil.populateFieldAndTAsOfTables(fragmentLayout, fields, targetAreas);
        if (fragmentLayout.getTargetAreas() != null) {
            targetAreas.addAll(fragmentLayout.getTargetAreas());
        }
        if (fragmentLayout.getFields() != null) {
            fields.addAll(fragmentLayout.getFields());
        }
    }

    public static void populateFieldAndTAsOfTables(FragmentLayout fragmentLayout, Set<Field> fields, Set<TargetArea> tas) {
        if (fragmentLayout.getTables() != null) {
            Set<Table> oldFragmentTables = fragmentLayout.getTables();
            for (Table table : oldFragmentTables) {
                List<TableRow> tableRows;
                TableRow tableRow = table.getHeaderRow();
                if (tableRow != null) {
                    fields.addAll(tableRow.getFields());
                    tas.addAll(tableRow.getTargetAreas());
                }
                if ((tableRow = table.getFooterRow()) != null) {
                    fields.addAll(tableRow.getFields());
                    tas.addAll(tableRow.getTargetAreas());
                }
                if ((tableRows = table.getBodyRows()) == null) continue;
                for (TableRow tblRow : tableRows) {
                    fields.addAll(tblRow.getFields());
                    tas.addAll(tblRow.getTargetAreas());
                }
            }
        }
    }

    public static void copyTableIds(Set<Table> sourceTableSet, Set<Table> targetTableSet) {
        if (sourceTableSet == null || targetTableSet == null) {
            return;
        }
        HashMap<String, Table> srcIdToTableMap = new HashMap<String, Table>();
        for (Table table : sourceTableSet) {
            if (table.getTableSOMExpression() == null) continue;
            srcIdToTableMap.put(table.getTableSOMExpression(), table);
        }
        for (Table table : targetTableSet) {
            if (table.getTableSOMExpression() == null) continue;
            Table srcTable = (Table)srcIdToTableMap.get(table.getTableSOMExpression());
            LayoutUtil.copyTableIds(srcTable, table);
        }
    }

    private static void copyTableIds(Table sourceTable, Table targetTable) {
        if (sourceTable == null || targetTable == null) {
            return;
        }
        if (sourceTable.getTableSOMExpression() == null || targetTable.getTableSOMExpression() == null || !sourceTable.getTableSOMExpression().equals(targetTable.getTableSOMExpression())) {
            return;
        }
        targetTable.setId(sourceTable.getId());
        TableRow sourceTableRow = sourceTable.getHeaderRow();
        TableRow targetTableRow = targetTable.getHeaderRow();
        if (sourceTableRow != null && targetTableRow != null && sourceTableRow.getRowSOMExpression() != null && targetTableRow.getRowSOMExpression() != null && sourceTableRow.getRowSOMExpression().equals(targetTableRow.getRowSOMExpression())) {
            LayoutUtil.copyTableRowIds(sourceTableRow, targetTableRow);
        }
        sourceTableRow = sourceTable.getFooterRow();
        targetTableRow = targetTable.getFooterRow();
        if (sourceTableRow != null && targetTableRow != null && sourceTableRow.getRowSOMExpression() != null && targetTableRow.getRowSOMExpression() != null && sourceTableRow.getRowSOMExpression().equals(targetTableRow.getRowSOMExpression())) {
            LayoutUtil.copyTableRowIds(sourceTableRow, targetTableRow);
        }
        List<TableRow> sourceTableRows = sourceTable.getBodyRows();
        List<TableRow> targetTableRows = targetTable.getBodyRows();
        HashMap<String, TableRow> somToTableRowMap = new HashMap<String, TableRow>();
        if (sourceTableRows != null) {
            for (TableRow tblRow : sourceTableRows) {
                if (tblRow.getRowSOMExpression() == null) continue;
                somToTableRowMap.put(tblRow.getRowSOMExpression(), tblRow);
            }
        }
        if (targetTableRows != null) {
            for (TableRow trgtTableRow : targetTableRows) {
                TableRow srcTableRow = (TableRow)somToTableRowMap.get(trgtTableRow.getRowSOMExpression());
                if (srcTableRow == null) continue;
                LayoutUtil.copyTableRowIds(srcTableRow, trgtTableRow);
            }
        }
    }

    private static void copyTableRowIds(TableRow sourceTableRow, TableRow targetTableRow) {
        if (sourceTableRow != null && targetTableRow != null) {
            targetTableRow.setId(sourceTableRow.getId());
            LayoutUtil.copyFieldIds(sourceTableRow.getFields(), targetTableRow.getFields());
            LayoutUtil.copyTAIds(sourceTableRow.getTargetAreas(), targetTableRow.getTargetAreas());
        }
    }

    public static void copyFieldIds(Set<Field> sourceFields, Set<Field> targetFields) {
        HashMap<String, String> sourceFieldPathToFieldId = new HashMap<String, String>();
        if (sourceFields != null) {
            for (Field field : sourceFields) {
                sourceFieldPathToFieldId.put(field.getPath(), field.getId());
            }
        }
        if (targetFields != null) {
            for (Field field : targetFields) {
                field.setId((String)sourceFieldPathToFieldId.get(field.getPath()));
            }
        }
    }

    public static void copyTAIds(Set<TargetArea> sourceTAs, Set<TargetArea> targetTAs) {
        HashMap<String, String> sourceTAPathToTAId = new HashMap<String, String>();
        if (sourceTAs != null) {
            for (TargetArea ta : sourceTAs) {
                sourceTAPathToTAId.put(ta.getPath(), ta.getId());
            }
        }
        if (targetTAs != null) {
            for (TargetArea ta : targetTAs) {
                ta.setId((String)sourceTAPathToTAId.get(ta.getPath()));
            }
        }
    }

    public static boolean isUpdateDependencyRequired(Set<TargetArea> oldFormTas, Set<TargetArea> newFormTas, Set<Field> oldFormFields, Set<Field> newFormFields) {
        HashMap<String, String> oldTAPathToTAId = new HashMap<String, String>();
        if (oldFormTas != null) {
            for (TargetArea ta : oldFormTas) {
                oldTAPathToTAId.put(ta.getPath(), ta.getId());
            }
        }
        if (newFormTas != null) {
            for (TargetArea ta : newFormTas) {
                if (oldTAPathToTAId.containsKey(ta.getPath())) {
                    if (ta.getId() == null || ta.getId().equals(oldTAPathToTAId.get(ta.getPath()))) continue;
                    return true;
                }
                return true;
            }
            if (oldTAPathToTAId.keySet().size() != newFormTas.size()) {
                return true;
            }
        } else if (oldFormTas != null && oldFormTas.size() > 0) {
            return true;
        }
        HashMap<String, String> oldFieldPathToFieldId = new HashMap<String, String>();
        if (oldFormFields != null) {
            for (Field oldField : oldFormFields) {
                oldFieldPathToFieldId.put(oldField.getPath(), oldField.getId());
            }
        }
        if (newFormFields != null) {
            for (Field field : newFormFields) {
                if (oldFieldPathToFieldId.containsKey(field.getPath())) {
                    if (field.getId() == null || field.getId().equals(oldFieldPathToFieldId.get(field.getPath()))) continue;
                    return true;
                }
                return true;
            }
            if (oldFieldPathToFieldId.size() != newFormFields.size()) {
                return true;
            }
        } else if (oldFormFields != null && oldFormFields.size() > 0) {
            return true;
        }
        return false;
    }

    private static Set<String> findVarialeIDsForName(String name, Map<String, String> idToName) {
        HashSet<String> ids = new HashSet<String>();
        if (idToName.containsValue(name)) {
            for (String id : idToName.keySet()) {
                String retrivedValue = idToName.get(id);
                if (!name.equals(retrivedValue)) continue;
                ids.add(id);
            }
        }
        return ids;
    }

    public static void sortContainerLayoutAssignments(List<ContainerLayoutAssignment> clas) {
        if (clas.size() > 1) {
            Collections.sort(clas, new Comparator<ContainerLayoutAssignment>(){

                @Override
                public int compare(ContainerLayoutAssignment cla1, ContainerLayoutAssignment cla2) {
                    int cla2Length;
                    int cla1Length = cla1.getId().length();
                    return cla1Length < (cla2Length = cla2.getId().length()) ? -1 : (cla1Length == cla2Length ? 0 : 1);
                }
            });
        }
    }

    private static <T> Set<T> difference(Set<T> setA, Set<T> setB) {
        HashSet<T> result = new HashSet<T>(setA);
        result.removeAll(setB);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TableLayout {
        TABLE,
        HEADER,
        ROW,
        FOOTER,
        NONE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LayoutType {
        TEMPLATE,
        FRAGMENT;

    }
}

