/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.signatures.pki.client.types.prefs;

import com.adobe.fd.signatures.pki.client.types.common.RevocationCheckOrder;
import com.adobe.fd.signatures.pki.client.types.prefs.GeneralPreferences;
import com.adobe.fd.signatures.pki.client.types.prefs.PreferencesMap;

public class GeneralPreferencesImpl
extends PreferencesMap
implements GeneralPreferences {
    private static final long serialVersionUID = -6201239836706154414L;
    private static final String revCheckOrderStr = "revCheckOrder";
    private static final RevocationCheckOrder revCheckOrder_Default = RevocationCheckOrder.OCSPFirst;
    private static final String maxRevInfoArchiveSizeStr = "maxRevInfoArchiveSize";
    private static final Integer maxRevInfoArchiveSize_Default = new Integer(10);
    private static final String disableCacheStr = "disableAllCaches";
    private static final Boolean disableCache_Default = new Boolean(false);
    private static final String certCacheLifetimeStr = "certCacheLifetime";
    private static final long certCacheLifetime_Default = 86400000L;
    private static final String maxSessionsStr = "maxSessions";
    private static final int maxSessions_Default = 5;
    private static final String splitHSMSigningStr = "splitHSMSign";
    private static final Boolean splitHSMSigning_Default = Boolean.TRUE;

    public GeneralPreferencesImpl() {
        this.put(revCheckOrderStr, (Object)revCheckOrder_Default);
        this.put(maxRevInfoArchiveSizeStr, (Object)maxRevInfoArchiveSize_Default);
        this.put(disableCacheStr, (Object)disableCache_Default);
        this.put(certCacheLifetimeStr, (Object)86400000L);
        this.put(maxSessionsStr, (Object)5);
        this.put(splitHSMSigningStr, (Object)splitHSMSigning_Default);
    }

    public GeneralPreferencesImpl(GeneralPreferences prefs) {
        this();
        this.setRevCheckOrder(prefs.getRevCheckOrder());
        this.setDisableCache(prefs.isCacheDisabled());
        this.setCertCacheLifetime(prefs.getCertCacheLifetime());
        this.setMaxSessions(prefs.getMaxSessions());
        this.put(splitHSMSigningStr, (Object)prefs.splitHSMSigning());
    }

    protected Object getPrefValueFromString(String prefName, String value) {
        if (prefName.equalsIgnoreCase(revCheckOrderStr)) {
            return RevocationCheckOrder.getValueFromString(value);
        }
        if (prefName.equalsIgnoreCase(maxRevInfoArchiveSizeStr) || prefName.equalsIgnoreCase(maxSessionsStr)) {
            return new Integer(value);
        }
        if (prefName.equalsIgnoreCase(disableCacheStr)) {
            return new Boolean(value);
        }
        if (prefName.equalsIgnoreCase(certCacheLifetimeStr)) {
            return new Long(value);
        }
        return value;
    }

    public RevocationCheckOrder getRevCheckOrder() {
        return (RevocationCheckOrder)((Object)this.get(revCheckOrderStr));
    }

    public void setRevCheckOrder(RevocationCheckOrder revCheckOrder) {
        if (revCheckOrder != null) {
            this.put(revCheckOrderStr, (Object)revCheckOrder);
        }
    }

    public int getMaxRevInfoArchiveSize() {
        return (Integer)this.get(maxRevInfoArchiveSizeStr);
    }

    public void setMaxRevInfoArchiveSize(int size) {
        this.put(maxRevInfoArchiveSizeStr, (Object)size);
    }

    public boolean isCacheDisabled() {
        return (Boolean)this.get(disableCacheStr);
    }

    public void setDisableCache(boolean isDisabled) {
        this.put(disableCacheStr, (Object)new Boolean(isDisabled));
    }

    public long getCertCacheLifetime() {
        return (Long)this.get(certCacheLifetimeStr);
    }

    public void setCertCacheLifetime(long value) {
        this.put(certCacheLifetimeStr, (Object)value);
    }

    public int getMaxSessions() {
        return (Integer)this.get(maxSessionsStr);
    }

    public void setMaxSessions(int maxSessions) {
        if (maxSessions < 0 || maxSessions > 10) {
            return;
        }
        this.put(maxSessionsStr, (Object)maxSessions);
    }

    public boolean splitHSMSigning() {
        return (Boolean)this.get(splitHSMSigningStr);
    }

    public void splitHSMSigning(boolean splitHSMSigning) {
        this.put(splitHSMSigningStr, (Object)splitHSMSigning);
    }

    public PreferencesMap newInstance() {
        return new GeneralPreferencesImpl();
    }

    protected PreferencesMap createChild(String myKey) {
        return null;
    }
}

