/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.signatures.pki.client.types.prefs;

import com.adobe.fd.signatures.pki.client.types.common.RevocationCheckStyle;
import com.adobe.fd.signatures.pki.client.types.prefs.CRLPreferences;
import com.adobe.fd.signatures.pki.client.types.prefs.CommonPreferencesImpl;
import com.adobe.fd.signatures.pki.client.types.prefs.PreferencesMap;

public class CRLPreferencesImpl
extends CommonPreferencesImpl
implements CRLPreferences {
    private static final long serialVersionUID = -3269412995157936028L;
    private static final String localURIStr = "localURI";
    private static final String alwaysConsultLocalURLStr = "alwaysConsultLocalURL";
    private static final Boolean alwaysConsultLocalURL_Default = new Boolean("false");
    private static final String useCacheStr = "useCache";
    private static final boolean useCacheStr_Default = true;
    private static final String ldapServerStr = "ldapServer";
    private static final String goOnlineStr = "goOnline";
    private static final boolean goOnlineStr_Default = true;
    private static final String ignoreValidityDatesStr = "ignoreValidityDates";
    private static final boolean ignoreValidityDatesStr_Default = false;
    private static final String requireAKIStr = "requireAKI";
    private static final boolean requireAKIStr_Default = false;
    private static final String validityWinStr = "validityWin";
    private static final long validityWinStr_Default = 0L;

    public CRLPreferencesImpl() {
        super(RevocationCheckStyle.BestEffort);
        this.put(alwaysConsultLocalURLStr, (Object)alwaysConsultLocalURL_Default);
        this.put(useCacheStr, (Object)true);
        this.put(goOnlineStr, (Object)true);
        this.put(ignoreValidityDatesStr, (Object)false);
        this.put(requireAKIStr, (Object)false);
        this.put(validityWinStr, (Object)0L);
    }

    protected Object getPrefValueFromString(String prefName, String value) {
        if (prefName.equalsIgnoreCase(localURIStr) || prefName.equalsIgnoreCase(ldapServerStr)) {
            return value.trim().length() != 0 ? value.trim() : null;
        }
        if (prefName.equalsIgnoreCase(alwaysConsultLocalURLStr) || prefName.equalsIgnoreCase(useCacheStr) || prefName.equalsIgnoreCase(goOnlineStr) || prefName.equalsIgnoreCase(ignoreValidityDatesStr) || prefName.equalsIgnoreCase(requireAKIStr)) {
            return Boolean.valueOf(value);
        }
        return super.getPrefValueFromString(prefName, value);
    }

    public boolean getAlwaysConsultLocalURL() {
        return (Boolean)this.get(alwaysConsultLocalURLStr);
    }

    public void setAlwaysConsultLocalURL(boolean alwaysConsultLocalURL) {
        this.put(alwaysConsultLocalURLStr, (Object)alwaysConsultLocalURL);
    }

    public String getLocalURI() {
        return (String)this.get(localURIStr);
    }

    public void setLocalURI(String localURI) {
        this.put(localURIStr, (Object)localURI);
    }

    public boolean getUseCache() {
        return (Boolean)this.get(useCacheStr);
    }

    public void setUseCache(boolean useCache) {
        this.put(useCacheStr, (Object)useCache);
    }

    public String getLDAPServer() {
        return (String)this.get(ldapServerStr);
    }

    public void setLDAPServer(String server) {
        if (server != null && !server.trim().equals("")) {
            this.put(ldapServerStr, (Object)server);
        }
    }

    public boolean getGoOnline() {
        return (Boolean)this.get(goOnlineStr);
    }

    public void setGoOnline(boolean goOnline) {
        this.put(goOnlineStr, (Object)goOnline);
    }

    public boolean getIgnoreValidityDates() {
        return (Boolean)this.get(ignoreValidityDatesStr);
    }

    public void setIgnoreValidityDates(boolean ignoreValidityDates) {
        this.put(ignoreValidityDatesStr, (Object)ignoreValidityDates);
    }

    public boolean getRequireAKI() {
        return (Boolean)this.get(requireAKIStr);
    }

    public void setRequireAKI(boolean requireAKI) {
        this.put(requireAKIStr, (Object)requireAKI);
    }

    public long getValidityWindow() {
        return (Long)this.get(validityWinStr);
    }

    public void setValidityWindow(long validityWindow) {
        this.put(validityWinStr, (Object)validityWindow);
    }

    public PreferencesMap newInstance() {
        return new CRLPreferencesImpl();
    }

    protected PreferencesMap createChild(String myKey) {
        return null;
    }
}

