/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.exm.expeval;

import com.adobe.exm.exception.LogLevels;
import com.adobe.exm.exception.MessageLogger;
import com.adobe.exm.expeval.functionutil.SampleFunctionUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.el.FunctionMapper;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.osgi.service.component.ComponentContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, immediate=true, label="lc.exm.functionMapper")
@Service(value={FunctionMapper.class})
public class DefaultFunctionMapper
implements FunctionMapper {
    private Map<String, Object> expressionUtils;
    private Map<String, Method> methods;

    public Map<String, Object> getExpressionUtils() {
        return this.expressionUtils;
    }

    public void setExpressionUtils(Map<String, Object> expressionUtils) {
        this.expressionUtils = expressionUtils;
        if (this.methods == null) {
            Map.Entry[] euIterator;
            this.methods = new HashMap<String, Method>();
            for (Map.Entry expressionUtil : euIterator = expressionUtils.entrySet().toArray(new Map.Entry[1])) {
                String prefix = (String)expressionUtil.getKey();
                Object functionContainer = expressionUtil.getValue();
                for (Method method : functionContainer.getClass().getDeclaredMethods()) {
                    this.methods.put(prefix + ":" + method.getName(), method);
                }
            }
        }
    }

    public Method resolveFunction(String prefix, String localName) {
        if (prefix != null && prefix.trim().length() > 0 && localName != null && localName.trim().length() > 0) {
            Method method = this.methods.get(prefix + ":" + localName);
            if (method == null) {
                MessageLogger.logMessage(this.getClass(), LogLevels.LOG_ERROR, "ALC-EXP-001-005", new String[]{localName});
            }
            return method;
        }
        return null;
    }

    protected void activate(ComponentContext context) {
        HashMap<String, Object> expressionUtils = new HashMap<String, Object>();
        expressionUtils.put("fm1", new SampleFunctionUtil());
        this.setExpressionUtils(expressionUtils);
    }
}

