/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dct.util;

import com.adobe.dct.exception.DCTException;
import com.adobe.dct.exception.LogLevels;
import com.adobe.dct.exception.MessageLogger;
import com.adobe.dct.transfer.BindingElement;
import com.adobe.dct.transfer.DataDictionary;
import com.adobe.dct.transfer.DataDictionaryElement;
import com.adobe.dct.transfer.DataDictionaryElementType;
import com.adobe.dct.transfer.LocalizationResourceInfo;
import com.adobe.dct.util.FileManager;
import com.adobe.dct.util.Validations;
import com.adobe.livecycle.content.appcontext.AppContext;
import com.adobe.livecycle.content.appcontext.AppContextManager;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DCTUtil {
    private static final String DCT_CONFIGURATION_FOLDER = "fd/dct/config";
    private static final String CONTENT_APPS_FOLDER = "/content/apps";
    public static final String DEFAULT_APPS_CONTEXT = "/content/apps/cm";
    public static final String DEFAULT_APP_CONFIG_FOLDER = "/defaultApp";
    private static final Logger logger = LoggerFactory.getLogger((String)DCTUtil.class.getName());

    public static String getConfigFolderForBB() {
        return DCT_CONFIGURATION_FOLDER;
    }

    public static String getSolutionSpecficConfigFolderForBB() throws DCTException {
        AppContext appContext = AppContextManager.getCurrentAppContext();
        if (appContext == null) {
            throw new DCTException("APP Context not found");
        }
        String currentAppContext = appContext.getAppRoot();
        if (DEFAULT_APPS_CONTEXT.equals(currentAppContext)) {
            return FileManager.getResolvedResourcePath(null, DCTUtil.getConfigFolderForBB() + DEFAULT_APP_CONFIG_FOLDER);
        }
        if (currentAppContext.startsWith(CONTENT_APPS_FOLDER)) {
            String path = FileManager.getResolvedResourcePath(null, DCTUtil.getConfigFolderForBB() + currentAppContext.substring(CONTENT_APPS_FOLDER.length()));
            try {
                if (path == null || path.isEmpty()) {
                    path = FileManager.getResolvedResourcePath(null, DCTUtil.getConfigFolderForBB() + DEFAULT_APP_CONFIG_FOLDER);
                    logger.info("Unable to find the Node in selected app context : " + path + " switching to default app context ");
                }
            }
            catch (Exception ex) {
                logger.error("Error in checking nodeExists : ", (Throwable)ex);
                path = FileManager.getResolvedResourcePath(null, DCTUtil.getConfigFolderForBB() + DEFAULT_APP_CONFIG_FOLDER);
                logger.info("Unable to find the Node in selected app context : " + path + " switching to default app context ");
            }
            return path;
        }
        return FileManager.getResolvedResourcePath(null, DCTUtil.getConfigFolderForBB() + currentAppContext);
    }

    public static DataDictionaryElement findDDEByReferenceName(String referenceName, DataDictionary dataDictionary) throws DCTException {
        if (dataDictionary == null) {
            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-001");
            throw new DCTException("ALC-DCT-002-001");
        }
        if (dataDictionary.getReferenceNameToPathMap() == null) {
            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-059");
            throw new DCTException("ALC-DCT-002-059");
        }
        String path = dataDictionary.getReferenceNameToPathMap().get(referenceName);
        if (path == null) {
            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-058");
            throw new DCTException("ALC-DCT-002-058");
        }
        return DCTUtil.findDDEByPath(path, dataDictionary);
    }

    public static DataDictionaryElement findDDEByPath(String ddePath, DataDictionary dataDictionary) throws DCTException {
        DataDictionaryElement selectedDDE;
        if (dataDictionary == null) {
            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-001");
            throw new DCTException("ALC-DCT-002-001");
        }
        if (ddePath == null) {
            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-043", new String[]{"ddePath"});
            throw new DCTException("ALC-DCT-002-043", new String[]{"ddePath"});
        }
        String[] elementNames = ddePath.split("\\.");
        if (!elementNames[0].equals((selectedDDE = dataDictionary.getDDElements().get(0)).getName())) {
            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-044", new String[]{ddePath, elementNames[0]});
            throw new DCTException("ALC-DCT-002-044", new String[]{ddePath, elementNames[0]});
        }
        for (int index = 1; index < elementNames.length; ++index) {
            if (selectedDDE.getElementType().equals(DataDictionaryElementType.COMPOSITE)) {
                for (DataDictionaryElement childElement : selectedDDE.getChildElements()) {
                    if (!childElement.getName().equals(elementNames[index])) continue;
                    selectedDDE = childElement;
                }
                continue;
            }
            if (!selectedDDE.getElementType().equals(DataDictionaryElementType.COLLECTION) || selectedDDE.getCollectionElement().getElementType() != DataDictionaryElementType.COMPOSITE) continue;
            for (DataDictionaryElement childElement : selectedDDE.getCollectionElement().getChildElements()) {
                if (!childElement.getName().equals(elementNames[index])) continue;
                selectedDDE = childElement;
            }
        }
        return selectedDDE;
    }

    public static void generatePathsForDataDictionary(DataDictionary dataDictionary) {
        for (DataDictionaryElement dde : dataDictionary.getDDElements()) {
            dde.setPath(dde.getName());
            DCTUtil.fillPathForDictionaryElement(dde, null, dde.getPath());
        }
    }

    private static void fillPathForDictionaryElement(DataDictionaryElement dde, DataDictionaryElement parentDDE, String parentPath) {
        if (dde == null) {
            return;
        }
        if (parentDDE != null) {
            if (parentDDE.getElementType() == DataDictionaryElementType.COLLECTION) {
                dde.setPath(null);
                dde.setName(dde.getElementType().toString());
                dde.setDisplayName(dde.getElementType().toString());
            } else {
                parentPath = parentPath + "." + dde.getName();
                dde.setPath(parentPath);
            }
        }
        if (dde.getElementType() == DataDictionaryElementType.COLLECTION && dde.getCollectionElement() != null) {
            DCTUtil.fillPathForDictionaryElement(dde.getCollectionElement(), dde, parentPath);
        } else if (dde.getElementType() == DataDictionaryElementType.COMPOSITE && dde.getChildElements() != null) {
            for (DataDictionaryElement childDDE : dde.getChildElements()) {
                DCTUtil.fillPathForDictionaryElement(childDDE, dde, parentPath);
            }
        }
    }

    public static void generatePOJOBindingForDataDictionary(DataDictionary dataDictionary) {
        for (DataDictionaryElement dde : dataDictionary.getDDElements()) {
            DCTUtil.generatePOJOBindingForDDE(dde, "");
        }
    }

    private static void generatePOJOBindingForDDE(DataDictionaryElement dde, String parentCollectionPath) {
        String binding = "";
        if (dde.getElementType() == DataDictionaryElementType.COLLECTION) {
            binding = parentCollectionPath.equals("") ? dde.getPath() : dde.getPath().substring(parentCollectionPath.length() + 1);
            BindingElement bindingElement = new BindingElement(binding);
            dde.setBinding(bindingElement);
            if (dde.getCollectionElement().getElementType() == DataDictionaryElementType.COMPOSITE) {
                DCTUtil.generatePOJOBindingForDDE(dde.getCollectionElement(), dde.getPath());
            }
        } else if (dde.getElementType() == DataDictionaryElementType.COMPOSITE) {
            for (DataDictionaryElement childDDE : dde.getChildElements()) {
                DCTUtil.generatePOJOBindingForDDE(childDDE, parentCollectionPath);
            }
        } else {
            binding = parentCollectionPath.equals("") ? dde.getPath() : dde.getPath().substring(parentCollectionPath.length() + 1);
            BindingElement bindingElement = new BindingElement(binding);
            dde.setBinding(bindingElement);
        }
    }

    public static void generateReferenceNamesInDataDictionary(DataDictionary dataDictionary) {
        for (DataDictionaryElement dde : dataDictionary.getDDElements()) {
            ArrayList<String> referenceNameList = new ArrayList<String>();
            DCTUtil.generateReferenceNamesInDDE(dde, referenceNameList);
        }
    }

    private static void generateReferenceNamesInDDE(DataDictionaryElement dde, List<String> referenceNameList) {
        block4: {
            block3: {
                DCTUtil.updateReferenceName(dde, referenceNameList);
                if (dde.getElementType() != DataDictionaryElementType.COLLECTION) break block3;
                dde.getCollectionElement().setReferenceName(dde.getCollectionElement().getName());
                if (dde.getCollectionElement().getElementType() != DataDictionaryElementType.COMPOSITE) break block4;
                for (DataDictionaryElement childDDE : dde.getCollectionElement().getChildElements()) {
                    DCTUtil.generateReferenceNamesInDDE(childDDE, referenceNameList);
                }
                break block4;
            }
            if (dde.getElementType() == DataDictionaryElementType.COMPOSITE) {
                for (DataDictionaryElement childDDE : dde.getChildElements()) {
                    DCTUtil.generateReferenceNamesInDDE(childDDE, referenceNameList);
                }
            }
        }
    }

    private static void updateReferenceName(DataDictionaryElement dde, List<String> referenceNamesList) {
        String referenceName = dde.getPath().replace(".", "");
        if (referenceNamesList.contains(referenceName)) {
            int counter = 1;
            while (referenceNamesList.contains(referenceName + counter)) {
                ++counter;
            }
            referenceName = referenceName + counter;
        }
        referenceNamesList.add(referenceName);
        dde.setReferenceName(referenceName);
    }

    public static String getAbsoluteBindingForElement(DataDictionary dataDictionary, String path) throws DCTException {
        DataDictionaryElement tempElement;
        String binding = "";
        String[] elementNames = path.split("\\.");
        if (!elementNames[0].equals((tempElement = dataDictionary.getDDElements().get(0)).getName())) {
            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-044", new String[]{path, elementNames[0]});
            throw new DCTException("ALC-DCT-002-044", new String[]{path, elementNames[0]});
        }
        for (int index = 1; index < elementNames.length; ++index) {
            if (tempElement.getElementType().equals(DataDictionaryElementType.COMPOSITE)) {
                for (DataDictionaryElement childElement : tempElement.getChildElements()) {
                    if (!childElement.getName().equals(elementNames[index])) continue;
                    if (!childElement.getElementType().equals(DataDictionaryElementType.COMPOSITE) && childElement.getXMLBinding() != null && childElement.getXMLBinding().getBindingName() != null && !childElement.getXMLBinding().getBindingName().trim().equals("")) {
                        binding = binding.trim().length() > 0 ? binding + "/" + childElement.getXMLBinding().getBindingName() : childElement.getXMLBinding().getBindingName();
                    }
                    tempElement = childElement;
                }
                continue;
            }
            if (!tempElement.getElementType().equals(DataDictionaryElementType.COLLECTION) || tempElement.getCollectionElement().getElementType() != DataDictionaryElementType.COMPOSITE) continue;
            for (DataDictionaryElement childElement : tempElement.getCollectionElement().getChildElements()) {
                if (!childElement.getName().equals(elementNames[index])) continue;
                if (!childElement.getElementType().equals(DataDictionaryElementType.COMPOSITE) && childElement.getXMLBinding() != null && childElement.getXMLBinding().getBindingName() != null && !childElement.getXMLBinding().getBindingName().trim().equals("")) {
                    binding = binding.trim().length() > 0 ? binding + "/" + childElement.getXMLBinding().getBindingName() : childElement.getXMLBinding().getBindingName();
                }
                tempElement = childElement;
            }
        }
        return binding;
    }

    public static LocalizationResourceInfo getLocalizationResourceInfo(List<LocalizationResourceInfo> infoList, String locale) {
        if (infoList == null || locale == null) {
            return null;
        }
        for (LocalizationResourceInfo resourceInfo : infoList) {
            if (!locale.equals(resourceInfo.getLocale())) continue;
            return resourceInfo;
        }
        return null;
    }

    public static Session getFnDServiceUserSession(SlingRepository repository) throws RepositoryException {
        Session session = null;
        if (repository != null) {
            session = repository.loginService(null, null);
        }
        return session;
    }

    public static ResourceResolver getFnDServiceUserResourceResolver(ResourceResolverFactory resourceResolverFactory) throws LoginException {
        ResourceResolver resourceResolver = null;
        if (resourceResolverFactory != null) {
            resourceResolver = resourceResolverFactory.getServiceResourceResolver(null);
        }
        return resourceResolver;
    }
}

