/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.livecycle.cmsa;

import com.adobe.fd.jsonrpc.JsonRpcUtils;
import com.adobe.icc.dbforms.obj.Letter;
import com.adobe.icc.dbforms.obj.Query;
import com.adobe.icc.dbforms.obj.Statement;
import com.adobe.icc.ddg.api.CoreService;
import com.adobe.icc.ddg.api.LetterRenderService;
import com.adobe.icc.render.obj.PDFResponseType;
import com.adobe.icc.services.api.LetterInstanceService;
import com.adobe.icc.services.api.LetterService;
import com.adobe.idp.Document;
import com.adobe.idp.dsc.component.ComponentContext;
import com.adobe.idp.dsc.component.LifeCycle;
import com.adobe.livecycle.cmsa.IRenderServiceWrapper;
import com.adobe.livecycle.cmsa.LetterInstanceInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class RenderServiceWrapper
implements IRenderServiceWrapper,
LifeCycle {
    private static String userName;
    private static String password;
    private static String remoteUrl;
    private static String appRoot;

    @Override
    public Map<String, Document> getProcessedTemplate(String letterName, String initialXmlData, Boolean useTestData) {
        HashMap<String, Document> result = new HashMap<String, Document>();
        if (letterName != null && !"".equals(letterName)) {
            Statement st = new Statement();
            st.setAttributeName("name");
            st.setOperator(Statement.Operator.EQUALS);
            st.setAttributeValue((Object)letterName);
            Query query = new Query();
            query.setObjectType(Letter.class.getSimpleName());
            query.addStatement(st);
            Letter l = this.getRemoteLetterService().getLetter(letterName);
            System.out.println("hhekko");
        } else {
            System.out.println("No Letter name provided.");
        }
        return result;
    }

    @Override
    public Document renderLetter(String letterId, String dataXML, boolean mergeDataOnServer, boolean useTestData, boolean renderInteractive) throws Exception {
        try {
            if (letterId == null || letterId.trim().length() == 0) {
                throw new Exception("letterId is missing");
            }
            if (dataXML == null || dataXML.trim().length() == 0) {
                throw new Exception("dataXML is missing");
            }
            PDFResponseType pdfResponse = this.getRemoteLetterRenderService().renderLetter(letterId, dataXML, mergeDataOnServer, useTestData, renderInteractive);
            if (pdfResponse != null) {
                byte[] resultPDF = pdfResponse.getFile().getDocument();
                Document renderPDF = new Document(resultPDF);
                return renderPDF;
            }
            throw new Exception("Null response from letter rendition.");
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Override
    public Document getLetterTemplate(String letterId, String dataXML) throws Exception {
        Document template = null;
        try {
            if (letterId == null || letterId.trim().length() == 0) {
                throw new Exception("letterId is missing");
            }
            Object templatePath = null;
            Map result = this.getRemoteLetterRenderService().processLetter(letterId, dataXML, false);
            if (result != null) {
                byte[] templateBytes = (byte[])result.get("layoutTemplate");
                if (templateBytes != null) {
                    template = new Document(templateBytes);
                    return template;
                }
                throw new Exception("template bytes missing after letter rendition.");
            }
            throw new Exception("Null response from letter rendition.");
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private LetterRenderService getRemoteLetterRenderService() {
        return (LetterRenderService)this.getRemoteService(LetterRenderService.class, "lc.icc.renderlib.letterRenderService");
    }

    private CoreService getRemoteCoreService() {
        return (CoreService)this.getRemoteService(CoreService.class, "lc.icc.renderlib.coreService");
    }

    @Override
    public void saveAsDraft(String letterName, String initialXmlData, Boolean useTestData, String instanceName) {
        Letter letter = this.getRemoteLetterService().getLetter(letterName);
        Map processedData = this.getRemoteLetterRenderService().processLetter(letter.getId(), initialXmlData, false);
        byte[] bytes = (byte[])processedData.get("xmlData");
        System.out.println("The length of bytes is ...." + bytes.length + "&&&& the letter name is" + letterName);
        this.getRemoteLetterInstanceService().saveAsDraft(letter, bytes, instanceName);
    }

    private LetterInstanceService getRemoteLetterInstanceService() {
        return (LetterInstanceService)this.getRemoteService(LetterInstanceService.class, "lc.icc.dbservices.letterInstanceService");
    }

    private LetterService getRemoteLetterService() {
        return (LetterService)this.getRemoteService(LetterService.class, "lc.icc.dbservices.letterService");
    }

    private Object getRemoteService(Class serviceClass, String serviceId) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("crx.serverUrl", appRoot);
        try {
            return JsonRpcUtils.getServiceProxy((String)remoteUrl, (String)userName, (String)password, (Class)serviceClass, (String)serviceId, headers);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void onStart() {
        System.out.println("Called on Start for RenderWrapper");
        Properties props = new Properties();
        try {
            props.load(this.getClass().getResourceAsStream("cmsa.properties"));
        }
        catch (IOException e) {
            return;
        }
        userName = props.getProperty("crx.username");
        password = props.getProperty("crx.password");
        remoteUrl = props.getProperty("crx.serverUrl");
        appRoot = props.getProperty("crx.appRoot");
    }

    public void onStop() {
    }

    public void setComponentContext(ComponentContext arg0) {
    }

    @Override
    public LetterInstanceInfo getLetterInstanceInfo(Document dataXML) throws Exception {
        try {
            if (dataXML == null) {
                throw new Exception("dataXML is missing");
            }
            CoreService coreService = this.getRemoteCoreService();
            if (coreService == null) {
                throw new Exception("Unable to retrive service. Please verify connection details.");
            }
            Map result = coreService.getLetterInstanceInfo(IOUtils.toString((InputStream)dataXML.getInputStream(), (String)"UTF-8"));
            LetterInstanceInfo letterInstanceInfo = new LetterInstanceInfo();
            ArrayList<Document> attachmentDocs = new ArrayList<Document>();
            List attachments = (List)result.get("attachments");
            if (attachments != null) {
                for (byte[] attachment : attachments) {
                    attachmentDocs.add(new Document(attachment));
                }
            }
            letterInstanceInfo.setLetterAttachments(attachmentDocs);
            byte[] updateLayout = (byte[])result.get("layoutTemplate");
            if (updateLayout == null) {
                throw new Exception("template bytes missing while getting Letter instance Info.");
            }
            letterInstanceInfo.setLetterTemplate(new Document(updateLayout));
            return letterInstanceInfo;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }
}

