	/**
        * Calculates Age
        * @name calculateAge
        * @param {object} field
        * @return {string} 
    */

    function calculateAge(field) {
    var dob = new Date(field);
    var now = new Date();

    var age = now.getFullYear() - dob.getFullYear();
    var monthDiff = now.getMonth() - dob.getMonth();

    if (monthDiff < 0 || (monthDiff === 0 && now.getDate() < dob.getDate())) {
    age--;
    }

    return age;
    }




	/**
    * enablePanel
    * @name enablePanel
     * @param {object} field1
     * @param {object} field2
    * @param {scope} globals 
    */

    function enablePanel(field1,field2, globals)
    {
       if(globals.functions.validate(field1).length === 0)
       {
       globals.functions.setProperty(field2, {visible: true});
       }
    }


 /**
    * validatefield
    * @name validateField
      * @param {object} field
    * @param {scope} globals //has to be last parameter, will not be displayed in UI
    */
    function validateField(field,globals)
    {
    
        globals.functions.validate(field);
    
    }   


/**
    * resetField
    * @name  resetField
    * @param {string} input1
    * @param {object} field
    * @param {scope} globals 
    */
    function  resetField(field,globals)
    {
    
        globals.functions.reset(field);
    
    }

/**
    * customMessage
    * @name customMessage
    * @param {object} field
    * @param {scope} globals 
    */
function customMessage(field, globals) {
    const minLength = 15;
    const comments = field.$value.trim();
    if (comments.length < minLength) {
        globals.functions.markFieldAsInvalid(field.$id, "Comments must be at least 15 characters long.", { useId: true });
    }
}


/**
    * submitData
    * @name submitData
    * @param {object} field
    * @param {scope} globals 
*/

function submitData(globals)
{
    
var data = globals.functions.exportData();
 if(!data.comments) {
  data.comments = 'NA';
 }
    console.log('After update:{}',data);
globals.functions.submitForm(data, false);
}



  
    async function asyncFunction() {
    const response = await fetch('https://petstore.swagger.io/v2/store/inventory');
    const data = await response.json();
    return data;
    }

    /**
    * callAsyncFunction
    * @name callAsyncFunction callAsyncFunction
    */
    function callAsyncFunction() {
    asyncFunction()
        .then(responseData => {
        console.log('Response data:', responseData);
        })
        .catch(error => {
         console.error('Error:', error);
    });
}

