/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.customhandler;

import com.adobe.fd.fp.exception.FormsPortalException;
import com.adobe.fd.fp.service.DraftDataService;
import com.adobe.fd.fp.service.PendingSignDataService;
import com.adobe.fd.fp.service.SubmitDataService;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Dictionary;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@Service(value={SubmitDataService.class, DraftDataService.class, PendingSignDataService.class})
@Property(name="aem.formsportal.impl.prop", value={"formsportal.sampledataservice"})
@Component(metatype=true, immediate=true, label="Forms Portal Sample Data service Impl")
public class FormsPortalSampleDataServiceImpl
implements SubmitDataService,
DraftDataService,
PendingSignDataService {
    @Property(value={"data"}, label="Name of the table to store data blob")
    private static final String DATA_TABLE_PROP_NAME = "datatable";
    private String dataTable = "data";
    @Property(value={"FormsPortal"}, label="Name of the configured Data Source")
    private static final String DATA_SOURCE_PROP_NAME = "datasource";
    private static final String STR_SERVICE_USER_ID = "fd-service";
    private String dataSource = "FormsPortal";
    @Reference
    protected SlingRepository slingRepository;
    @Reference
    private ResourceResolverHelper resourceResolverHelper;
    private BundleContext bundleContext;

    protected void activate(ComponentContext context) {
        Dictionary props = context.getProperties();
        this.dataSource = PropertiesUtil.toString(props.get(DATA_SOURCE_PROP_NAME), (String)"FormsPortal");
        this.dataTable = PropertiesUtil.toString(props.get(DATA_TABLE_PROP_NAME), (String)"data");
        this.bundleContext = context.getBundleContext();
    }

    private String getDataSourceName() {
        return this.dataSource;
    }

    private String getDataTableName() {
        return this.dataTable;
    }

    private Connection getConnection() throws Exception {
        try {
            String filter = "(&(objectclass=javax.sql.DataSource)(datasource.name=" + this.getDataSourceName() + "))";
            ServiceReference[] refs = this.bundleContext.getAllServiceReferences(null, filter);
            if (refs != null && refs.length == 1) {
                DataSource dataSource = (DataSource)this.bundleContext.getService(refs[0]);
                return dataSource.getConnection();
            }
            throw new FormsPortalException();
        }
        catch (Exception e) {
            throw new FormsPortalException(e.getMessage(), (Throwable)e);
        }
    }

    public String saveData(String id, String formName, String formdata) throws FormsPortalException {
        return this.saveDataInternal(id, formdata.getBytes(), this.resourceResolverHelper.getResourceResolver().getUserID());
    }

    private String saveDataInternal(String id, byte[] formData, String userName) throws FormsPortalException {
        Connection connection = null;
        Statement prStmt = null;
        try {
            String updateStatement = "INSERT INTO " + this.getDataTableName() + "(id, data, owner) VALUES((?), (?), (?))ON DUPLICATE KEY UPDATE data = (?)";
            connection = this.getConnection();
            connection.setAutoCommit(false);
            prStmt = connection.prepareStatement(updateStatement);
            if (StringUtils.isEmpty((String)id)) {
                id = this.getId();
            }
            prStmt.setString(1, id);
            prStmt.setBlob(2, new ByteArrayInputStream(formData));
            prStmt.setString(3, userName);
            prStmt.setBlob(4, new ByteArrayInputStream(formData));
            prStmt.execute();
            connection.commit();
            String string = id;
            return string;
        }
        catch (Exception e) {
            try {
                connection.rollback();
            }
            catch (SQLException e1) {
                throw new FormsPortalException((Throwable)e);
            }
            throw new FormsPortalException((Throwable)e);
        }
        finally {
            try {
                if (prStmt != null) {
                    prStmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new FormsPortalException((Throwable)e);
            }
        }
    }

    public byte[] getData(String id) throws FormsPortalException {
        Connection connection = null;
        Statement prStmt = null;
        ResultSet resultSet = null;
        try {
            byte[] response;
            connection = this.getConnection();
            String getDataStmt = "SELECT data from " + this.getDataTableName() + " WHERE id = (?)";
            prStmt = connection.prepareStatement(getDataStmt);
            prStmt.setString(1, id);
            resultSet = prStmt.executeQuery();
            resultSet.next();
            byte[] byArray = response = resultSet.getBytes("data");
            return byArray;
        }
        catch (Exception e) {
            throw new FormsPortalException((Throwable)e);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (prStmt != null) {
                    prStmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new FormsPortalException((Throwable)e);
            }
        }
    }

    public boolean deleteData(String id) throws FormsPortalException {
        Connection connection = null;
        Statement prStmt = null;
        try {
            String userId = this.resourceResolverHelper.getResourceResolver().getUserID();
            connection = this.getConnection();
            connection.setAutoCommit(false);
            String deleteStmt = "DELETE FROM " + this.getDataTableName() + " WHERE id = (?) ";
            if (!userId.equals(STR_SERVICE_USER_ID)) {
                deleteStmt = deleteStmt + "AND owner = (?)";
            }
            prStmt = connection.prepareStatement(deleteStmt);
            prStmt.setString(1, id);
            if (!userId.equals(STR_SERVICE_USER_ID)) {
                prStmt.setString(2, userId);
            }
            prStmt.execute();
            connection.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            try {
                connection.rollback();
            }
            catch (SQLException e2) {
                throw new FormsPortalException((Throwable)e);
            }
            throw new FormsPortalException((Throwable)e);
        }
        finally {
            try {
                if (prStmt != null) {
                    prStmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new FormsPortalException((Throwable)e);
            }
        }
    }

    public String saveAttachment(byte[] attachmentBytes) throws FormsPortalException {
        return this.saveAttachmentInternal(attachmentBytes, this.resourceResolverHelper.getResourceResolver().getUserID());
    }

    private String saveAttachmentInternal(byte[] attachmentBytes, String owner) throws FormsPortalException {
        Connection connection = null;
        Statement prStmt = null;
        try {
            String id = this.getId();
            connection = this.getConnection();
            connection.setAutoCommit(false);
            String saveAttachmentStmt = "INSERT INTO " + this.getDataTableName() + "(id, data, owner) VALUES((?), (?), (?))";
            prStmt = connection.prepareStatement(saveAttachmentStmt);
            prStmt.setString(1, id);
            prStmt.setBytes(2, attachmentBytes);
            prStmt.setString(3, owner);
            prStmt.execute();
            connection.commit();
            String string = id;
            return string;
        }
        catch (Exception e) {
            try {
                if (connection != null) {
                    connection.rollback();
                }
            }
            catch (SQLException e2) {
                throw new FormsPortalException((Throwable)e);
            }
            throw new FormsPortalException((Throwable)e);
        }
        finally {
            try {
                if (prStmt != null) {
                    prStmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new FormsPortalException((Throwable)e);
            }
        }
    }

    public byte[] getAttachment(String id) throws FormsPortalException {
        return this.getData(id);
    }

    public boolean deleteAttachment(String id) throws FormsPortalException {
        return this.deleteData(id);
    }

    private String getId() {
        return String.valueOf(System.nanoTime());
    }

    public String saveData(String id, byte[] data) throws FormsPortalException {
        return this.saveDataInternal(id, data, this.resourceResolverHelper.getResourceResolver().getUserID());
    }

    public String saveDataAsynchronusly(byte[] data, Map<String, Object> options) throws FormsPortalException {
        String dataId = null;
        if (this.resourceResolverHelper.getResourceResolver().getUserID().equals(STR_SERVICE_USER_ID)) {
            dataId = this.saveDataInternal((String)options.get("id"), data, (String)options.get("owner"));
        }
        return dataId;
    }

    public String saveAttachmentAsynchronously(byte[] attachmentBytes, Map<String, Object> options) throws FormsPortalException {
        String attachmentId = null;
        if (this.resourceResolverHelper.getResourceResolver().getUserID().equals(STR_SERVICE_USER_ID)) {
            attachmentId = this.saveAttachmentInternal(attachmentBytes, (String)options.get("owner"));
        }
        return attachmentId;
    }

    public String saveData(byte[] data) throws FormsPortalException {
        return this.saveDataInternal(null, data, this.resourceResolverHelper.getResourceResolver().getUserID());
    }

    public String updateData(String userDataID, byte[] data) throws FormsPortalException {
        return this.saveDataInternal(userDataID, data, this.resourceResolverHelper.getResourceResolver().getUserID());
    }

    protected void bindSlingRepository(SlingRepository slingRepository) {
        this.slingRepository = slingRepository;
    }

    protected void unbindSlingRepository(SlingRepository slingRepository) {
        if (this.slingRepository == slingRepository) {
            this.slingRepository = null;
        }
    }

    protected void bindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        this.resourceResolverHelper = resourceResolverHelper;
    }

    protected void unbindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        if (this.resourceResolverHelper == resourceResolverHelper) {
            this.resourceResolverHelper = null;
        }
    }
}

