/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.customhandler;

import com.adobe.fd.fp.common.PortalUtilsComponent;
import com.adobe.fd.fp.exception.FormsPortalException;
import com.adobe.fd.fp.service.DraftMetadataService;
import com.adobe.fd.fp.service.FPKeyGeneratorService;
import com.adobe.fd.fp.service.PendingSignMetadataService;
import com.adobe.fd.fp.service.Query;
import com.adobe.fd.fp.service.Statement;
import com.adobe.fd.fp.service.StatementGroup;
import com.adobe.fd.fp.service.SubmitMetadataService;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@Service(value={SubmitMetadataService.class, DraftMetadataService.class, PendingSignMetadataService.class})
@Property(name="aem.formsportal.impl.prop", value={"formsportal.samplemetadataservice"})
@Component(metatype=true, immediate=true, label="Forms Portal Sample Metadata service Impl")
public class FormsPortalSampleMetadataServiceImpl
implements SubmitMetadataService,
DraftMetadataService,
PendingSignMetadataService {
    @Reference
    private PortalUtilsComponent portalUtilsComponent;
    @Reference
    protected SlingRepository slingRepository;
    private static final List<String> multiValuedProps = new ArrayList<String>();
    private static final Map<Statement.Operator, String> sqlOperatorMap = new HashMap<Statement.Operator, String>();
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile FPKeyGeneratorService fpKeyGeneratorService;
    @Reference
    private ResourceResolverHelper resourceResolverHelper;
    @Property(value={"FormsPortal"}, label="Name of the configured Data Source")
    private static final String DATA_SOURCE_PROP_NAME = "datasource";
    private String dataSource = "FormsPortal";
    @Property(value={"metadata"}, label="Name of the table to store out of the box metadata")
    private static final String METADATA_TABLE_PROP_NAME = "metadatatable";
    private String metadataTable = "metadata";
    @Property(value={"additionalmetadatatable"}, label="Name of the table to store additional metadata")
    private static final String ADDITIONAL_METADATA_TABLE_PROP_NAME = "additionalmetadatatable";
    private String additionalMetadataTable = "additionalmetadatatable";
    @Property(value={"commenttable"}, label="Name of the table to store comments of reviewers on form submissions")
    private static final String COMMENT_TABLE_PROP_NAME = "commenttable";
    private String commentTable = "commenttable";
    private BundleContext bundleContext;

    protected void activate(ComponentContext context) {
        Dictionary props = context.getProperties();
        this.dataSource = PropertiesUtil.toString(props.get(DATA_SOURCE_PROP_NAME), (String)"FormsPortal");
        this.metadataTable = PropertiesUtil.toString(props.get(METADATA_TABLE_PROP_NAME), (String)"metadata");
        this.additionalMetadataTable = PropertiesUtil.toString(props.get(ADDITIONAL_METADATA_TABLE_PROP_NAME), (String)ADDITIONAL_METADATA_TABLE_PROP_NAME);
        this.commentTable = PropertiesUtil.toString(props.get(COMMENT_TABLE_PROP_NAME), (String)COMMENT_TABLE_PROP_NAME);
        this.bundleContext = context.getBundleContext();
    }

    private String getDataSourceName() {
        return this.dataSource;
    }

    private String getMetadataTableName() {
        return this.metadataTable;
    }

    private String getAdditionalMetadataTableName() {
        return this.additionalMetadataTable;
    }

    private Connection getConnection() throws FormsPortalException {
        try {
            String filter = "(&(objectclass=javax.sql.DataSource)(datasource.name=" + this.getDataSourceName() + "))";
            ServiceReference[] refs = this.bundleContext.getAllServiceReferences(null, filter);
            if (refs != null && refs.length == 1) {
                DataSource dataSource = (DataSource)this.bundleContext.getService(refs[0]);
                return dataSource.getConnection();
            }
            throw new FormsPortalException();
        }
        catch (Exception e) {
            throw new FormsPortalException(e.getMessage(), (Throwable)e);
        }
    }

    private List<String> listAllColumns(Connection connection) throws FormsPortalException {
        try {
            ArrayList<String> columnsList = new ArrayList<String>();
            String getColumnsStmt = "SHOW COLUMNS FROM " + this.getMetadataTableName();
            PreparedStatement prStmt = connection.prepareStatement(getColumnsStmt);
            ResultSet resultSet = prStmt.executeQuery();
            while (resultSet.next()) {
                String name = resultSet.getString("Field");
                columnsList.add(name);
            }
            return columnsList;
        }
        catch (Exception e) {
            throw new FormsPortalException((Throwable)e);
        }
    }

    public String saveMetadata(Map<String, Object> metadataMap) throws FormsPortalException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            connection.setAutoCommit(false);
            String id = metadataMap.get("draftID").toString();
            metadataMap.put("id", id);
            this.insertMetadata(id, metadataMap, connection);
            connection.commit();
            String string = id;
            return string;
        }
        catch (Exception e) {
            try {
                if (connection != null) {
                    connection.rollback();
                }
            }
            catch (SQLException e2) {
                throw new FormsPortalException((Throwable)e2);
            }
            throw new FormsPortalException((Throwable)e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new FormsPortalException((Throwable)e);
            }
        }
    }

    public JSONObject submitMetadata(Map<String, Object> metadataMap) throws FormsPortalException {
        Connection connection = null;
        Statement prStmt = null;
        try {
            connection = this.getConnection();
            connection.setAutoCommit(false);
            String id = null;
            if (metadataMap.containsKey("submitID")) {
                id = metadataMap.get("submitID").toString();
            } else {
                id = this.fpKeyGeneratorService.getUniqueId();
                metadataMap.put("submitID", id);
            }
            metadataMap.put("id", id);
            this.insertMetadata(id, metadataMap, connection);
            connection.commit();
            JSONObject submittedInstance = new JSONObject();
            String getSubmittedInstance = "SELECT * FROM " + this.getMetadataTableName() + " WHERE id = (?)";
            prStmt = connection.prepareStatement(getSubmittedInstance);
            prStmt.setString(1, id);
            ResultSet result = prStmt.executeQuery();
            if (result.next()) {
                submittedInstance.put("submitID", (Object)result.getString("submitID"));
                submittedInstance.put("formName", (Object)result.getString("formName"));
                submittedInstance.put("owner", (Object)result.getString("owner"));
                submittedInstance.put("jcr:lastModified", (Object)result.getString("jcr:lastModified"));
            }
            if (result != null) {
                result.close();
            }
            JSONObject jSONObject = submittedInstance;
            return jSONObject;
        }
        catch (Exception e) {
            try {
                if (connection != null) {
                    connection.rollback();
                }
            }
            catch (SQLException e2) {
                throw new FormsPortalException(e2.getMessage(), (Throwable)e2);
            }
            throw new FormsPortalException((Throwable)e);
        }
        finally {
            try {
                if (prStmt != null) {
                    prStmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new FormsPortalException((Throwable)e);
            }
        }
    }

    public JSONArray getDrafts(String cutPoints) throws FormsPortalException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            JSONArray jSONArray = this.listItems("fp:Draft", cutPoints, connection);
            return jSONArray;
        }
        catch (Exception e) {
            throw new FormsPortalException((Throwable)e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new FormsPortalException((Throwable)e);
            }
        }
    }

    public JSONArray getSubmissions(String cutPoints) throws FormsPortalException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            JSONArray jSONArray = this.listItems("fp:submittedForm", cutPoints, connection);
            return jSONArray;
        }
        catch (Exception e) {
            throw new FormsPortalException((Throwable)e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new FormsPortalException((Throwable)e);
            }
        }
    }

    public boolean deleteMetadata(String id) throws FormsPortalException {
        Connection connection = null;
        Statement prStmt = null;
        try {
            connection = this.getConnection();
            connection.setAutoCommit(false);
            String deleteStmt = "DELETE FROM " + this.getMetadataTableName() + " WHERE id = (?) ";
            prStmt = connection.prepareStatement(deleteStmt);
            prStmt.setString(1, id);
            prStmt.execute();
            connection.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new FormsPortalException((Throwable)e);
        }
        finally {
            try {
                if (prStmt != null) {
                    prStmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new FormsPortalException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getProperty(String id, String propertyName) throws FormsPortalException {
        Connection connection = null;
        Statement prStmt = null;
        try {
            String[] additionalMetadataStr;
            ResultSet resultSet;
            connection = this.getConnection();
            connection.setAutoCommit(false);
            String result = "";
            List<String> columnsList = this.listAllColumns(connection);
            if (columnsList != null && columnsList.contains(propertyName)) {
                String getPropertyStmt = "SELECT " + propertyName + " FROM " + this.getMetadataTableName() + " WHERE id = (?)";
                prStmt = connection.prepareStatement(getPropertyStmt);
                prStmt.setString(1, id);
                resultSet = prStmt.executeQuery();
                if (resultSet != null && resultSet.next()) {
                    if (resultSet.getString(propertyName) != null) {
                        result = resultSet.getString(propertyName);
                    }
                    if (multiValuedProps.contains(propertyName)) {
                        String[] stringArray = this.deflateList(result);
                        return stringArray;
                    }
                }
            } else {
                additionalMetadataStr = "SELECT value FROM " + this.getAdditionalMetadataTableName() + " WHERE `" + "id" + "` = (?) AND `" + "key" + "` = (?)";
                prStmt = connection.prepareStatement((String)additionalMetadataStr);
                prStmt.setString(1, id);
                prStmt.setString(2, propertyName);
                resultSet = prStmt.executeQuery();
                if (resultSet.next()) {
                    result = resultSet.getString("value");
                }
            }
            additionalMetadataStr = new String[]{result};
            return additionalMetadataStr;
        }
        catch (SQLException e) {
            String[] stringArray = new String[]{""};
            return stringArray;
        }
        finally {
            try {
                if (prStmt != null) {
                    prStmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new FormsPortalException((Throwable)e);
            }
        }
    }

    public boolean deleteProperty(String id, String propertyName) throws FormsPortalException {
        Connection connection = null;
        Statement prStmt = null;
        try {
            String deletePropertyStmt;
            connection = this.getConnection();
            connection.setAutoCommit(false);
            List<String> columnsList = this.listAllColumns(connection);
            String userId = this.resourceResolverHelper.getResourceResolver().getUserID();
            if (columnsList != null && columnsList.contains(propertyName)) {
                deletePropertyStmt = "UPDATE " + this.getMetadataTableName() + " SET (?) = NULL WHERE id = (?) AND owner = (?)";
                prStmt = connection.prepareStatement(deletePropertyStmt);
                prStmt.setString(1, propertyName);
                prStmt.setString(2, id);
                prStmt.setString(3, userId);
            } else {
                deletePropertyStmt = "DELETE FROM " + this.getAdditionalMetadataTableName() + " WHERE " + "id" + " = (?) AND `" + "key" + "` = (?)";
                prStmt = connection.prepareStatement(deletePropertyStmt);
                prStmt.setString(1, id);
                prStmt.setString(2, propertyName);
            }
            boolean result = prStmt.execute();
            connection.commit();
            boolean bl = result;
            return bl;
        }
        catch (Exception e) {
            throw new FormsPortalException((Throwable)e);
        }
        finally {
            try {
                if (prStmt != null) {
                    prStmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new FormsPortalException((Throwable)e);
            }
        }
    }

    private JSONArray listItems(String itemType, String cutPoints, Connection connection) throws FormsPortalException {
        Statement prStmt = null;
        ResultSet resultSet = null;
        try {
            String userId = this.resourceResolverHelper.getResourceResolver().getUserID();
            String getItemsStmt = "SELECT * FROM " + this.getMetadataTableName() + " LEFT JOIN " + this.getAdditionalMetadataTableName() + " ON " + this.getMetadataTableName() + "." + "id" + " = " + this.getAdditionalMetadataTableName() + "." + "id" + " WHERE " + this.getMetadataTableName() + "." + "owner" + " = (?) AND " + this.getMetadataTableName() + "." + "nodeType" + " = (?) AND " + this.getMetadataTableName() + "." + "userdataID" + " IS NOT NULL AND (" + this.metadataTable + "." + "markedForDeletion" + " != 'true' OR " + this.metadataTable + "." + "markedForDeletion" + " IS NULL ) AND (" + "owner" + "!= '" + "anonymous" + "') order by `" + "jcr:lastModified" + "` asc";
            prStmt = connection.prepareStatement(getItemsStmt);
            prStmt.setString(1, userId);
            prStmt.setString(2, itemType);
            JSONArray jSONArray = this.readItems((PreparedStatement)prStmt, itemType, cutPoints, connection);
            return jSONArray;
        }
        catch (Exception e) {
            throw new FormsPortalException((Throwable)e);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (prStmt != null) {
                    prStmt.close();
                }
            }
            catch (SQLException e) {
                throw new FormsPortalException((Throwable)e);
            }
        }
    }

    private JSONArray readItems(PreparedStatement prStmt, String itemType, String cutPoints, Connection connection) throws FormsPortalException {
        ResultSet resultSet = null;
        try {
            resultSet = prStmt.executeQuery();
            JSONArray items = new JSONArray();
            String oldId = null;
            JSONObject olditem = null;
            List<String> cutPointsList = Arrays.asList(cutPoints.split(","));
            while (resultSet.next()) {
                String additionalMetadataVal;
                String additionalMetadataKey;
                String currentId = resultSet.getString("id");
                if (oldId == null || !oldId.equals(currentId)) {
                    if (oldId != null) {
                        items.put(olditem);
                    }
                    olditem = new JSONObject();
                    oldId = currentId;
                    additionalMetadataKey = resultSet.getString("key");
                    additionalMetadataVal = resultSet.getString("value");
                    for (String cutPoint : cutPointsList) {
                        try {
                            if (cutPoint.equals(additionalMetadataKey)) {
                                olditem.put(additionalMetadataKey, (Object)additionalMetadataVal);
                                continue;
                            }
                            if (resultSet.getString(cutPoint) == null) {
                                olditem.put(cutPoint, (Object)"");
                                continue;
                            }
                            olditem.put(cutPoint, (Object)resultSet.getString(cutPoint));
                        }
                        catch (SQLException e) {
                            olditem.put(cutPoint, (Object)"");
                        }
                    }
                    if (cutPointsList.contains("name") && StringUtils.isEmpty((CharSequence)olditem.getString("name"))) {
                        olditem.put("name", (Object)resultSet.getString("formName"));
                    }
                    olditem.put("jcr:lastModified", (Object)resultSet.getString("jcr:lastModified"));
                    continue;
                }
                additionalMetadataKey = resultSet.getString("key");
                additionalMetadataVal = resultSet.getString("value");
                if (!cutPointsList.contains(additionalMetadataKey)) continue;
                olditem.put(additionalMetadataKey, (Object)additionalMetadataVal);
            }
            if (olditem != null) {
                items.put(olditem);
            }
            if (resultSet != null) {
                resultSet.close();
            }
            JSONArray jSONArray = items;
            return jSONArray;
        }
        catch (Exception e) {
            throw new FormsPortalException((Throwable)e);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (prStmt != null) {
                    prStmt.close();
                }
            }
            catch (SQLException e) {
                throw new FormsPortalException((Throwable)e);
            }
        }
    }

    private void insertMetadata(String id, Map<String, Object> metadataMap, Connection connection) throws FormsPortalException {
        Statement prStmtMetadataTable = null;
        Statement prStmtAdditionalMetadataTable = null;
        try {
            String insertStmt = "INSERT INTO " + this.getMetadataTableName();
            List<String> columnsListMain = this.listAllColumns(connection);
            ArrayList<String> metadataKeysMain = new ArrayList<String>(metadataMap.keySet());
            ArrayList<String> columnsListAndMetadatakeys = new ArrayList<String>(columnsListMain);
            columnsListAndMetadatakeys.retainAll(metadataKeysMain);
            String columnsStr = StringUtils.join(columnsListAndMetadatakeys, (String)"`,`");
            int columnsCount = columnsListAndMetadatakeys.size();
            StringBuffer stmtBuffer = new StringBuffer();
            stmtBuffer.append(insertStmt).append(" (`" + columnsStr + "`)");
            String placeholder = "(?), ";
            String valuesPlaceHolders = StringUtils.repeat((String)placeholder, (int)columnsCount);
            valuesPlaceHolders = valuesPlaceHolders.substring(0, valuesPlaceHolders.length() - 2);
            stmtBuffer.append(" VALUES(" + valuesPlaceHolders + ")");
            String onDuplicateStmt = " ON DUPLICATE KEY UPDATE ";
            stmtBuffer.append(onDuplicateStmt);
            for (String column : columnsListAndMetadatakeys) {
                stmtBuffer.append("`" + column + "` = (?), ");
            }
            String statementString = stmtBuffer.toString();
            statementString = statementString.substring(0, statementString.length() - 2);
            prStmtMetadataTable = connection.prepareStatement(statementString);
            int count = 1;
            for (String column : columnsListAndMetadatakeys) {
                Object val = metadataMap.get(column);
                String strVal = null;
                if (val != null) {
                    strVal = List.class.isAssignableFrom(val.getClass()) ? this.flattentList((List)val) : (val.getClass().isArray() ? this.flattenArray((Object[])val) : String.valueOf(val));
                }
                prStmtMetadataTable.setString(count, strVal);
                prStmtMetadataTable.setString(count + columnsCount, strVal);
                ++count;
            }
            ArrayList<String> metadataKeysMinusColumnsList = new ArrayList<String>(metadataKeysMain);
            metadataKeysMinusColumnsList.removeAll(columnsListMain);
            if (metadataKeysMinusColumnsList.size() > 0) {
                insertStmt = "INSERT INTO " + this.getAdditionalMetadataTableName() + " (`" + "key" + "` , `" + "value" + "` , `" + "id" + "`) VALUES ";
                stmtBuffer.setLength(0);
                stmtBuffer.append(insertStmt);
                int rowsCount = metadataKeysMinusColumnsList.size();
                placeholder = "((?), (?), (?)) ";
                valuesPlaceHolders = StringUtils.repeat((String)placeholder, (String)" , ", (int)rowsCount);
                stmtBuffer.append(valuesPlaceHolders);
                stmtBuffer.append(onDuplicateStmt);
                String updateString = "`key` = VALUES(`key`), `value` = VALUES(`value`), `id` = VALUES(`id`)";
                stmtBuffer.append(updateString);
                statementString = stmtBuffer.toString();
                prStmtAdditionalMetadataTable = connection.prepareStatement(statementString);
                count = 1;
                for (String keyToInsert : metadataKeysMinusColumnsList) {
                    prStmtAdditionalMetadataTable.setString(count++, keyToInsert);
                    String val = metadataMap.get(keyToInsert) != null ? metadataMap.get(keyToInsert).toString() : null;
                    prStmtAdditionalMetadataTable.setString(count++, val);
                    prStmtAdditionalMetadataTable.setString(count++, id);
                }
            }
            if (prStmtMetadataTable != null) {
                prStmtMetadataTable.execute();
            }
            if (prStmtAdditionalMetadataTable != null) {
                prStmtAdditionalMetadataTable.execute();
            }
        }
        catch (Exception e) {
            throw new FormsPortalException((Throwable)e);
        }
        finally {
            try {
                if (prStmtMetadataTable != null) {
                    prStmtMetadataTable.close();
                }
                if (prStmtAdditionalMetadataTable != null) {
                    prStmtAdditionalMetadataTable.close();
                }
            }
            catch (SQLException e) {
                throw new FormsPortalException((Throwable)e);
            }
        }
    }

    public JSONObject getSubmissionsOfAllUsers(String formPath, String cutPoints, Map<String, String> searchOptions) throws FormsPortalException {
        Connection connection = null;
        JSONObject resultObj = new JSONObject();
        try {
            String orderby = "jcr:lastModified";
            String sort = "desc";
            String limit = "30";
            String offset = "0";
            String searchValue = "";
            cutPoints = cutPoints != null ? cutPoints : "formName,formPath,submitID,formType,jcr:lastModified,owner";
            connection = this.getConnection();
            Session currentSession = (Session)this.resourceResolverHelper.getResourceResolverAs(Session.class);
            if (StringUtils.isNotEmpty((CharSequence)formPath) && this.portalUtilsComponent.isReviewer(currentSession, formPath)) {
                if (searchOptions != null) {
                    orderby = searchOptions.get("orderby") != null ? searchOptions.get("orderby") : orderby;
                    sort = searchOptions.get("sort") != null ? searchOptions.get("sort") : sort;
                    limit = searchOptions.get("limit") != null ? searchOptions.get("limit") : limit;
                    offset = searchOptions.get("offset") != null ? searchOptions.get("offset") : offset;
                    searchValue = searchOptions.get("search") != null ? searchOptions.get("search") : searchValue;
                }
                ArrayList<String> cutPointsList = new ArrayList<String>(Arrays.asList(cutPoints.split(",")));
                List<String> metadataCoList = this.listAllColumns(connection);
                cutPointsList.retainAll(metadataCoList);
                String enclosedCutPoints = "`" + StringUtils.join(cutPointsList, (String)"`,`") + "`";
                String sqlQueryStmt = "SELECT " + enclosedCutPoints + " from " + this.metadataTable + " where status = 'submitted'AND formPath= '" + formPath + "' AND concat_ws(" + enclosedCutPoints + ") like '%" + searchValue + "%' ORDER BY '" + orderby + "' " + sort + " LIMIT " + limit + " OFFSET " + offset;
                PreparedStatement sqlQPreparedStatement = connection.prepareStatement(sqlQueryStmt);
                ResultSet result = sqlQPreparedStatement.executeQuery();
                JSONArray respArr = new JSONArray();
                int resultCount = 0;
                while (result.next()) {
                    ++resultCount;
                    JSONObject submissionObj = new JSONObject();
                    for (String column : cutPointsList) {
                        if (column.equals("jcr:lastModified")) {
                            Date d = new Date(Long.valueOf(result.getString("jcr:lastModified")));
                            submissionObj.put(column, (Object)d.toString());
                            continue;
                        }
                        submissionObj.put(column, (Object)result.getString(column));
                    }
                    respArr.put((Object)submissionObj);
                }
                resultObj.put("total", resultCount);
                resultObj.put("items", (Object)respArr);
                JSONObject jSONObject = resultObj;
                return jSONObject;
            }
        }
        catch (Exception e) {
            throw new FormsPortalException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    throw new FormsPortalException((Throwable)e);
                }
            }
        }
        return resultObj;
    }

    public String addComment(String submitID, String commentContent, String owner) throws FormsPortalException {
        Statement prStmtCommentTable = null;
        try {
            String formPath;
            Connection connection = this.getConnection();
            Session currentSession = (Session)this.resourceResolverHelper.getResourceResolverAs(Session.class);
            if (owner == null) {
                owner = currentSession.getUserID();
            }
            if (StringUtils.isNotEmpty((CharSequence)(formPath = this.getProperty(submitID, "formPath")[0])) && this.portalUtilsComponent.isReviewer(currentSession, formPath)) {
                String insertStmt = "INSERT INTO " + this.getCommentTableName() + " (ID, commentId, comment, commentowner, time) values ((?),(?),(?),(?),(?))";
                String commentID = this.fpKeyGeneratorService.getUniqueId();
                prStmtCommentTable = connection.prepareStatement(insertStmt);
                prStmtCommentTable.setString(1, submitID);
                prStmtCommentTable.setString(2, commentID);
                prStmtCommentTable.setString(3, commentContent);
                prStmtCommentTable.setString(4, owner);
                prStmtCommentTable.setString(5, String.valueOf(System.currentTimeMillis()));
                prStmtCommentTable.execute();
                String string = commentID;
                return string;
            }
        }
        catch (Exception e) {
            throw new FormsPortalException((Throwable)e);
        }
        finally {
            try {
                if (prStmtCommentTable != null) {
                    prStmtCommentTable.close();
                }
            }
            catch (SQLException e) {
                throw new FormsPortalException(e.getMessage(), (Throwable)e);
            }
        }
        return "";
    }

    public JSONArray getFormsForSubmissionReview() throws FormsPortalException {
        Connection connection = null;
        ResultSet resultSet = null;
        Session currentSession = null;
        try {
            connection = this.getConnection();
            currentSession = (Session)this.resourceResolverHelper.getResourceResolverAs(Session.class);
            String getformPathStmt = "SELECT DISTINCT formPath FROM " + this.metadataTable + " WHERE status = 'submitted'";
            PreparedStatement formPathstmt = connection.prepareStatement(getformPathStmt);
            resultSet = formPathstmt.executeQuery();
            JSONArray respArr = new JSONArray();
            if (resultSet != null) {
                while (resultSet.next()) {
                    String formPath = null;
                    if (resultSet.getString("formPath") != null) {
                        formPath = resultSet.getString("formPath");
                    }
                    JSONObject currentForm = new JSONObject();
                    if (formPath == null || !this.portalUtilsComponent.isReviewer(currentSession, formPath)) continue;
                    currentForm.put("formPath", (Object)formPath);
                    Node formNode = currentSession.getNode(formPath);
                    Node metadataNode = formNode.getNode("jcr:content/metadata");
                    String formName = metadataNode != null ? metadataNode.getProperty("title").getString() : formNode.getName();
                    currentForm.put("formName", (Object)formName);
                    respArr.put((Object)currentForm);
                }
            }
            JSONArray jSONArray = respArr;
            return jSONArray;
        }
        catch (Exception e) {
            throw new FormsPortalException((Throwable)e);
        }
        finally {
            try {
                if (currentSession.isLive()) {
                    currentSession.logout();
                }
                if (!connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new FormsPortalException((Throwable)e);
            }
        }
    }

    public JSONArray getAllComments(String submitID) throws FormsPortalException {
        Statement prStmtCommentTable = null;
        Connection connection = null;
        JSONArray jsonArr = new JSONArray();
        try {
            connection = this.getConnection();
            Session currentSession = (Session)this.resourceResolverHelper.getResourceResolverAs(Session.class);
            String formPath = this.getProperty(submitID, "formPath")[0];
            if (StringUtils.isNotEmpty((CharSequence)formPath) && this.portalUtilsComponent.isReviewer(currentSession, formPath)) {
                String queryStmt = "SELECT * from " + this.getCommentTableName() + " where ID = '" + submitID + "'";
                prStmtCommentTable = connection.prepareStatement(queryStmt);
                ResultSet rs = prStmtCommentTable.executeQuery();
                while (rs.next()) {
                    JSONObject commentObj = new JSONObject();
                    commentObj.put("comment", (Object)rs.getString("comment"));
                    commentObj.put("owner", (Object)rs.getString("commentowner"));
                    commentObj.put("time", (Object)rs.getString("time"));
                    jsonArr.put((Object)commentObj);
                }
                JSONArray jSONArray = jsonArr;
                return jSONArray;
            }
        }
        catch (Exception e) {
            throw new FormsPortalException((Throwable)e);
        }
        finally {
            try {
                if (prStmtCommentTable != null) {
                    prStmtCommentTable.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new FormsPortalException((Throwable)e);
            }
        }
        return jsonArr;
    }

    public JSONObject submitMetadataAsynchronously(Map<String, Object> submittedMetaPropMap) throws FormsPortalException {
        JSONObject resultJson = this.submitMetadata(submittedMetaPropMap);
        return resultJson;
    }

    private String flattentList(List<?> items) {
        ArrayList<String> itemsListVal = new ArrayList<String>();
        for (Object key : items) {
            if (key == null) continue;
            itemsListVal.add(key.toString());
        }
        return StringUtils.join(itemsListVal, (String)"|");
    }

    private String flattenArray(Object[] items) {
        ArrayList<String> itemsListVal = new ArrayList<String>();
        for (Object key : items) {
            if (key == null) continue;
            itemsListVal.add(key.toString());
        }
        return StringUtils.join(itemsListVal, (String)"|");
    }

    private String[] deflateList(String value) {
        String[] keys = new String[]{""};
        if (!StringUtils.isEmpty((CharSequence)value)) {
            ArrayList<String> items = new ArrayList<String>(Arrays.asList(value.split("\\|")));
            keys = new String[items.size()];
            keys = items.toArray(keys);
            return keys;
        }
        return keys;
    }

    public JSONObject saveSignMetadata(Map<String, Object> metadataMap) throws FormsPortalException {
        Connection connection = null;
        Statement prStmt = null;
        try {
            connection = this.getConnection();
            connection.setAutoCommit(false);
            String id = null;
            if (metadataMap.containsKey("pendingSignID")) {
                id = metadataMap.get("pendingSignID").toString();
            } else {
                id = this.fpKeyGeneratorService.getUniqueId();
                metadataMap.put("pendingSignID", id);
            }
            metadataMap.put("id", id);
            this.insertMetadata(id, metadataMap, connection);
            connection.commit();
            JSONObject submittedInstance = new JSONObject();
            String getSubmittedInstance = "SELECT * FROM " + this.getMetadataTableName() + " WHERE id = (?)";
            prStmt = connection.prepareStatement(getSubmittedInstance);
            prStmt.setString(1, id);
            ResultSet result = prStmt.executeQuery();
            if (result.next()) {
                submittedInstance.put("pendingSignID", (Object)result.getString("pendingSignID"));
                submittedInstance.put("formName", (Object)result.getString("formName"));
                submittedInstance.put("owner", (Object)result.getString("owner"));
                submittedInstance.put("jcr:lastModified", (Object)result.getString("jcr:lastModified"));
            }
            if (result != null) {
                result.close();
            }
            JSONObject jSONObject = submittedInstance;
            return jSONObject;
        }
        catch (Exception e) {
            try {
                if (connection != null) {
                    connection.rollback();
                }
            }
            catch (SQLException e2) {
                throw new FormsPortalException(e2.getMessage(), (Throwable)e2);
            }
            throw new FormsPortalException((Throwable)e);
        }
        finally {
            try {
                if (prStmt != null) {
                    prStmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new FormsPortalException((Throwable)e);
            }
        }
    }

    public JSONArray getPendingSignInstances(String cutPoints) throws FormsPortalException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            JSONArray jSONArray = this.listItems("fp:pendingSign", cutPoints, connection);
            return jSONArray;
        }
        catch (Exception e) {
            throw new FormsPortalException((Throwable)e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new FormsPortalException((Throwable)e);
            }
        }
    }

    public JSONObject readPendingSignInstance(String pendingSignID, String cutPoints) throws FormsPortalException {
        Statement prStmt = null;
        ResultSet resultSet = null;
        Connection connection = null;
        JSONObject resultObj = null;
        try {
            connection = this.getConnection();
            String getItemsStmt = "SELECT * FROM " + this.getMetadataTableName() + " LEFT JOIN " + this.getAdditionalMetadataTableName() + " ON " + this.getMetadataTableName() + "." + "id" + " = " + this.getAdditionalMetadataTableName() + "." + "id" + " WHERE " + this.getMetadataTableName() + "." + "nodeType" + " = (?) AND " + this.getMetadataTableName() + "." + "pendingSignID" + " = (?)AND " + this.getMetadataTableName() + "." + "userdataID" + " IS NOT NULL  order by `" + "jcr:lastModified" + "` asc";
            prStmt = connection.prepareStatement(getItemsStmt);
            prStmt.setString(1, "fp:pendingSign");
            prStmt.setString(2, pendingSignID);
            JSONArray readItems = this.readItems((PreparedStatement)prStmt, "fp:pendingSign", cutPoints, connection);
            if (readItems.length() > 0) {
                resultObj = readItems.getJSONObject(0);
            }
        }
        catch (Exception e) {
            throw new FormsPortalException((Throwable)e);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (prStmt != null) {
                    prStmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new FormsPortalException((Throwable)e);
            }
        }
        return resultObj;
    }

    public JSONArray searchPendingSignInstances(Query query) throws FormsPortalException {
        Statement prStmt = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            String getItemsStmt = "SELECT * FROM " + this.getMetadataTableName() + " LEFT JOIN " + this.getAdditionalMetadataTableName() + " ON " + this.getMetadataTableName() + "." + "id" + " = " + this.getAdditionalMetadataTableName() + "." + "id" + " WHERE " + this.getMetadataTableName() + "." + "nodeType" + " = (?) AND " + this.getMetadataTableName() + "." + "userdataID" + " IS NOT NULL ";
            getItemsStmt = getItemsStmt + this.transformStatementGroup(query.getStatementGroup());
            getItemsStmt = getItemsStmt + " order by `jcr:lastModified` asc";
            prStmt = connection.prepareStatement(getItemsStmt);
            prStmt.setString(1, "fp:pendingSign");
            JSONArray jSONArray = this.readItems((PreparedStatement)prStmt, "fp:pendingSign", query.getCutPoints(), connection);
            return jSONArray;
        }
        catch (Exception e) {
            throw new FormsPortalException((Throwable)e);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (prStmt != null) {
                    prStmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new FormsPortalException((Throwable)e);
            }
        }
    }

    private String transformStatement(com.adobe.fd.fp.service.Statement statement) {
        String constraint = "";
        if (statement.getAttributeName() != null && statement.getAttributeValue() != null) {
            constraint = " " + this.getMetadataTableName() + "." + statement.getAttributeName() + sqlOperatorMap.get(statement.getOperator());
            if (statement.getOperator() != Statement.Operator.EXISTS) {
                constraint = constraint + statement.getAttributeValue();
            }
            constraint = constraint + " ";
        }
        return constraint;
    }

    private String transformStatementGroup(StatementGroup statementGroup) {
        String constraint = "";
        if (statementGroup != null && statementGroup.getStatements() != null) {
            for (com.adobe.fd.fp.service.Statement statement : statementGroup.getStatements()) {
                constraint = constraint + this.transformStatement(statement);
            }
        }
        return constraint;
    }

    private String getCommentTableName() {
        return this.commentTable;
    }

    static {
        multiValuedProps.add("attachmentList");
        multiValuedProps.add("nextSigners");
        sqlOperatorMap.put(Statement.Operator.EQUALS, "=");
        sqlOperatorMap.put(Statement.Operator.NOT_EQUALS, "<>");
        sqlOperatorMap.put(Statement.Operator.LIKE, "LIKE");
        sqlOperatorMap.put(Statement.Operator.NOT, "NOT");
        sqlOperatorMap.put(Statement.Operator.EXISTS, "IS NOT NULL");
    }

    protected void bindPortalUtilsComponent(PortalUtilsComponent portalUtilsComponent) {
        this.portalUtilsComponent = portalUtilsComponent;
    }

    protected void unbindPortalUtilsComponent(PortalUtilsComponent portalUtilsComponent) {
        if (this.portalUtilsComponent == portalUtilsComponent) {
            this.portalUtilsComponent = null;
        }
    }

    protected void bindSlingRepository(SlingRepository slingRepository) {
        this.slingRepository = slingRepository;
    }

    protected void unbindSlingRepository(SlingRepository slingRepository) {
        if (this.slingRepository == slingRepository) {
            this.slingRepository = null;
        }
    }

    protected void bindFpKeyGeneratorService(FPKeyGeneratorService fPKeyGeneratorService) {
        this.fpKeyGeneratorService = fPKeyGeneratorService;
    }

    protected void unbindFpKeyGeneratorService(FPKeyGeneratorService fPKeyGeneratorService) {
        if (this.fpKeyGeneratorService == fPKeyGeneratorService) {
            this.fpKeyGeneratorService = null;
        }
    }

    protected void bindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        this.resourceResolverHelper = resourceResolverHelper;
    }

    protected void unbindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        if (this.resourceResolverHelper == resourceResolverHelper) {
            this.resourceResolverHelper = null;
        }
    }
}

