"use strict";

var CACHE_NAME_DPR = "dpr";
var CACHE_KEY_DPR = "--dpr--";

function setDPR(dprValue) {
	return caches
		.open(CACHE_NAME_DPR)
		.then(function(cache) {
			return cache.put(CACHE_KEY_DPR, new Response(JSON.stringify({ dprValue })));
		}).catch(function(err) {
			console.error("Failed to set DPR value", err.message);
		});
}

function getDPR() {
	return caches
		.open(CACHE_NAME_DPR)
		.then(function(cache) {
			return cache.match(CACHE_KEY_DPR);
		}).then(function(response) {
			if (!response) {
				return 1;
			}

			return response.json();
		}).then(function(value) {
			return parseFloat(value.dprValue);
		}).catch(function(err) {
			console.error("Failed to get DPR value", err.message);
			return 1;
		});
}

self.addEventListener('fetch', function(event) {
	var eventUrl = new URL(event.request.url);
	var match = eventUrl.href.match(/aem_dm_dpr_(\d+(\.\d{1,2})?)x/);
	if (match) {
		var dprValue = match[1];
		event.respondWith(
			setDPR(dprValue)
				.then(function() {
					// use dummy inline image to respond to dummy image request
					return fetch("data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==");
				})
		)
		
		return;
	}

	var isImageReq = eventUrl.pathname.startsWith("/is/image");
	if (isImageReq){
		var hasDprParam = eventUrl.searchParams.get("dpr") !== null;
		var reqParam = eventUrl.searchParams.get("req");
		var hasReqParam = ["message", "set", "userdata", "imageset", "props"].some(function(param) {
			return reqParam && reqParam.indexOf(param) !== -1;
		});
	 
		if (hasDprParam || hasReqParam) {
			return;
		}

		event.respondWith(
			getDPR().then(function(deviceDPR) {
				var returnUrl = eventUrl.href;
				if (deviceDPR && deviceDPR > 1) {
					returnUrl += (returnUrl.indexOf("?") == -1 ? "?" : "&") + "dpr=on," + deviceDPR;
				}

				return fetch(returnUrl, {
					mode: 'no-cors'
				});
			})
		);
	}
});

if (typeof self.skipWaiting === 'function') {
	self.addEventListener('install', function(event) {
		event.waitUntil(self.skipWaiting());
	});
}

