
if ('serviceWorker' in navigator) {
	navigator.serviceWorker
		.register('./srvwrk.js')
		.then(function(registration) {
			var newWorker = registration.installing;
			if (newWorker) {
				newWorker.addEventListener('statechange', () => {
					if (newWorker.state === 'activated') {
						reload();
					}
				});
			}

			console.log('ServiceWorker registration successful with scope: ', registration.scope);
		})
		.catch(function(err) {
			console.error('ServiceWorker registration failed: ', err);
		});

	
	navigator.serviceWorker.addEventListener('controllerchange', function() {
		reload();
	});

	var refreshing = false;
	function reload() {
		if (refreshing) {
			return;
		}

		window.location.reload();
		refreshing = true;
	}
}
