(function(window, hobs) {
    'use strict';

	var ts = new hobs.TestSuite("ExpressionRuleTest", {
		path: "/etc/clientlibs/testForm/ExpressionRuleTest.js",
		register: false
	})	

	.addTestCase(new hobs.TestCase("Checking execution of calculate script")		
		// navigate to the testForm which is to be test
	    .navigateTo("/content/forms/af/testForm.html?wcmmode=disabled")
		// check if adaptive form is loaded
		.asserts.isTrue(function() { return hobs.utils.af.isFormLoaded() })
		.execSyncFct(function() {            
			// create a spy before checking for the expression
			hobs.utils.af.spyOnExpression("panel1.textbox1");            
			// setValue would trigger enter, set the value and exit from the field
	        hobs.utils.af.setValueInDOM("panel1.textbox", "5");            
	    })	   
        // if the calculate expression was setting "textbox1" value to "3", let's also check that
	    .asserts.isTrue(function() { return hobs.utils.af.isExpressionExecuted("panel1.textbox1", "Calculate"); })
		.execSyncFct(function(){
			hobs.utils.af.destroySpyOnExpression("panel1.textbox1");
		})
		.asserts.isTrue(function() { return hobs.utils.af.getComponentModel("panel1.textbox1").value == "5" })
	);

	// register the test suite with testForm
 	window.testsuites.testForm.add(ts);

 }(window, window.hobs));
