/*
 * Decompiled with CFR 0.152.
 */
package custom.reporting.service;

import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.SearchResult;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, immediate=true, label="PeriodicProcessVolume", description="Service for supporting cutom reports pluggable to Process Reporting.")
@Service(value={PeriodicProcessVolume.class})
public class PeriodicProcessVolume {
    private static String[] monthNameList = new DateFormatSymbols().getMonths();
    private static String[] quaterNameList = new String[]{"I", "II", "III", "IV"};
    private Map<Integer, Map<Integer, Long[]>> monthly = new HashMap<Integer, Map<Integer, Long[]>>();
    private Map<Integer, Map<Integer, Long[]>> quaterly = new HashMap<Integer, Map<Integer, Long[]>>();
    private Map<Integer, Long[]> yearly = new HashMap<Integer, Long[]>();
    @Reference(referenceInterface=QueryBuilder.class)
    private QueryBuilder queryBuilder;

    private void addConstraints(PredicateGroup predicateGroup, String processName) {
        Predicate predicate = new Predicate("path");
        predicate.set("path", "/content/reporting/pm");
        predicate.set("exact", "false");
        predicateGroup.add(predicate);
        predicate = new Predicate("type");
        predicate.set("type", "nt:unstructured");
        predicateGroup.add(predicate);
        predicate = new Predicate("property");
        predicate.set("property", "pmNodeType");
        predicate.set("operation", "equals");
        predicate.set("value", "ProcessInstance");
        predicateGroup.add(predicate);
        if (processName != null) {
            predicate = new Predicate("property");
            predicate.set("property", "pmProcessName");
            predicate.set("operation", "equals");
            predicate.set("value", processName);
            predicateGroup.add(predicate);
        }
    }

    private Long[] setFrequency(Long[] frequency, int index) {
        if (frequency == null) {
            frequency = new Long[]{0L, 0L};
        }
        frequency[index] = frequency[index] + 1L;
        return frequency;
    }

    public void populateValues(Session session, String processName) {
        this.monthly = new HashMap<Integer, Map<Integer, Long[]>>();
        this.quaterly = new HashMap<Integer, Map<Integer, Long[]>>();
        this.yearly = new HashMap<Integer, Long[]>();
        PredicateGroup predicateGroup = new PredicateGroup();
        predicateGroup.setAllRequired(true);
        try {
            this.addConstraints(predicateGroup, processName);
            long batchSize = 10000L;
            long start = 0L;
            while (true) {
                Query query = this.queryBuilder.createQuery(predicateGroup, session);
                query.setStart(start);
                query.setHitsPerPage(batchSize);
                SearchResult searchResult = query.getResult();
                Iterator itr = searchResult.getNodes();
                long length = 0L;
                while (itr.hasNext()) {
                    ++length;
                    Node n = (Node)itr.next();
                    Calendar calender = n.getProperty("pmCreateTime").getDate();
                    String status = n.getProperty("pmStatus").getString();
                    int index = 0;
                    if ("COMPLETE".equals(status)) {
                        index = 1;
                    } else {
                        if (!"RUNNING".equals(status)) continue;
                        index = 0;
                    }
                    int month = calender.get(2);
                    int year = calender.get(1);
                    int quater = month < 3 ? 1 : (month < 6 ? 2 : (month < 9 ? 3 : 4));
                    Map<Integer, Long[]> yearMonthMap = this.monthly.get(year);
                    if (yearMonthMap == null) {
                        yearMonthMap = new HashMap<Integer, Long[]>();
                    }
                    Long[] frequency = yearMonthMap.get(month);
                    frequency = this.setFrequency(frequency, index);
                    yearMonthMap.put(month, frequency);
                    this.monthly.put(year, yearMonthMap);
                    Map<Integer, Long[]> yearQuaterMap = this.quaterly.get(year);
                    if (yearQuaterMap == null) {
                        yearQuaterMap = new HashMap<Integer, Long[]>();
                    }
                    frequency = yearQuaterMap.get(quater);
                    frequency = this.setFrequency(frequency, index);
                    yearQuaterMap.put(quater, frequency);
                    this.quaterly.put(year, yearQuaterMap);
                    frequency = this.yearly.get(year);
                    frequency = this.setFrequency(frequency, index);
                    this.yearly.put(year, frequency);
                }
                if (length >= batchSize) {
                    start += batchSize;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<String, Long[]> getMonthly() {
        LinkedHashMap<String, Long[]> result = new LinkedHashMap<String, Long[]>();
        TreeSet<Integer> years = new TreeSet<Integer>(this.monthly.keySet());
        for (Integer year : years) {
            Map<Integer, Long[]> yearMonthMap = this.monthly.get(year);
            TreeSet<Integer> months = new TreeSet<Integer>(yearMonthMap.keySet());
            for (Integer month : months) {
                String str = monthNameList[month] + " " + year;
                result.put(str, yearMonthMap.get(month));
            }
        }
        return result;
    }

    public Map<String, Long[]> getQuaterly() {
        LinkedHashMap<String, Long[]> result = new LinkedHashMap<String, Long[]>();
        TreeSet<Integer> years = new TreeSet<Integer>(this.quaterly.keySet());
        for (Integer year : years) {
            Map<Integer, Long[]> quaterMonthMap = this.quaterly.get(year);
            TreeSet<Integer> quaters = new TreeSet<Integer>(quaterMonthMap.keySet());
            for (Integer quater : quaters) {
                String str = quaterNameList[quater - 1] + " " + year;
                result.put(str, quaterMonthMap.get(quater));
            }
        }
        return result;
    }

    public Map<Integer, Long[]> getYearly() {
        return this.yearly;
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }
}

