ContextHub.console.log(ContextHub.Shared.timestamp(), '[loading] contexthub.segment-engine.scripts.custom - script.isAlison50.js');

(function($) {
    'use strict';

    /**
     * Returns true if name of the current month is march.
     *
     * @returns {Boolean}
     */
    var isAlison50 = function() {
        var AGE = '02-persisted-store/age';
        var NAME = '02-persisted-store/name';

        /* let the SegmentEngine know when script should be re-run */
        this.dependOn(ContextHub.SegmentEngine.Property(AGE));
        this.dependOn(ContextHub.SegmentEngine.Property(NAME));

        var currentAge = Number(ContextHub.getItem(AGE));
        var currentName = ContextHub.getItem(NAME);

        return (currentAge === 50) && (currentName === 'Alison');
    };

    /* register function */
    ContextHub.SegmentEngine.ScriptManager.register('is-alison-50', isAlison50);

})(ContextHubJQ);