ContextHub.console.log(ContextHub.Shared.timestamp(), '[loading] contexthub.segment-engine.operators.custom - operator.twiceBigger.js');

(function($) {
    'use strict';

    /**
     * Compares two objects.
     *
     * @private
     * @param {Object} left - left side
     * @param {Object} right - right side
     * @returns {Boolean}
     */
    var twiceBiggerGeneric = function(left, right) {
        return (left * 2) > right;
    };

    /**
     * Compares two numbers. Arguments are converted to Number object before comparison.
     *
     * @private
     * @param {Number} left - left side
     * @param {Object} right - right side
     * @returns {Boolean}
     */
    var twiceBiggerNumber = function(left, right) {
        left = Number(String(left) || undefined);
        right = Number(String(right) || undefined);

        return (left * 2) > right;
    };

    /* comparison operators registration */
    ContextHub.SegmentEngine.OperatorManager.register('twiceBigger', twiceBiggerGeneric);
    ContextHub.SegmentEngine.OperatorManager.register('twiceBigger.number', twiceBiggerNumber);

})(ContextHubJQ);